(* These terminal i/o routines are highly system-dependent and have been
   designed for DVItoVDU and its auxiliary modules.

   Notes:
 - InitScreenIO saves the current tty characteristics,
   then sets the mode to cbreak with no echo.
   Clients should therefore call RestoreTerminal before terminating.
 - WriteBuffer or WriteLine must be called to explicitly update the terminal
   (e.g., just before a read) or to synchronize output with writes
   from other modules that don't use ScreenIO.
 - WriteString assumes the end of a string is the first blank (if not full),
   so clients need to replace calls like WriteString('xxx = ') with
   WriteString('xxx ='); WriteChar(' ').
*)

CONST
   maxbufsize  = 128;   (* size of output buffer *)
   maxbufsizem = maxbufsize - 1;

   CR    = CHR(10);     (* SYSDEP: char read upon hitting Return key *)
   CTRLC = CHR(0);      (* SYSDEP: interrupt, see unixio *)
   CTRLZ = CHR(1);      (* SYSDEP: suspend, see unixio *)
   (* SYSDEP: unixio puts CTRLC and CTRLZ into input buffer (along with CR)
      upon getting a ^C or ^Z interrupt.
      (It can't put CHR(3) and CHR(26) into buffer
      because tty will detect another interrupt and we'll loop forever!)
   *)
   NUL = CHR(  0b);
   FF  = CHR( 14b);
   CAN = CHR( 30b);
   ESC = CHR( 33b);
   FS  = CHR( 34b);
   GS  = CHR( 35b);
   US  = CHR( 37b);
   XXX = CHR(377b);

TYPE
   screenbuf = PACKED ARRAY [0..maxbufsizem] OF CHAR;

VAR
   buf    : screenbuf;                        (* terminal output buffer *)
   buflen : 0..maxbufsize;                    (* chars in output buffer *)
   TeXtoASCII : ARRAY [NUL..XXX] OF CHAR;     (* TeX char to ASCII char *)

PROCEDURE InitScreenIO;                         EXTERNAL;
PROCEDURE ReadChar (VAR ch : CHAR);             EXTERNAL;
PROCEDURE ReadString (VAR s : string);          EXTERNAL;
FUNCTION  BusyRead (VAR ch : CHAR) : BOOLEAN;   EXTERNAL;
PROCEDURE WriteChar (ch: CHAR);                 EXTERNAL;
PROCEDURE WriteString (s: string);              EXTERNAL;
PROCEDURE WriteInt (i : INTEGER);               EXTERNAL;
PROCEDURE WriteLine;                            EXTERNAL;
PROCEDURE WriteBuffer;                          EXTERNAL;
PROCEDURE RestoreTerminal;                      EXTERNAL;
