/* Original Author:         Andrew Trevorrow
   Implementation: Modula-2 under VAX/UNIX 4.2 BSD
   Date Started:   June, 1986

   Description:
   All the routines in this module are of course highly SYSDEP!
   See pxl.inf for a description of PXL files.
   Although a PXL file is considered to be a stream of 32-bit words,
   we will be randomly positioning to PXL bytes and then reading
   bytes via GetPXLByte() SignedPXLPair etc.

   This version converted to C and ported to BSD and System V UNIX by
   some chaps at Kernel Technology up to September 1989.  Contact
   mjh@uk.co.kernel (Mark J. Hewitt) with bug fixes etc.

   Involved were:	Mark J. Hewitt
   			Dave Dixon
			Marc Hadley
*/

#include "def.h"

static char *sccsid[] = "@(#)pxlreader.c	1.1";

extern int SignExtend(),
           NoSignExtend();

FILE * PXLfile;

/******************************************************************************/

short   OpenPXLFile (filename)
char *filename;
{
    extern FILE *ConvertPKfile();
    
/* Return TRUE if given file can be opened. */

  PXLfile = ConvertPKfile (filename);
  return (PXLfile != NULL);	/* PXLfile open if not NULL */
}

/******************************************************************************/

void MoveToPXLByte (offset)
unsigned  offset;
{
/* Set current position in PXLfile to given byte offset from start of file,
   where first byte is at offset 0.
*/

  if (fseek (PXLfile, (long) offset, 0) < 0)
  {
    WriteString ("fseek failed in MoveToPXLByte()");
    WriteLn ();
    RestoreTerminal ();
    exitprog (1);
  }
}

/******************************************************************************/

void MoveToPXLDirectory ()
{
/* The word offset of the font directory is given in the 2nd last word.
   The last word should contain 1001 in TeX82 PXL files.
*/

  unsigned int  dirptr;

/* move to byte at start of 2nd last PXL word */
  if (fseek (PXLfile, -8, 2) < 0)
  {
    WriteString ("fseek failed in MoveToPXLDirectory()");
    WriteLn ();
    RestoreTerminal ();
    exitprog (1);
  }
  dirptr = 4 * ((unsigned) SignedPXLQuad ());/* byte offset of font directory */
/* check last word contains 1001 */
  if (SignedPXLQuad () != 1001)
  {
    WriteString ("Bad PXL file! id word <> 1001.");
    WriteLn ();
    RestoreTerminal ();
    exitprog (1);
  }
  MoveToPXLByte (dirptr);	/* move to starting byte of font directory */
}

/******************************************************************************/

/* Here are the functions used to get byte/s from PXLfile. */

int   GetPXLByte ()
{
/* Return unsigned value of next byte in PXLfile and advance. */

        return (NoSignExtend (PXLfile, 1));
}

/******************************************************************************/

int   GetTwoPXLBytes ()
{
/* Return unsigned value of next 2 bytes and advance. */

        return (NoSignExtend (PXLfile, 2));
}

/******************************************************************************/

int   SignedPXLPair ()
{

/* Return the next 2 bytes, possibly signed, and advance. */

        return (SignExtend (PXLfile, 2));
}

/******************************************************************************/

int   SignedPXLQuad ()
{
  int   res;

/* Return the value (possibly signed) of the next 4 bytes and advance. */

  res = (SignExtend (PXLfile, 4));
  return (res);
}

/******************************************************************************/

void ClosePXLFile ()
{

/* Close the currently open PXL file. */

  (void) fclose (PXLfile);
}










