#include <stdio.h>
#include "gram.h"

/* List of helper functions. */
int          helper_index = -1 ;
char         helper [MAX_HELPERS][MAX_STR_LEN] ;

/* List of operators and algorithms. */
int          op_table_index = -1 ;
OP_TABLE     op_table [MAX_OPS] ;

/* List of properties in a descriptor. */
int          prop_index = -1 ;
PROP         prop [MAX_PROPS] ;

/* List of operator pairs, that translate to one another: O1 => O2. */
int          opr_map_index = -1 ;
OPR_MAP	     opr_map [MAX_OPS] ;

/* List of T-rules discarded by Prairie when translated to Volcano. */
int          junk_trule_index = -1 ;
int          junk_trule [MAX_RULES] ;

/* List of T-rules in which the two expressions "weakly" unify, i.e.,
   they don't unify in Prairie, but they do in Volcano, e.g.,
   RET(F1):D2 => RET(F11):D3. */
int          weak_junk_trule_index = -1 ;
int          weak_junk_trule [MAX_RULES] ;

/* List of I-rules for which the cost needs to be reestimated. */
int          irule_cost_reestimate_index = -1 ;
int          irule_cost_reestimate [MAX_RULES] ;

/* List of T-rules and the layers they appear in. */
int               trule_layer_info_index = -1 ;
RULE_LAYER_INFO   trule_layer_info [MAX_RULES] ;
int               irule_layer_info_index = -1 ;
RULE_LAYER_INFO   irule_layer_info [MAX_RULES] ;

/* List of layers with their names, numbers are next layer information. */
int          layer_index = -1 ;
LAYERS       layer [MAX_LAYERS] ;

int          pass = 0 ;

extern int   yyparse () ;
extern FILE  *yyin ;
int          find () ;
FILE         *pr_out ;
FILE         *dbih ;
FILE         *dbic ;
FILE         *opfile ;
FILE         *algfile ;
FILE         *working ;

main()
{
    int i ;

    pr_out = fopen (PRAIRIE_OUTPUT, "w") ;
    dbih = fopen (DBIH, "w") ;
    dbic = fopen (DBIC, "w") ;
    opfile = fopen (OPERATOR_FILE, "w") ;
    algfile = fopen (ALGORITHM_FILE, "w") ;
    yyin = fopen (PRAIRIE_INPUT, "r") ;
    working = fopen (PRAIRIE_WORKING, "w") ;
    yyparse () ;
    fclose (pr_out) ;
    fclose (dbih) ;
    fclose (dbic) ;
    fclose (opfile) ;
    fclose (algfile) ;
    fclose (working) ;

    for (i = 0; i <= helper_index; i++)
        printf ("Helper: \"%s\"\n", helper[i]) ;

    for (i = 0; i <= prop_index; i++)
    {
        switch (prop[i].type)
        {
        case (LOG_PROP) :
            printf ("LOG_PROP: ") ;
            break ;
        case (PHY_PROP) :
            printf ("PHY_PROP: ") ;
            break ;
        case (COST) :
            printf ("COST: ") ;
            break ;
        case (OP_ARG) :
            printf ("OP_ARG: ") ;
            break ;
        case (METHOD) :
            printf ("METHOD: ") ;
            break ;
        }
        printf ("%s %s%s%s\n", prop[i].declarator, prop[i].prefix,
                prop[i].name, prop[i].postfix) ;
    }

    for (i = 0; i <= irule_cost_reestimate_index; i++)
        printf ("Reestimate I-rule %d.\n", irule_cost_reestimate[i]) ;
}
