




_I_n_t_r_o_d_u_c_t_i_o_n

        Elvis is a clone of vi/ex, the standard UNIX editor. Elvis supports
     nearly all of the vi/ex commands, in both visual mode and colon mode.

        Like vi/ex, elvis stores most of the  text  in  a  temporary  file,
     instead of RAM. This allows it to edit files that are too large to fit
     in a single process' data space.

        Elvis runs under BSD UNIX, AT&T SysV UNIX, Minix, MS-DOS, and Atari
     TOS.  Ports to other operating systems are being worked on; contact me
     before you start porting it to some other OS,  because  somebody  else
     may have already done it for you.

        Elvis   is   freely  redistributable,  in  either  source  form  or
     executable form.


  _O_v_e_r_v_i_e_w _o_f _E_l_v_i_s

        The user interface of elvis/vi/ex is weird.  There  are  two  major
     comand  modes  in  Elvis,  and  a  few  text input modes as well. Each
     command mode has a command which allows you to  switch  to  the  other
     mode.

        You  will  probably  use  the _v_i_s_u_a_l _c_o_m_m_a_n_d _m_o_d_e most of the time.
     This is the mode that elvis normally starts up in.

        In visual command mode, the entire screen is filled with  lines  of
     text  from  your  file.  Each  keystroke  is interpretted as part of a
     visual command. If you start typing text, it will _n_o_t be inserted,  it
     will  be  treated as part of a command. To insert text, you must first
     give an "insert text" command. This will take some  getting  used  to.
     (An alternative exists. Lookup the "inputmode" option.)

        The  _c_o_l_o_n  _m_o_d_e is quite different. Elvis displays a ":" character
     on the bottom line of the screen, as a prompt. You are  then  expected
     to  type  in  a  command  line  and  hit  the <Return> key. The set of
     commands recognized in the colon mode is different from visual mode's.


















                                    - 1 -








_V_i_s_u_a_l _M_o_d_e _C_o_m_m_a_n_d_s

        Most visual mode commands are one  keystroke  long.  The  following
     table  lists  the  operation  performed  by  each  keystroke, and also
     denotes any options or arguments that it accepts. Notes at the end  of
     the table describe the notation used in this table.

        In  addition  to the keys listed here, your keyboard's "arrow" keys
     will be interpretted as the appropriate cursor movement commands.  The
     same goes for <PgUp> and <PgDn>, if your keyboard has them. There is a
     colon mode command (to be described later) which  will  allow  you  to
     define other keys, such as function keys.

        A tip: visual command mode looks a lot like text input mode. If you
     forget which mode you're in, just hit the <Esc> key. If  elvis  beeps,
     then  you're  in visual command mode. If elvis does not beep, then you
     were in input mode, but by hitting <Esc> you  will  have  switched  to
     visual command mode. So, one way or another, after <Esc> elvis will be
     ready for a command.

command         description                                             type
---------------+-------------------------------------------------------+--------
        ^A      ---
        ^B      Move toward the top of the file by 1 screenful
        ^C      ---
count   ^D      scroll down <count> lines (default 1/2 screen)
count   ^E      scroll up <count> lines
        ^F      move toward the bottom of the file by 1 screenful
        ^G      show file status, and the current line #
count   ^H      move left, like h                                       MOVE
        ^I      ---
count   ^J      move down                                               MOVE
        ^K      ---
        ^L      redraw the screen
count   ^M      move to the front of the next line                      MOVE
count   ^N      move down                                               MOVE
        ^O      ---
count   ^P      move up                                                 MOVE
        ^Q      ---
        ^R      redraw the screen
        ^S      ---
        ^T      ---
count   ^U      scroll up <count> lines (default 1/2 screen)
        ^V      ---
        ^W      ---
        ^X      ---
count   ^Y      scroll down <count> lines
        ^Z      ---
        ESC     ---
        ^\      ---
        ^]      if the cursor is on a tag name, go to that tag
        ^^      ---
        ^_      ---
count   SPC     move right,like l                                       MOVE
         ! mv   run the selected lines thru an external filter program
         " key  select which cut buffer to use next

                                    - 2 -








count    # +    increment a number                                      EDIT
         $      move to the rear of the current line                    MOVE
         %      move to the matching (){}[] character                   MOVE
         &      ---
         ' key  move to a marked line                                   MOVE
count    (      move backward <count> sentences                         MOVE
count    )      move forward <count> sentences                          MOVE
         *      ---
count    +      move to the front of the next line                      MOVE
count    ,      repeat the previous [fFtT] but in the other direction   MOVE
count    -      move to the front of the preceding line                 MOVE
count    .      repeat the previous "edit" command
         / text search forward for a given regular expression           MOVE
         0      if not part of count, move to 1st char of this line     MOVE
         1      part of count
         2      part of count
         3      part of count
         4      part of count
         5      part of count
         6      part of count
         7      part of count
         8      part of count
         9      part of count
         : text run single EX cmd
count    ;      repeat the previous [fFtT] cmd                          MOVE
         < mv   shift text left                                         EDIT
         =      ---
         > mv   shift text right                                        EDIT
         ? text search backward for a given regular expression          MOVE
         @      ---
count    A inp  append at end of the line                               EDIT
count    B      move back Word                                          MOVE
         C inp  change text from the cursor through the end of the line EDIT
         D      delete text from the cursor through the end of the line EDIT
count    E      move end of Word                                        MOVE
count    F key  move leftward to a given character                      MOVE
count    G      move to line #<count> (default is the bottom line)      MOVE
count    H      move to home row (the line at the top of the screen)
count    I inp  insert at the front of the line (after indents)         EDIT
count    J      join lines, to form one big line                        EDIT
         K      look up keyword
count    L      move to last row (the line at the bottom of the screen)
         M      move to middle row
         N      repeat previous search, but in the opposite direction   MOVE
count    O inp  open up a new line above the current line               EDIT
         P      paste text before the cursor
         Q      quit to EX mode
         R inp  overtype                                                EDIT
count    S inp  change lines, like <count>cc
count    T key  move leftward *almost* to a given character             MOVE
         U      Undo all recent changes to the current line
         V      ---
count    W      move forward <count> Words                              MOVE
count    X      delete the character(s) to the left of the cursor       EDIT
count    Y      yank text line(s) (copy them into a cut buffer)
         Z Z    save the file & exit

                                    - 3 -








         [ [    move back 1 section                                     MOVE
         \      ---
         ] ]    move forward 1 section                                  MOVE
         ^      move to the front of the current line (after indent)    MOVE
         _      ---
         ` key  move to a marked character                              MOVE
count    a inp  insert text after the cursor                            EDIT
count    b      move back <count> words                                 MOVE
         c mv   change text                                             EDIT
         d mv   delete text                                             EDIT
count    e      move forward to the end of the current word             MOVE
count    f key  move rightward to a given character                     MOVE
         g      ---
count    h      move left                                               MOVE
count    i inp  insert text at the cursor                               EDIT
count    j      move down                                               MOVE
count    k      move up                                                 MOVE
count    l      move right                                              MOVE
         m key  mark a line or character
         n      repeat the previous search                              MOVE
count    o inp  open a new line below the current line                  EDIT
         p      paste text after the cursor
         q      ---
count    r key  replace <count> chars by a given character              EDIT
count    s inp  replace <count> chars with text from the user           EDIT
count    t key  move rightward *almost* to a given character            MOVE
         u      undo the previous edit command
         v      ---
count    w      move forward <count> words                              MOVE
count    x      delete the character that the cursor's on               EDIT
         y mv   yank text (copy it into a cut buffer)
         z key  scroll current line to the screen's +=top -=bottom .=middle
count    {      move back <count> paragraphs                            MOVE
count    |      move to column <count> (the leftmost column is 1)
count    }      move forward <count> paragraphs                         MOVE
         ~      switch a character between uppercase & lowercase        EDIT
        DEL     ---
--------------------------------------------------------------------------------

count   Many commands may be preceded by a count.  This is a sequence of digits
        representing a decimal number.  For most commands that use a count,
        the command is repeated <count> times.  The count is always optional,
        and usually defaults to 1.

key     Some commands require two keystrokes.  The first key always determines
        which command is to be executed.  The second key is used as a parameter
        to the command.

mv      Six commands (! < > c d y) operate on text between the cursor and some
        other position.  To specify that other position, you are expected to
        follow the command keystroke with a movement command.  Also, you may
        have the command operate on the whole line that the cursor is on by
        typing the command key a second time.

inp     Many commands allow the user to interactively enter text.


                                    - 4 -








EDIT    These commands affect text, and may be repeated by the "." command.

MOVE    These commands move the cursor, and may be used to specify the extent
        of a member of the "mv" class of commands.


  _I_n_p_u_t _M_o_d_e

        You can't type text into your file  directly  from  visual  command
     mode.  Instead,  you must first give a command which will put you into
     input mode. The commands to do this are A/C/I/O/R/S/a/i/o/s.

        The S/s/C/c commands temporarily place a $ at the end of  the  text
     that they are going to change.

        In  input  mode,  all  keystrokes are inserted into the text at the
     cursor's position, except for the following:
            ^A      insert a copy of the last input text
            ^D      delete one indent character
            ^H      (backspace) erase the character before the cursor
            ^L      redraw the screen
            ^M      (carriage return) insert a newline (^J, linefeed)
            ^P      insert the contents of the cut buffer
            ^R      redraw the screen, like ^L
            ^T      insert an indent character
            ^U      backspace to the beginning of the line
            ^V      insert the following keystroke, even if special
            ^W      backspace to the beginning of the current word
            ^Z ^Z   write the file & exit elvis
            ^[      (ESCape) exit from input mode, back to command mode

        Also, on some systems, ^S may stop output, ^Q may  restart  output,
     and  ^C  may  interupt  execution.  ^@  (the  NUL character) cannot be
     inserted.

        The R visual command puts you in overtype mode, which is a slightly
     different form of input mode. In overtype mode, each time you insert a
     character, one of the old characters is deleted from the file.


  _A_r_r_o_w _k_e_y_s _i_n _I_n_p_u_t _M_o_d_e

        The arrow keys can be used to move the cursor in input mode.  (This
     is  an  extension;  the  real  Vi  doesn't support arrow keys in input
     mode.) The <PgUp>, <PgDn>, <Home>, and <End> keys work in input  mode,
     too. The <Delete> key deletes a single character in input mode.

        The  best  thing about allowing arrow keys to work in input mode is
     that as long as you're in input mode, Elvis seems  to  have  a  fairly
     ordinary  user interface. With most other text editors, you are always
     in either insert mode or replace mode, and you can use the arrow  keys
     at  any time to move the cursor. Now, Elvis can act like that, too. In
     fact, with the new "inputmode" option and  the  "control-Z  control-Z"
     input  command,  you may never have to go into visual command mode for
     simple edit sessions.


                                    - 5 -








  _D_i_g_r_a_p_h_s



        Elvis supports digraphs as a way to enter non-ASCII  characters.  A
     digraph  is a character which is composed of two other characters. For
     Elvis, the first character must be an ASCII punctuation character, and
     the  second  can  be  any  other  ASCII  character.  For  example,  an
     apostrophe and the letter i could be defined as a digraph which is  to
     be stored & displayed as an accented i.

        Elvis  has  no built-in digraphs, since there is no single standard
     for extended ASCII character sets. You must explicitly define a custom
     set  of  digraphs  for the non-ASCII characters that your computer (or
     terminal) uses. Digraphs are defined via the ":digraph" command.

        To actually use a digraph, you must first be in  input  mode.  Type
     the  punctuation  character,  then  hit <Backspace>, and then type the
     other character. Elvis will then substitute the non-ASCII character in
     their place.





































                                    - 6 -








_C_o_l_o_n _M_o_d_e _C_o_m_m_a_n_d_s

        To  use  colon  mode  commands, you must switch from visual command
     mode to colon command mode. The visual mode commands to  do  this  are
     ":" for a single colon command, or "Q" for many colon mode commands.

        Lines           command         arguments
        ---------------+---------------+-------------------------------
        [line]          append
                        args            [files]
                        cd              [directory]
                        chdir           [directory]
        [line][,line]   change
        [line][,line]   copy            line
        [line][,line]   debug[!]
        [line][,line]   delete          ["x]
                        digraph[!]      [XX [Y]]
                        edit[!]         [file]
                        ex[!]           [file]
                        file
        [line][,line]   global          /regexp/ command
        [line]          insert
        [line][,line]   join
        [line][,line]   list
                        map[!]          key mapped_to
        [line]          mark            x
                        mkexrc
        [line][,line]   move            line
                        next[!]         [files]
                        Next[!]
                        previous[!]
        [line][,line]   print
        [line]          put             ["x]
                        quit[!]
        [line]          read            file
                        rewind[!]
                        set             [options]
                        source          file
        [line][,line]   substitute      /regexp/replacement/[p][g]
                        tag[!]          tagname
        [line][,line]   to              line
                        undo
                        unmap[!]        key
                        validate[!]
                        version
        [line][,line]   vglobal         /regexp/ command
                        visual
                        wq
        [line][,line]   write[!]        [[>>]file]
                        xit[!]
        [line][,line]   yank            ["x]
        [line][,line]   !               command
        [line][,line]   <
        [line][,line]   =
        [line][,line]   >


                                    - 7 -








  _L_i_n_e _S_p_e_c_i_f_i_e_r_s



        Line  specifiers  are  always  optional. The first line specifer of
     most commands usually defaults to the current line.  The  second  line
     specifer  usually defaults to be the same as the first line specifier.
     Exceptions are :write, :global, and :vglobal, which act on  all  lines
     of the file by default, and :!, which acts on no lines by default.

        Line  specifiers  consist  of an absolute part and a relative part.
     The absolute part of a line specifer may be either  an  explicit  line
     number,  a  mark,  a  dot to denote the current line, a dollar sign to
     denote the last line of the file, or a forward or backward search.

        An explicit line number is simply a decimal number, expressed as  a
     string of digits.

        A  mark  is  typed  in as an apostrophe followed by a letter. Marks
     must be set before they can be used. You can  set  a  mark  in  visual
     command  mode  by  typing "m" and a letter, or you can set it in colon
     command mode via the "mark" command.

        A forward search is typed in as a regular expression surrounded  by
     slash  characters;  searching  begins  at the default line. A backward
     search is typed in as a  regular  expression  surrounded  by  question
     marks; searching begins at the line before the default line.

        If you omit the absolute part, then the default line is used.

        The  relative  part  of  a  line  specifer is typed as a "+" or "-"
     character followed by a decimal number. The  number  is  added  to  or
     subtracted from the absolute part of the line specifier to produce the
     final line number.

        As a special case, the % character may be used to specify all lines
     of  the  file.  It  is roughly equivelent to saying 1,$. This can be a
     handy shortcut.

        Some examples:
            :p              print the current line
            :37p            print line 37
            :'gp            print the line which contains mark g
            :/foo/p         print the next line that contains "foo"
            :$p             print the last line of the file
            :20,30p         print lines 20 through 30
            :1,$p           print all lines of the file
            :%p             print all lines of the file
            :/foo/-2,+4p    print 5 lines around the next "foo"








                                    - 8 -








  _T_e_x_t _E_n_t_r_y _C_o_m_m_a_n_d_s
            [line] append
            [line][,line] change ["x]
            [line] insert

        The (a)ppend command inserts text after the specified line.

        The (i)nsert command inserts text before the specified line.

        The (c)hange command copies the range of lines into a  cut  buffer,
     deletes them, and inserts new text where the old text used to be.

        For  all of these commands, you indicate the end of the text you're
     inserting by hitting ^D or by entering a line which  contains  only  a
     period.


  _C_u_t & _P_a_s_t_e _C_o_m_m_a_n_d_s
            [line][,line] delete ["x]
            [line][,line] yank ["x]
            [line] put[!] ["x]
            [line][,line] copy line
            [line][,line] to line
            [line][,line] move line

        The (d)elete command copies the specified range of lines into a cut
     buffer, and then deletes them.

        The (y)ank command copies the specified range of lines into  a  cut
     buffer, but does *not* delete them.

        The  (pu)t  command  inserts  text  from  a  cut  buffer  after the
     specified line -- or before it if the ! is present.

        The (co)py and (t)o commands yank the specified range of lines  and
     then immediately paste them after some other line.

        The  (m)ove  command  deletes the specified range of lines and then
     immediately pastes them after some other line. If the destination line
     comes  after  the deleted text, then it will be adjusted automatically
     to account for the deleted lines.


  _D_i_s_p_l_a_y _T_e_x_t _C_o_m_m_a_n_d_s
            [line][,line] print
            [line][,line] list

        The (p)rint command displays the specified range of lines.

        The (l)ist command also displays them, but it is  careful  to  make
     control characters visible.






                                    - 9 -








  _G_l_o_b_a_l _O_p_e_r_a_t_i_o_n_s _C_o_m_m_a_n_d_s
            [line][,line] global /regexp/ command
            [line][,line] vglobal /regexp/ command

        The  (g)lobal  command  searches through the lines of the specified
     range (or through the whole file if no range is specified)  for  lines
     that  contain  a given regular expression. It then moves the cursor to
     each of these lines and runs some other command on them.

        The (v)global command is similar, but it searches  for  lines  that
     _d_o_n'_t contain the regular expression.


  _L_i_n_e _E_d_i_t_i_n_g _C_o_m_m_a_n_d_s
            [line][,line] join
            [line][,line] ! program
            [line][,line] <
            [line][,line] >
            [line][,line] substitute /regexp/replacement/[p][g]

        The  (j)oin  command  catenates  all  lines  in the specified range
     together to form one big line. If only a  single  line  is  specified,
     then the following line is catenated onto it.

        The  !  command  runs  an  external  filter  program, and feeds the
     specified range of lines to it's stdin. The lines are then replaced by
     the  output of the filter. A typical example would be ":'a,'z!sort" to
     sort the lines 'a,'z.

        The < and > commands shift the specified range  of  lines  left  or
     right,  normally  by  the  width  of 1 tab character. The "shiftwidth"
     option determines the shifting amount.

        The (s)ubstitute command finds the regular expression in each line,
     and  replaces  it with the replacement text. The "p" option causes the
     altered lines to be printed, and the "g" option permits all  instances
     of  the  regular expression to be found & replaced. (Without "g", only
     the first occurrence in each line is replaced.)


  _U_n_d_o _C_o_m_m_a_n_d
            undo

        The (u)ndo command restores the file to the state it was in  before
     your most recent command which changed text.


  _C_o_n_f_i_g_u_r_a_t_i_o_n & _S_t_a_t_u_s _C_o_m_m_a_n_d_s
            map[!] [key mapped_to]
            unmap[!] key
            digraph[!] [XX [Y]]
            set [options]
            mkexrc
            [line] mark x
            visual
            version

                                    - 10 -








            [line][,line] =
            file
            source file

        The  (ma)p  command allows you to configure Elvis to recognize your
     function keys, and treat them as though they  transmitted  some  other
     sequence of characters. Normally this mapping is done only when in the
     visual command mode, but with the [!] present it will map  keys  under
     all  contexts. When this command is given with no arguments, it prints
     a table showing all mappings currently in effect. When called with two
     arguments,  the  first  is  the sequence that your function key really
     sends, and the second is the sequence that you want Elvis to treat  it
     as having sent.

        The  (unm)ap command removes key definitions that were made via the
     map command.

        The (di)graph command allows you to display  the  set  of  digraphs
     that  Elvis  is  using,  or  add/remove  a digraph. To list the set of
     digraphs, use the digraph command with no arguments. To add a digraph,
     you  should give the digraph command two arguments. The first argument
     is the two ASCII characters that are to be combined; the second is the
     non-ASCII  character  that  they  represent. The non-ASCII character's
     most significant bit is automatically  set  by  the  digraph  command,
     unless  to  append  a  !  to the command name. Removal of a digraph is
     similar to adding a digraph, except that  you  should  leave  off  the
     second argument.

        The  (se)t  command allows you examine or set various options. With
     no arguments, it  displays  the  values  of  options  that  have  been
     changed.  With the single argument "all" it displays the values of all
     options, regardless of whether they've been  explicitly  set  or  not.
     Otherwise, the arguments are treated as options to be set.

        The  (mk)exrc  command  saves  the  current configuration to a file
     called ".exrc" in the current directory.

        The mar(k) command defines a named mark  to  refer  to  a  specific
     place  in  the  file. This mark may be used later to specify lines for
     other commands.

        The (vi)sual command puts the editor into visual mode.  Instead  of
     emulating ex, Elvis will start emulating vi.

        The (ve)rsion command tells you that what version of Elvis this is.

        The  =  command  tells  you  what  line  you  specified, or, if you
     specified a range of lines, it will tell you both  endpoints  and  the
     number of lines included in the range.

        The  (f)ile  command tells you the name of the file, whether it has
     been modified, the number of lines in the file, and the  current  line
     number.




                                    - 11 -








        The (so)urce command reads a sequence of colon mode commands from a
     file, and interprets them.


  _M_u_l_t_i_p_l_e _F_i_l_e _C_o_m_m_a_n_d_s
            args [files]
            next[!] [files]
            Next[!]
            previous[!]
            rewind[!]

        When you invoke Elvis from your shell's command line, any filenames
     that  you  give to Elvis as arguments are stored in the args list. The
     (ar)gs command will display this list, or define a new one.

        The (n)ext command switches from the current file to the  next  one
     in the args list. You may specify a new args list here, too.

        The  (N)ext and (pre)vious commands (they're really aliases for the
     same command) switch from the current file to the  preceding  file  in
     the args list.

        The  (rew)ind  command  switches from the current file to the first
     file in the args list.


  _S_w_i_t_c_h_i_n_g _F_i_l_e_s _C_o_m_m_a_n_d_s
            edit[!] [file]
            tag[!] tagname

        The (e)dit command allows to switch from the current file  to  some
     other file. This has nothing to do with the args list, by the way.

        The (ta)g command looks up a given tagname in a file called "tags".
     This tells it which file the tag is in, and how to  find  it  in  that
     file. Elvis then switches to the tag's file and finds the tag.


  _E_x_i_t _C_o_m_m_a_n_d_s
            quit[!]
            wq
            xit

        The (q)uit command exits from the editor without saving your file.

        The (wq) command writes your file out, then then exits.

        The (x)it command is similar to the (wq) command, except that (x)it
     won't bother to write your file if you haven't modified it.








                                    - 12 -








  _F_i_l_e _I/_O _C_o_m_m_a_n_d_s
            [line] read file
            [line][,line] write[!][[>>]file]

        The (r)ead command gets text from another file and inserts it after
     the specified line.

        The  (w)rite  command writes the whole file, or just part of it, to
     some other file. The !, if  present,  will  permit  the  lines  to  be
     written  even  if  you've  set the readonly option. If you precede the
     filename by >> then the lines will be appended to the file.


  _D_i_r_e_c_t_o_r_y _C_o_m_m_a_n_d_s
            cd [directory]
            chdir [directory]
            shell

        The (cd) and (chd)ir commands (really two names  for  one  command)
     switch the current working directory.

        The (sh)ell command starts an interactive shell.


  _D_e_b_u_g_g_i_n_g _C_o_m_m_a_n_d_s
            [line][,line] debug[!]
            validate[!]

        These  commands  are  only  available if you compile Elvis with the
     -DDEBUG flag.

        The de(b)ug command lists stats for the blocks  which  contain  the
     specified  range  of  lines. If the ! is present, then the contents of
     those blocks is displayed, too.

        The  (va)lidate  command  checks  certain  variables  for  internal
     consistency.  Normally  it doesn't output anything unless it detects a
     problem. With the !, though, it will always produce *some* output.



















                                    - 13 -








_R_e_g_u_l_a_r _E_x_p_r_e_s_s_i_o_n_s

        Elvis uses regular expressions for searching and substututions.


  _S_y_n_t_a_x

        The code for handling regular expressions  is  derived  from  Henry
     Spencer's  regexp  package.  However,  I  have  modified the syntax to
     resemble that of the real vi.

        Elvis' regexp package treats the following  one-  or  two-character
     strings (called meta-characters) in special ways:
            \( \)    Used to control grouping
            ^        Matches the beginning of a line
            $        Matches the end of a line
            \<       Matches the beginning of a word
            \>       Matches the end of a word
            [ ]      Matches any single character inside the brackets
            *        The preceding may be repeated 0 or more times
            +        The preceding may be repeated 1 or more times
            ?        The preceding is optional
            \|       Separates two alternatives

        Anything  else  is  treated  as a normal character which must match
     exactly. The special strings may all be preceded  by  a  backslash  to
     force them to be treated normally.

        For example, "\(for\|back\)ward" will find "forward" or "backward",
     and "\<text\>" will find "text" but not "context".


  _O_p_t_i_o_n_s

        Elvis has two options which affect the way regular expressions  are
     used. These options may be examined or set via the :set command.

        The  first  option is called "[no]magic". This is a boolean option,
     and it is "magic" (TRUE) by default. While in magic mode, all  of  the
     meta-characters behave as described above. In nomagic mode, only ^ and
     $ retain their special meaning.

        The second option is called "[no]ignorecase".  This  is  a  boolean
     option,  and  it  is  "noignorecase"  (FALSE)  by  default.  While  in
     ignorecase mode, the searching mechanism will not distinguish  between
     an  uppercase  letter  and  its  lowercase form. In noignorecase mode,
     uppercase and lowercase are treated as being different.

        Also, the "[no]wrapscan" option affects searches.








                                    - 14 -








  _S_u_b_s_t_i_t_u_t_i_o_n_s

        The :s command has at least two arguments:  a  regular  expression,
     and   a  substitution  string.  The  text  that  matched  the  regular
     expression is replaced by text which is derived from the  substitution
     string.

        Most characters in the substitution string are copied into the text
     literally but a few have special meaning:
            &        Causes a copy of the original text to be inserted
            \1       Inserts a copy of that portion of the original text which
                     matched the first set of \( \) parentheses.
            \2 - \9  Does the same for the second (etc.) pair of \( \).

        These may be preceded by a backslash to force them  to  be  treated
     normally.









































                                    - 15 -








_O_p_t_i_o_n_s

        Options  may  be  set  or examined via the colon command "set". The
     values of options will affect the operation of later commands.

        There are three types of options:  Boolean,  string,  and  numeric.
     Boolean  options  are made TRUE by giving the name of the option as an
     argument to the "set" command; they are made FALSE  by  prefixing  the
     name  with  "no".  For  example, "set autoindent" makes the autoindent
     option TRUE, and "set noautoindent" makes it FALSE.

        To change the value of a string or numeric option, pass  the  "set"
     command  the  name  of  the  option,  followed  by an "=" sign and the
     option's new value. For example, "set tabstop=8" will give the tabstop
     option a value of 8. For string options, you may enclose the new value
     in quotes.

        For convenience, options have both a long descriptive  name  and  a
     short   name   which  is  easy  to  type.  You  may  use  either  name
     interchangably. I like the short names, myself.

Names           Type        Default             Meaning
---------------+-----------+-------------------+--------------------------------
ai, autoindent  Boolean     noai                auto-indent during input
aw, autowrite   Boolean     noaw                auto-write when switching files
ca, charattr    Boolean     noca                interpret \fX sequences
co, columns     Numeric     co=80               width of the screen
dir, directory  String      dir="/usr/tmp"      where tmp files are kept
eb, errorbells  Boolean     eb                  ring bell on error
er, exrefresh   Boolean     er                  write lines indiviually in EX
hf, hideformat  Boolean     hf                  hide text formatter comamnds
ic, ignorecase  Boolean     noic                upper/lowercase match in search
im, inputmode   Boolean     noim                start vi in insert mode?
kt, keytime     Numeric     kt=2                timeout for mapped key entry
kp, keywordprg  String      kp="/usr/bin/ref"   full pathname of shift-K prog
ln, lines       Numeric     ln=25               number of lines on the screen
li, list        Boolean     noli                display lines in "list" mode
ma, magic       Boolean     ma                  use regular expression in search
pa, paragraphs  String      pa="PPppPApa"       names of "paragraph" nroff cmd
ro, readonly    Boolean     noro                prevent overwriting of orig file
re, report      Numeric     re=5                report when 5 or more changes
sc, scroll      Numeric     sc=12               scroll amount for ^U and ^D
se, sections    String      se="SEseSHsh"       names of "section" nroff cmd
sh, shell       String      sh="/bin/sh"        full pathname of the shell
sho, showmode   Boolean     noshowmode          say when we're in input mode
sw, shiftwidth  Numeric     sw=8                shift amount for < and >
ss, sidescroll  Numeric     ss=8                amount of sideways scrolling
sy, sync        Boolean     nosy                call sync() often
ts, tabstop     Numeric     ts=8                width of tab characters
te, term        String      te="?"              name of the termcap entry
vb, vbell       Boolean     vb                  use visible alternative to bell
wa, warn        Boolean     wa                  warn for ! if file modified
wm, wrapmargin  Numeric     wm=0                wrap long lines in input mode
ws, wrapscan    Boolean     ws                  at EOF, searches wrap to line 1



                                    - 16 -








  _a_u_t_o_i_n_d_e_n_t

        During input mode, the autoindent option will cause each added line
     to  begin with the same amount of leading whitespace as the line above
     it. Without autoindent, added lines are initially empty.


  _a_u_t_o_w_r_i_t_e

        When you're editing one file and decide to switch to another -- via
     the  :tag  command,  or :next command, perhaps -- if your current file
     has been modified, then Elvis will normally print an error message and
     refuse to switch.

        However,  if  the autowrite option is on, then Elvis will write the
     modified version of the current file and successfully  switch  to  the
     new file.


  _c_h_a_r_a_t_t_r

        Many  text  formatting  programs allow you to designate portions of
     your text to be underlined, italicized, or boldface by  embedding  the
     special strings \fU, \fI, and \fB in your text. The special string \fR
     marks the end of underlined or boldface text.

        Elvis normally treats those special strings  just  like  any  other
     text.

        However,  if  the  charattr option is on, then Elvis will interpret
     those special strings correctly, to  display  underlined  or  boldface
     text  on the screen. (This only works, of course, if your terminal can
     display underlined and boldface, and if the TERMCAP entry says how  to
     do it.)


  _c_o_l_u_m_n_s

        This  is  a "read only" option. You can't change its value, but you
     can have Elvis print it. It shows how wide your screen is.


  _d_i_r_e_c_t_o_r_y

        Elvis stores text in temporary files. This  option  allows  you  to
     control  which  directory  those  temporary  files will appear in. The
     default is /usr/tmp.

        This option can only be set in a .exrc file; after that, elvis will
     have  already  started making temporary files in some other directory,
     so it would be too late.






                                    - 17 -








  _e_r_r_o_r_b_e_l_l_s

        Elvis normally rings a bell  when  you  do  something  wrong.  This
     option lets you disable the bell.


  _e_x_r_e_f_r_e_s_h

        The  EX mode of Elvis writes many lines to the screen. You can make
     Elvis either write each line to the screen separately, or save up many
     lines and write them all at once.

        The exrefresh option is normally on, so each line is written to the
     screen separately.

        You may wish to turn the exrefresh option off  (:se  noer)  if  the
     "write"  system  call  is costly on your machine, or if you're using a
     windowing environment.  (Windowing  environments  scroll  text  a  lot
     faster when you write many lines at once.)

        This option has no effect in visual command mode or input mode.


  _h_i_d_e_f_o_r_m_a_t

        Many  text  formatters require you to embed format commands in your
     text, on lines  that  start  with  a  "."  character.  Elvis  normally
     displays these lines like any other text, but if the hideformat option
     is on, then format lines are displayed as blank lines.


  _i_g_n_o_r_e_c_a_s_e

        Normally, when Elvis searches for text, it treats uppercase letters
     as being different for lowercase letters.

        When  the  ignorecase  option  is  on,  uppercase and lowercase are
     treated as equal.


  _i_n_p_u_t_m_o_d_e

        This option allows you to have Elvis start up in insert  mode.  You
     can  still  exit  insert  mode  at any time by hitting the ESC key, as
     usual. Usually, this option would be set in your ".exrc" file.


  _k_e_y_t_i_m_e

        The arrow keys of most terminals send a  multi-character  sequence.
     It  takes  a  measurable  amount  of  time  for  these sequences to be
     transmitted. The keytime option allows  you  to  control  the  maximum
     amount  of  time to allow for an arrow key (or other mapped key) to be
     received in full.



                                    - 18 -








        The default keytime value is 2. Because of the way UNIX timekeeping
     works,  the  actual  amount of time allowed will vary slightly, but it
     will always be between 1 and 2 seconds.

        If you set keytime to 1, then the actual  amount  of  time  allowed
     will  be  between  0  and  1  second.  This  will  generally  make the
     keyboard's response be a little faster (mostly for the ESC  key),  but
     on  those  occasions  where the time allowed happens to be closer to 0
     than 1 second, Elvis may fail to allow enough time for an arrow  key's
     sequence to be received fully. Ugh.

        As  a  special  case, you can set keytime to 0 to disable this time
     limit stuff altogether. The big problem here is: If your  arrow  keys'
     sequences  start  with  an  ESC,  then every time you hit your ESC key
     Elvis will wait... and wait... to see if maybe that ESC was part of an
     arrow key's sequence.

        NOTE:  this option is a generalization of the timeout option of the
     real vi.


  _k_e_y_w_o_r_d_p_r_g

        Elvis has a special keyword lookup feature.  You  move  the  cursor
     onto  a  word, and hit shift-K, and Elvis uses another program to look
     up the word and display information about it.

        This option says which program gets run. It should contain the full
     pathname of the program; your whole execution path is _n_o_t checked.

        The  default  value  of  this  option is "/usr/bin/ref", which is a
     program that looks up the definition of a function in C. It  looks  up
     the function name in a file called "refs" which is created by ctags.

        You  can  subtitute  other  programs, such as an English dictionary
     program or the online  manual.  Elvis  runs  the  program,  using  the
     keyword  as its only argument. The program should write information to
     stdout. The program's exit status should be 0, unless you  want  Elvis
     to print "<<< failed >>>".


  _l_i_n_e_s

        This "read only" option shows how many lines you screen has.


  _l_i_s_t

        In  nolist  mode  (the  default), elvis displays text in a "normal"
     manner -- with tabs expanded to an appropriate number of spaces, etc.

        However, sometimes it is useful to have  tab  characters  displayed
     differently.  In  list  mode, tabs are displayed as "^I", and a "$" is
     displayed at the end of each line.



                                    - 19 -








  _m_a_g_i_c

        The search mechanism in Elvis can accept "regular  expressions"  --
     strings in which certain characters have special meaning.

        The  magic  option is normally on, which causes these characters to
     be treated specially.

        If you turn the magic option off (:se noma),  then  all  characters
     except  ^  and  $  are treated literally. ^ and $ retain their special
     meanings regardless of the setting of magic.


  _p_a_r_a_g_r_a_p_h_s

        The { and }  commands  move  the  cursor  forward  or  backward  in
     increments  of  one  paragraph.  Paragraphs  may be separated by blank
     lines, or by a "dot" command  of  a  text  formatter.  Different  text
     formatters  use  different  "dot"  commands. This option allows you to
     configure Elvis to work with your text formatter.

        It is assumed that your formatter uses commands that start  with  a
     "."  character  at  the  front  of  a  line,  and  then have a one- or
     two-character command name.

        The value of the paragraphs option is a string in which  each  pair
     of  characters is one possible form of your text formatter's paragraph
     command.


  _r_e_a_d_o_n_l_y

        Normally, Elvis will let you write back any file to which you  have
     write  permission.  If  you  don't have write permission, then you can
     only write the changed version of the file to a _d_i_f_f_e_r_e_n_t file.

        If you set the readonly option, then Elvis will pretend  you  don't
     have  write  permission  to  _a_n_y  file you edit. It is useful when you
     really only mean to use Elvis to look at a file,  not  to  change  it.
     This way you can't change it accidentally.

        This  option  is  normally  off, unless you use the "view" alias of
     Elvis. "View" is like "vi" except that the readonly option is on.


  _r_e_p_o_r_t

        Commands in Elvis may affect many lines. For commands that affect a
     lot of lines, Elvis will output a message saying what was done and how
     many lines were affected. This option allows you to define what "a lot
     of  lines"  means. The default is 5, so any command which affects 5 or
     more lines will cause a message to be shown.





                                    - 20 -








  _s_c_r_o_l_l

        The ^U and ^D keys normally scroll backward or forward  by  half  a
     screenful,  but  this is adjustable. The value of this option says how
     many lines those keys should scroll by.


  _s_e_c_t_i_o_n_s

        The [[ and ]] commands move  the  cursor  backward  or  forward  in
     increments of 1 section. Sections may be delimited by a { character in
     column 1 (which is useful for C source code) or by  means  of  a  text
     formatter's "dot" commands.

        This  option  allows  you to configure Elvis to work with your text
     formatter's "section" command,  in  exectly  the  same  way  that  the
     paragraphs  option  makes  it  work  with the formatter's "paragraphs"
     command.


  _s_h_e_l_l

        When Elvis forks a shell (perhaps for the :!  or  :shell  commands)
     this  is  the  program  that  is uses as a shell. This is "/bin/sh" by
     default, unless you have  set  the  SHELL  (or  COMSPEC,  for  MS-DOS)
     environment  variable,  it which case the default value is copied from
     the environment.


  _s_h_i_f_t_w_i_d_t_h

        The < and > commands shift text  left  or  right  by  some  uniform
     number  of  columns.  The  shiftwidth  option  defines  that  "uniform
     number". The default is 8.


  _s_h_o_w_m_o_d_e

        In visual mode, it is easy to forget whether you're in  the  visual
     command  mode  or input/replace mode. Normally, the showmode option is
     off, and you haven't a clue as to which mode you're in.  If  you  turn
     the  showmode  option  on, though, a little message will appear in the
     lower right-hand corner of your screen, telling you which mode  you're
     in.


  _s_i_d_e_s_c_r_o_l_l

        For long lines, Elvis scrolls sideways. (This is different from the
     real vi, which wraps a single long  line  onto  several  rows  of  the
     screen.)

        To  minimize  the  number of scrolls needed, Elvis moves the screen
     sideways by several characters at a time. The  value  of  this  option
     says how many characters' widths to scroll at a time.


                                    - 21 -








        Generally,  the  faster  your  screen can be redrawn, the lower the
     value you will want in this option.


  _s_y_n_c

        If the system crashes during an edit session,  then  most  of  your
     work can be recovered from the temporary file that elvis uses to store
     changes. However, sometimes UNIX/Minix will not copy  changes  to  the
     hard disk immediately, so recovery might not be possible. The [no]sync
     option lets you control this.

        In nosync mode (which is the default),  elvis  lets  the  operating
     system  control  when  data  is written to the disk. This is generally
     faster.

        In sync mode, elvis forces all changes out to disk every  time  you
     make a change. This is generally safer, but slower.


  _t_a_b_s_t_o_p

        Tab  characters  are normally 8 characters wide, but you can change
     their widths by means of this option.


  _t_e_r_m

        This "read only" option shows the name of the  termcap  entry  that
     Elvis is using for your terminal.


  _v_b_e_l_l

        If  your  termcap  entry describes a visible alternative to ringing
     your terminal's bell, then this option will say  whether  the  visible
     version gets used or not. Normally it will be.

        If  your  termcap  does NOT include a visible bell capability, then
     the vbell option will be off, and you can't turn it on.


  _w_a_r_n

        If you have modified a file but not yet written it  back  to  disk,
     then  Elvis  will  normally print a warning before executing a ":!cmd"
     command. However, in nowarn mode, this warning is not given.

        Elvis also normally prints a message after a successful search that
     wrapped at EOF. The [no]warn option can also disable this warning.







                                    - 22 -








  _w_r_a_p_m_a_r_g_i_n

        Normally  (with  wrapmargin=0) Elvis will let you type in extremely
     long lines, if you wish.

        However,  with  warpmargin  set   to   something   other   that   0
     (wrapmargin=10  is nice), Elvis will automatically cause long lines to
     be "wrapped" on a  word  break  for  lines  longer  than  wrapmargin's
     setting.


  _w_r_a_p_s_c_a_n

        Normally,  when  you  search  for  something, Elvis will find it no
     matter where it is in the file. Elvis starts at the  cursor  position,
     and  searches  forward.  If Elvis hits EOF without finding what you're
     looking for, then it wraps around to continue searching from line 1.

        If you turn off the wrapscan option (:se  nows),  then  when  Elvis
     hits EOF during a search, it will stop and say so.





































                                    - 23 -








_P_r_o_g_r_a_m_s


  _e_l_v_i_s, _e_x, _v_i, _v_i_e_w, _i_n_p_u_t - _T_h_e _e_d_i_t_o_r
            elvis [flags] [+cmd] [files...]
            -r      tell the user to use "virec" instead
            -R      set the "readonly" option to TRUE
            -t tag  search for a tag
            -e      start up in colon command mode
            -v      start up in visual command mode
            -i  start up in input mode

        The editor itself is called elvis, of course. On systems which pass
     the program name as an argument, such as Unix and Minix, you may  also
     install  elvis  under  the  names  "ex", "vi", and "view". These extra
     names would normally be links to elvis; see the "ln" shell command.

        When elvis is invoked as "vi", it behaves exactly as though it  was
     invoked  as  "elvis". However, if you invoke elvis as "view", then the
     readonly option is set as though you had given it the  "-R"  flag.  If
     you  invoke  elvis  as  "ex",  then  elvis  will start up in the colon
     command mode instead of the visual command mode,  as  though  you  had
     given it the "-e" flag. If you invoke elvis as "input" or "edit", then
     elvis will start up in input mode, as though the "-i" flag was given.

        If you use the "+cmd" parameter,  then  after  the  first  file  is
     loaded  "cmd" is treated like a colon command. A typical example would
     be "elvis +237 foo", which would cause elvis to start editing foo  and
     then move directly to line 237.


  _c_t_a_g_s - _G_e_n_e_r_a_t_e_s "_t_a_g_s" _a_n_d (_o_p_t_i_o_n_a_l_l_y) "_r_e_f_s" _f_i_l_e_s
            ctags [-r] files...
            -r      generate a "refs" file, too

        The  "tags"  file  is  used  by  Elvis'  ":tag"  command, control-]
     command, and -t option. Each C source  file  is  scanned  for  #define
     statements  and  global function definitions. The name of the macro or
     function becomes the name of a tag. For each tag, a line is  added  to
     the "tags" file which contains:
                   - the name of the tag
                   - a tab character
                   - the name of the file containing the tag
                   - a tab character
                   - a way to find the particular line within the file.

        The  "refs" file is used by the "ref" program, which can be invoked
     via Elvis' K command. When ctags finds a global  function  definition,
     it  copies the function header into the "refs" file. The first line is
     flush against the right  margin,  but  the  argument  definitions  are
     indented.  The ref program can search the "refs" file _m_u_c_h faster than
     it could search all of the C source files.





                                    - 24 -








        The filenames list will typically be the  names  of  all  C  source
     files in the current directory, like this:
            $ ctags -r *.[ch]


  _r_e_f - _D_i_s_p_l_a_y _a _C _f_u_n_c_t_i_o_n _h_e_a_d_e_r
            ref function_name

        Ref is a program which looks up the function header of a particular
     function in any of a series of reference files. These reference  files
     are produced by the ctags program.

        Ref is used by vi's shift-K command.

        The list of files checked includes "refs" in the current directory,
     and possibly others. See the source code for an accurate list.


  _v_i_r_e_c - _R_e_c_o_v_e_r _t_h_e _m_o_d_i_f_i_e_d _v_e_r_s_i_o_n _o_f _a _f_i_l_e _a_f_t_e_r _a _c_r_a_s_h
            virec [-d tmpdir] textfilename...
            virec [-d tmpdir] </usr/tmp/viname

        Virec is a program which extracts the most recent version of a text
     file from a temporary file in /usr/tmp.

        When  you  edit  a file with Elvis, only about 5K bytes of the file
     are stored in RAM; the rest is stored in  a  file  in  /usr/tmp.  This
     allows  you  to  edit files larger than a process' data space. It also
     plays a big part in the way that "undo" and "paste" were implemented.

        The virec program basically extracts the "undo"  version  from  the
     file.  This  is  most useful when the system (or Elvis) crashes in the
     middle of a long edit session, because the "undo" version of the  file
     contains  everything  except your last change. Nearly all of your work
     can be salvaged.

        The most common way to invoke virec is this: You  just  give  virec
     the  name of the file you were editing, and it finds the matching file
     in /usr/tmp and writes the newest available version of the  file  over
     the existing version. It then deletes the /usr/tmp file.

        The  other  way,  where  you  redirect  its  stdin  to  come from a
     particular /usr/tmp file, is used when you have either forgotten which
     file  that  is  and  you want to see its contents, or when you want to
     recover the file without  losing  either  the  /usr/tmp  file  or  the
     current version of the text file.











                                    - 25 -








_D_i_f_f_e_r_e_n_c_e_s _b_e_t_w_e_e_n _e_l_v_i_s _a_n_d _t_h_e _r_e_a_l _v_i/_e_x


  _E_x_t_e_n_s_i_o_n_s

   :mkexrc
   :mk

        This  EX  command saves the current :set and :map configurations in
     the ".exrc" file in your current directory.

   :args
   :ar

        You can use the :args command to define a new args list, as in:
            :args *.h

        After you have defined a new args list, the next time you  issue  a
     :next command Elvis will switch to the first file of the new list.

   :Next
   :previous
   :N
   :pre

        These commands move backwards through the args list.

   zz

        In  visual  command  mode, the (lowercase) "zz" command will center
     the current line on the screen, like "z=".

   .

        The default count value for . is the same as the  previous  command
     which . is meant to repeat. However, you can supply a new count if you
     wish. For example, after "3dw", "." will delete 3 words, but "5." will
     delete 5 words.

   ".

        The  text  which  was  most  recently input (via a "cw" command, or
     something similar) is saved in a cut buffer  called  ".  (which  is  a
     pretty hard name to write in an English sentence).

   K

        In  visual  command  mode,  you can move the cursor onto a word and
     press shift-K to have Elvis run a reference program to look that  word
     up.  This command alone is worth the price of admission! See the ctags
     and ref programs.






                                    - 26 -








   #


        In visual command mode, you can move the cursor onto a  number  and
     then  hit ## or #+ to increment that number by 1. To increment it by a
     larger amount, type in the increment value before hitting the  initial
     #.  The  number  can  also  be decremented or set by hitting #- or #=,
     respectively.

   input

        You can backspace past the beginning of the line.

        The arrow keys work in input mode.

        If you type control-A, then the text that you input  last  time  is
     inserted.  You  will  remain  in input mode, so you can backspace over
     part of it, or add more to it. (This is sort of like control-@ on  the
     real vi, except that control-A really works.)

        Control-P will insert the contents of the cut buffer.

        Real  vi can only remember up to 128 characters of input, but Elvis
     can remember any amount.

        The ^T and ^D keys can adjust the indent of a line no matter  where
     the cursor happens to be in that line.

        You  can  save your file and exit Elvis directly from input mode by
     hitting control-Z twice.

        Elvis supports digraphs as a way to enter non-ASCII characters.

   :set inputmode
   :se im

        If you set this flag in your .exrc file, then elvis will  start  up
     in input mode instead of visual command mode.

   :set charattr
   :se ca

        Elvis  can  display "backslash-f" style character attributes on the
     screen as  you  edit.  The  following  example  shows  the  recognized
     atributes:
            normal \fBboldface\fR \fIitalics\fR \fUunderlined\fR normal

        NOTE:  you  must  compile  elvis without the -DNO_CHARATTR flag for
     this to work.

   :set noexrefresh
   :se noer





                                    - 27 -








        Elvis gives you a little more control over how EX mode writes lines
     to the terminal. In exrefresh mode, each line is individually written;
     in noexrefresh mode, Elvis writes several lines at  once.  The  latter
     mode works better on windowing systems.

   :set sync
   :se sy

        After a crash, you can usually recover the altered form of the file
     from the temporary file that Elvis uses. With the sync  option  turned
     on,  the  odds  are  shifted a little more in your favor because Elvis
     will perform a sync() call after each change has been written  to  the
     temporary file.

   cursor shape

        Elvis changes the shape of the cursor to indicate which mode you're
     in,  if  your  terminal's  termcap  entry   includes   the   necessary
     capabilities.

   :set hideformat
   :se hf

        This  option hides format control lines. (They are displayed on the
     screen as blank lines.)


  _O_m_i_s_s_i_o_n_s

        The replace mode is a hack.  It  doesn't  save  the  text  that  it
     overwrites.

        Long  lines  are  displayed  differently -- where the real vi would
     wrap a long line  onto  several  rows  of  the  screen,  Elvis  simply
     displays  part  of  the  line,  and  allows  you  to scroll the screen
     sideways to see the rest of it.

        The ":preserve" and ":recover" commands are missing, as is  the  -r
     flag.  I've  never had a good reason to use ":preserve", and since use
     of ":recover" is so rare, I decided to  implement  it  as  a  separate
     program.  There's  no need to load the recovery code into memory every
     time you edit a file.

        LISP support is missing.

        The "@" and ":@" commands are missing.

        You can't APPEND to a cut buffer. The following DOES NOT WORK:
            "Ayy

        Due to naming conventions used for the temporary files,  Elvis  can
     be creating no more that one new file per directory at any given time.
     Any number of existing files  can  be  edited  at  the  same  time  on
     multitasking  computer  systems,  but only one new file can be created
     simultaneously per directory. To relieve this problem, you would  have
     to edit tmp.c and virec.c

                                    - 28 -








_I_n_t_e_r_n_a_l

        You  don't  need to know the material in this section to use elvis.
     You only need it if you intend to modify elvis.


  _T_h_e _t_e_m_p_o_r_a_r_y _f_i_l_e

        The temporary file is divided into blocks of 1024 bytes each.

        When elvis starts up, the file is copied into the  temporary  file.
     Small  amounts  of extra space are inserted into the temporary file to
     insure that no text lines  cross  block  boundaries;  this  speeds  up
     processing  and  simplifies  storage  management. The "extra space" is
     filled with NUL charcters; the input file must not contain  any  NULs,
     to avoid confusion.

        The  first  block of the temporary file is an array of shorts which
     describe the order of the blocks; i.e. header[1] is the  block  number
     of  the  first block, and so on. This limits the temporary file to 512
     active blocks, so the largest file you can edit is  about  400K  bytes
     long. I hope that's enough!

        When blocks are altered, they are rewritten to a _d_i_f_f_e_r_e_n_t block in
     the file, and the in-core version  of  the  header  block  is  updated
     accordingly.  The in-core header block will be copied to the temp file
     immediately before the next change... or, to undo  this  change,  swap
     the old header (from the temp file) with the new (in-core) header.

        Elvis   maintains   another   in-core   array  which  contains  the
     line-number of the last line in every block. This  allows  you  to  go
     directly to a line, given its line number.


  _I_m_p_l_e_m_e_n_t_a_t_i_o_n _o_f _E_d_i_t_i_n_g

        There are three basic operations which affect text:
            * delete text   - delete(from, to)
            * add text      - add(at, text)
            * yank text     - cut(from, to)

        To  yank text, all text between two text positions is copied into a
     cut buffer. The original text is not changed. To copy the text into  a
     cut  buffer, you need only remember which physical blocks that contain
     the cut text, the offset into the first block of the start of the cut,
     the offset into the last block of the end of the cut, and what kind of
     cut it was. (Cuts may be either character cuts or line cuts; the  kind
     of  a  cut  affects the way it is later "put".) This is implemented in
     the function cut().

        To delete text, you must modify the  first  and  last  blocks,  and
     remove  any  reference to the intervening blocks in the header's list.
     The text to be deleted is specified by two marks. This is  implemented
     in the function delete().



                                    - 29 -








        To   add   text,  you  must  specify  the  text  to  insert  (as  a
     NUL-terminated string) and the place to insert it  (as  a  mark).  The
     block  into which the text is to be inserted may need to be split into
     as many as four blocks, with new intervening blocks needed as  well...
     or  it  could  be  as  simple  as  modifying  a  single block. This is
     implemented in the function add().

        Other interesting functions are paste() (to copy text  from  a  cut
     buffer  into  the file), modify() (for an efficient way to implement a
     combined delete/add sequence), and input() (to get text from the  user
     & insert it into the file).

        When  text  is  modified, an internal file-revision counter, called
     "changes", is incremented. This counter is used to detect when certain
     caches  are  out  of  date. (The "changes" counter is also incremented
     when we switch to a different file, and also in  one  or  two  similar
     situations -- all related to invalidating caches.)


  _M_a_r_k_s _a_n_d _t_h_e _C_u_r_s_o_r

        Marks  are  places within the text. They are represented internally
     as a long variable which is split into two bitfields:  a  line  number
     and  a  character  index.  Line  numbers  start  with 1, and character
     indexes start with 0.

        Since line numbers start with 1, it is impossible for a set mark to
     have a value of 0L. 0L is therefore used to represent unset marks.

        When  you  do the "delete text" change, any marks that were part of
     the deleted text are unset, and any marks  that  were  set  to  points
     after it are adjusted. Similarly, marks are adjusted after new text is
     inserted.

        The cursor is represented as a mark.


  _C_o_l_o_n _C_o_m_m_a_n_d _I_n_t_e_r_p_r_e_t_a_t_i_o_n

        Colon commands are parsed, and the command name is looked up in  an
     array  of structures which also contain a pointer to the function that
     implements the command, and a description of the  arguments  that  the
     command  can  take. If the command is recognized and its arguments are
     legal, then the function is called.

        Each function performs its task; this may cause the  cursor  to  be
     moved to a different line, or whatever.










                                    - 30 -








  _S_c_r_e_e_n _C_o_n_t_r_o_l

        The  screen  is updated via a package which looks like the "curses"
     library,  but  isn't.  It  is  actually  much  simpler.  Most   curses
     operations  are  implemented  as  macros  which copy characters into a
     large I/O buffer, which is then written with a  single  large  write()
     call as part of the refresh() operation.

        The  functions  which  modify  text  remember  where  text has been
     modified;  the  screen  redrawing  function,  redraw(),   needs   this
     information  to help it reduce the amount of text that is redrawn each
     time.


  _P_o_r_t_a_b_i_l_i_t_y

        To improve portability, Elvis  collects  as  much  system-dependent
     definitions  as  possible  in the config.h file. This file begins with
     some  preprocessor  instructions  which  attempt  to  determine  which
     compiler  and  operating system you have. After that, it conditionally
     defines some macros and constants for your system.

        One of the more significant macros is ttyread(buf,n). This macro is
     used  to  read  characters  from  the keyboard. For UNIX systems, this
     simply reads bytes from stdin. For MS-DOS and Atari-TOS, ttyread()  is
     a function defined in curses.c. There is also a ttywrite macro.

        The  tread() and twrite() macros are versions of read() and write()
     that are used for text files. On UNIX systems, these are equivelent to
     read() and write(). On MS-DOS, these are also equivelent to read() and
     write(), since DOS libraries are generally clever  enough  to  convert
     newline  characters  automatically.  For  Atari  TOS,  though, the MWC
     library is too stupid to do this, so  we  had  to  do  the  conversion
     explicitly.

        Other  macros  may  substitute index() for strchr(), or bcopy() for
     memcpy(), or map the (void) data type to (int), or whatever.




















                                    - 31 -








_C_F_L_A_G_S

        Elvis uses many preprocessor symbols to control  compilation.  Some
     of  these  control  the sizes of buffers and such, but the "-DNO_XXXX"
     options remove small sets of related features.

        Most Elvis users will probably want to keep all features available.
     Minix-PC users, though, will have to sacrifice one or two feature sets
     because otherwise Elvis would be too  bulky  to  compile.  The  "asld"
     phase  of  the compiler craps out. Interestingly, the full Elvis would
     probably be able to run under Minix-PC if you could cross-compile  it;
     under  SCO Xenix the ".text" segment is only about 59k bytes long, and
     I would expect the Minix-PC version to be about the same.


  -_D_M__S_Y_S_V, -_D_T_O_S, -_D_O_S_9

        These flags  tell  the  compiler  that  Elvis  is  being  compliled
     System-V  UNIX,  ot  Atari TOS, or OS-9/68000, respectively. For other
     systems, the config.h file can figure it out automatically.


  -_D_D_A_T_E=\'\"`_d_a_t_e`\"\'

        DATE should be defined to be a string constant. It  is  printed  by
     the :version command as the compilation date of the program.

        It  is  only  used  in  cmd1.c,  and  even  there  you may leave it
     undefined without causing an urp.

        The form shown  above  only  works  if  you  use  "eval".  See  the
     Makefile.


  -_D_N_B_U_F_S=_1_0

        Elvis  keeps  most  of  your text in a temporary file; only a small
     amount is actually stored in RAM. This flag allows you to control  how
     much  of  the file can be in RAM at any time. The default is 5k bytes;
     the example above changes that to 10k bytes.

        More RAM allows global changes to happen a little faster. If you're
     just making many small changes in one section of a file, though, extra
     RAM won't help much.


  -_D_B_L_K_S_I_Z_E=_2_0_4_8

        This controls the size of blocks that Elvis  uses  internally.  The
     value  of  BLKSIZE  must be a power of two. The default value is 1024,
     which allows you to edit files up to almost  512K  bytes  long.  Every
     time  you  double  BLKSIZE, you quadruple the size of a text file that
     Elvis can handle, but you  also  cause  the  temporary  file  to  grow
     faster.



                                    - 32 -








  -_D_T_M_P_D_I_R=\"/_t_m_p\"

        This  sets  the  default  value  of  the  "directory" option, which
     specifies where the temporary files should reside. The value of TMPDIR
     must  be a string, so be sure your value includes the quote characters
     on each end.


  -_D_E_X_R_C=\"._e_l_v_i_s_r_c\" -_D_H_M_E_X_R_C=\"_e_l_v_i_s._i_n_i\" -_D_S_Y_S_E_X_R_C=\"/_e_t_c/_e_l_v_i_s_r_c\"

        This lets you control the names of the initialization files.  Their
     values must be strings, so be careful about quoting.

        EXRC  is  the  name  of  the  initialization  file  in  the current
     directory. Its default value is ".exrc" on UNIX systems -- the same as
     the real vi. For other systems, check the config.h file.

        HMEXRC  is  the  name  of  the  initialization  file  in  your home
     directory.  By  default,  it  is  the  same  as   EXRC.   Elvis   will
     automatically prepend the name of your home directory to HMEXRC at run
     time, so don't give a full path name.

        SYSEXRC is the name of a system-wide initialization file. It has no
     default  value; if you don't define a value for it, then the code that
     supports SYSEXRC just isn't compiled. The value of SYSEXRC should be a
     full pathname.


  -_D_K_E_Y_W_O_R_D_P_R_G=\"/_u_s_r/_l_o_c_a_l/_r_e_f\"

        This  flag determines the default value of the "keywordprg" option.
     Its value must be a string, so be careful about quoting.  The  default
     value of this flag is "/usr/bin/ref" on UNIX systems.


  -_D_D_E_B_U_G

        This adds the ":debug" and ":validate" commands, and also adds many
     internal consistency checks. It increases  the  size  of  the  ".text"
     segment by about 5K.


  -_D_N_O__C_H_A_R_A_T_T_R

        Permanently  disables the charattr option. This reduces the size of
     your ".text" segment by about 850 bytes.


  -_D_N_O__R_E_C_Y_C_L_E

        Normally, Elvis will  recycle  space  (from  the  tmp  file)  which
     contains  totally  obsolete  text.  This flag disables this recycling.
     Without recycling, the ".text" segment is about  1K  smaller  than  it
     would  otherwise be, but the tmp file grows much faster. If you have a
     lot of free space on your harddisk, but Elvis is too bulky to run with
     recycling, then try it without recycling.

                                    - 33 -








        When  using  a  version  of  Elvis  that  has  been  compiled  with
     -DNO_RECYCLE, you should be careful to avoid making many small changes
     to  a  file  because each individual change will cause the tmp file to
     grow by at least  1k.  Hitting  "x"  thirty  times  counts  as  thirty
     changes,  but  hitting  "30x"  counts  as one change. Also, you should
     occasionally do a ":w" followed by a ":e" to start with  a  fresh  tmp
     file.


  -_D_N_O__S_E_N_T_E_N_C_E

        Leaves  out  the  "(" and ")" visual mode commands. Also, the "[[",
     "]]", "{", and "}" commands  will  not  recognize  *roff  macros.  The
     sections and paragraphs options go away. This saves about 650 bytes in
     the ".text" segment.


  -_D_N_O__C_H_A_R_S_E_A_R_C_H

        Leaves out the visual commands which locate a  given  character  in
     the  current  line:  "f", "t", "F", "T", "," and ";". This saves about
     900 bytes.


  -_D_N_O__E_X_T_E_N_S_I_O_N_S

        Leaves out  the  :mkexrc  command,  and  the  "K"  and  "#"  visual
     commands.  Also,  the  arrow  keys  will no longer work in input mode.
     (Other extensions are either inherent in the design of elvis,  or  are
     controlled  by  more  specific  flags,  or  are  too  tiny to be worth
     removing.) This saves about 500 bytes.


  -_D_N_O__M_A_G_I_C

        Permanently   disables   the   "magic"   option,   so   that   most
     meta-characters  in  a  regular  expression are *NOT* recognized. This
     saves about 3k of space in the ".text" segment,  because  the  complex
     regular expression code can be replaced by much simpler code.


  -_D_N_O__S_H_O_W_M_O_D_E

        Permanently disables the "showmode" option, saving about 250 bytes.


  -_D_N_O__C_U_R_S_O_R_S_H_A_P_E

        Normally,  Elvis  tries  to  adjust  the  shape  of the cursor as a
     reminder of which mode you're in. The -DNO_CURSORSHAPE  flag  disables
     this, saving about 150 bytes.






                                    - 34 -








  -_D_N_O__D_I_G_R_A_P_H

        To  allow entry of non-ASCII characters, Elvis supports digraphs. A
     digraph is a single  (non-ASCII)  character  which  is  entered  as  a
     combination  of  two  other  (ASCII)  characters. If you don't need to
     input non-ASCII characters, or if your keyboard supports a better  way
     of  entering  non-ASCII  characters,  then you can disable the digraph
     code and save about 450 bytes.

















































                                    - 35 -








_T_e_r_m_c_a_p

        Elvis uses fairly standard termcap capabilities  for  most  things.
     Some  of  the  keyboard  sequences were borrowed from SCO Xenix, and I
     invented some of the character attribute names and all of  the  cursor
     shape names, but other than that there should be no surprises.


  _R_e_q_u_i_r_e_d _n_u_m_e_r_i_c _c_a_p_a_b_i_l_i_t_i_e_s

        :co#:   number of columns on the screen (characters per line)
        :li#:   number of lines on the screen


  _R_e_q_u_i_r_e_d _s_t_r_i_n_g _c_a_p_a_b_i_l_i_t_i_e_s

        :ce=:   clear to end-of-line
        :cl=:   home the cursor & clear the screen
        :cm=:   move the cursor to a given row/column
        :up=:   move the cursor up one line


  _B_o_o_l_e_a_n _c_a_p_a_b_i_l_i_t_i_e_s

        :am:    auto margins - wrap when a char is written to the last column?
        :pt:    physical tabs?


  _O_p_t_i_o_n_a_l _s_t_r_i_n_g _c_a_p_a_b_i_l_i_t_i_e_s

        :al=:   insert a blank row on the screen
        :dl=:   delete a row from the screen
        :cd=:   clear to end of display
        :ei=:   end insert mode
        :ic=:   insert a blank character
        :im=:   start insert mode
        :dc=:   delete a character
        :sr=:   scroll reverse (insert a row at the top of the screen)
        :vb=:   visible bell
        :ti=:   terminal initialization string, to start full-screen mode
        :te=:   terminal termination, to end full-screen mode


  _O_p_t_i_o_n_a_l _s_t_r_i_n_g_s _r_e_c_e_i_v_e_d _f_r_o_m _t_h_e _k_e_y_b_o_a_r_d

        :kd=:   sequence sent by the <down arrow> key
        :kl=:   sequence sent by the <left arrow> key
        :kr=:   sequence sent by the <right arrow> key
        :ku=:   sequence sent by the <up arrow> key
        :PU=:   sequence sent by the <PgUp> key
        :PD=:   sequence sent by the <PgDn> key
        :HM=:   sequence sent by the <Home> key
        :EN=:   sequence sent by the <End> key




                                    - 36 -








  _O_p_t_i_o_n_a_l _c_a_p_a_b_i_l_i_t_i_e_s _t_h_a_t _d_e_s_c_r_i_b_e _c_h_a_r_a_c_t_e_r _a_t_t_r_i_b_u_t_e_s

        :so=: :se=:     start/end standout mode (We don't care about :sg#:)
        :us=: :ue=:     start/end underlined mode
        :VB=: :Vb=:     start/end boldface mode
        :as=: :ae=:     start/end alternate character set (italics)
        :ug#:           visible gap left by :us=:, :ue=:, :VB=:, or :Vb=:


  _O_p_t_i_o_n_a_l _c_a_p_a_b_i_l_i_t_i_e_s _t_h_a_t _a_f_f_e_c_t _t_h_e _s_h_a_p_e _o_f _t_h_e _c_u_r_s_o_r

        The  :cQ=:  string  is  used by elvis immediately before exiting to
     undo the effects of the other cursor shape strings. If  :cQ=:  is  not
     given, then all other cursor shape strings are ignored.

        :cQ=:   normal cursor
        :cX=:   cursor shape used for reading EX command -- steady underline
        :cV=:   cursor shape used for reading VI commands -- steady block
        :cI=:   cursor shape used during VI input mode -- blinking underline
        :cR=:   cursor shape used during VI replace mode -- blinking block


  _A_n _e_x_a_m_p_l_e

        Here's  the  termcap entry I use on my Minix-ST system. Some of the
     capabilities in it have nothing to do with Elvis. Some can  only  work
     on my system; I have modified my kernel's screen driver.

            mx|minix|minixst|ansi:\
                :co#80:li#25:bs:pt:\
                :cm=\E[%i%d;%dH:up=\E[A:do=^J:nd=\E[C:sr=\EM:\
                :cd=\E[J:ce=\E[K:cl=\E[H\E[J:\
                :al=\E[L:dl=\E[M:ic=\E[@:dc=\E[P:im=:ei=:\
                :so=\E[7m:se=\E[m:us=\E[4m:ue=\E[m:\
                :VB=\E[1m:Vb=\E[m:as=\E[1;3m:ae=\E[m:\
                :rs=\E[?5l:\
                :ku=\E[A:kd=\E[B:kr=\E[C:kl=\E[D:kb=^H:\
                :k1=\EOP:k2=\EOQ:k3=\EOR:k4=\EOS:k5=\EOT:\
                :k6=\EOU:k7=\EOV:k8=\EOW:k9=\EOX:k0=\EOY:\
                :kH=\E[V:kU=\E[U:\
                :cQ=\E[k:cX=\E[2;0k:cV=\E[16;0k:cI=\E[2;20k:cR=\E[16;20k:\
                :G3=%:GU=&:G4=':GR=(:GC=):GL=*:G2=+:GD=,:G1=-:GH=.:GV=/:















                                    - 37 -








_E_n_v_i_r_o_n_m_e_n_t _V_a_r_i_a_b_l_e_s

        Elvis examines several environment variables when it starts up. The
     values of these  variables  are  used  internally  for  a  variety  of
     purposes.  You  don't  need  to  define all of these; on most systems,
     Elvis only requires TERM to be defined. On MS-DOS systems,  even  that
     is optional.


  _T_E_R_M, _T_E_R_M_C_A_P

        TERM  tells Elvis the name of the termcap entry to use. TERMCAP may
     contain either the entire termcap entry, or the full pathname  of  the
     termcap file to search through.


  _T_M_P, _T_E_M_P

        These only work for MS-DOS and Atari TOS. Either of these variables
     may be used to  set  the  "directory"  option,  which  controls  where
     temporary files are stored. If you define them both, then TMP is used,
     and TEMP is ignored.


  _E_X_I_N_I_T

        This variable may contain  a  colon-mode  command,  which  will  be
     executed after all of the ".exrc" files but before interactive editing
     begins. NOTE: the real vi allows you to put  multiple  commands  here,
     separated  by  |  characters.  Elvis doesn't, yet, but you can place a
     "source" command there to get the same effect.


  _S_H_E_L_L, _C_O_M_S_P_E_C

        You can use COMSPEC in MS-DOS, or SHELL in  any  other  system,  to
     specify  which  shell  should  be  used  for  executing  commands  and
     expanding wildcards.


  _H_O_M_E

        This variable should give the full pathname of your home directory.
     Elvis  needs  to know the name of your home directory so it can locate
     the ".exrc" file there.












                                    - 38 -








_V_e_r_s_i_o_n_s

        Elvis currently works under  BSD  UNIX,  AT&T  System-V  UNIX,  SCO
     XENIX,  Minix,  MS-DOS,  and  Atari  TOS.  This  section of the manual
     provides special information that applies to each  particular  version
     of Elvis.


  _B_S_D _U_N_I_X

        Use "Makefile.bsd" to make Elvis.

        The  only  problem  you're  like to have is that both Elvis and the
     real Vi read initialization commands from a file called  ".exrc",  but
     the  commands  in  that  file might work on one but not the other. For
     example, "set keywordprg=/usr/myself/bin/ref" will work for Elvis, but
     Vi will complain because it doesn't have a "keywordprg" option. If the
     warning messages annoy you, then you can edit  the  config.h  file  to
     change  the name of the initialization file ".exrc" to something else,
     such as ".elvisrc".


  _S_y_s_t_e_m-_V _U_N_I_X

        Use "Makefile.s5" to make  Elvis.  If  your  system  uses  terminfo
     instead  of  termcap,  then  you  will have to edit the Makefile. More
     detailed instructions are embedded in the Makefile itself.

        The potential trouble with ".exrc" described  above  for  BSD  UNIX
     applies to System-V UNIX as well.

        If  your  system  uses  terminfo, you may have trouble with some of
     Elvis' extensions because  terminfo  can  only  emulate  the  standard
     termcap  capabilites  and  some  of  the  extensions  use  nonstandard
     capabilites. In particular, you can expect the "charattr" option to be
     almost useless, and the cursor's shape won't change.

        Elvis uses control-C as the interrupt key, not Delete.


  _S_C_O _X_e_n_i_x

        Use  "Makefile.s5" to make Elvis. On '286 systems, you will have to
     edit the Makefile so that the compiler generates  code  with  separate
     instruction  &  data segments. More detailed instructions are embedded
     in the Makefile itself.

        Other than that,  the  Xenix  version  behaves  like  the  System-V
     version, so everything mentioned in the System-V section above applies
     to SCO Xenix.







                                    - 39 -








  _M_i_n_i_x

        Use  "Makefile.st"  on  Minix-ST  systems,  and  "Makefile.pc"   on
     Minix-PC systems. The differences between these two Makefiles are that
     the ST version uses "*.o" files where the PC version uses "*.s" files,
     and  the  PC version has some extra flags in CFLAGS to reduce the size
     of Elvis.

        Minix-PC users should read the CFLAGS section of this  manual  very
     carefully.

        The  temporary files are stored in /usr/tmp. The /usr/tmp directory
     must exist before you run Elvis, and it must be  readable/writable  by
     everybody.

        Elvis uses control-C as the interrupt key, not Delete.


  _M_S-_D_O_S

        Elvis was ported to MS-DOS by Guntram Blohm and Martin Patzel.

        There   are   two  different  Makefiles  for  Elvis  under  MS-DOS.
     "Elvis.prj" should be used with Turbo-C,  and  "Elvis.mak"  should  be
     used  with  MSC and Microsoft MAKE. The "Elvis.mak" file may work with
     MS Quick-C if you change the definition of CC to "CC=  qcl".  I  don't
     know for sure; I haven't tried it.

        Elvis  stores  its  temporary  files  in  C:\tmp.  If  this  is not
     satisfactory, then you should edit the CFLAGS line of your Makefile to
     change it to something else before compiling. The directory must exist
     before you can run Elvis.

        Normally, the TERM environment variable should not be set, or  else
     it  should be set to "pcbios". This way, Elvis will make calls to BIOS
     to update the screen. This is the fastest & prettiest  way  to  update
     the screen.

        However,  if  your  system is not quite compatible enough, then you
     can still run Elvis via the ANSI.SYS or NANSI.SYS drivers. Install one
     of  these  drivers  by  adding  "driver = ansi.sys" to your CONFIG.SYS
     file, and then define TERM to be either "ansi" or "nansi" by adding  a
     line  such as "set TERM=ansi" to your AUTOEXEC.BAT file. You must then
     reboot for these changes to take effect. After that, Elvis will notice
     the "TERM" setting and use the driver.

        Under  MS-DOS,  Elvis  has  an  extra ":set" option called "pcbios"
     which indicates whether the BIOS is being used  directly.  This  is  a
     "read only" option; you can't use it to switch your interface style in
     the middle of an edit session.

        An extra program, called  "wildcard",  is  needed  for  MS-DOS.  It
     expands wildcard characters in file names.




                                    - 40 -








  _A_t_a_r_i _T_O_S

        Elvis  was  ported to Atari TOS by Guntram Blohm and Martin Patzel.
     It is very similar to the MS-DOS version.

        The Makefile.tos file should be used for TOS. It is intended to  be
     used with the Mark Williams C compiler.

        The  TERM  environment  variable should be set to "vt52". The SHELL
     (not COMSPEC!) variable should be set to the name of  a  line-oriented
     shell.

        A  simple shell in included with elvis. Its source is in "shell.c",
     and the name of the executable  is  "shell.ttp".  This  was  necessary
     because  the  standard  Atari  software  doesn't  offer any way to set
     environment variables. The file "profile.sh" should contain a  set  of
     instructions to be executed when the shell first starts up. An example
     of this file is included, but you will almost certainly want  to  edit
     it right away to match your configuration.

        If you already have a command-line shell, then you'll probably want
     to continue using it. The shell that comes with elvis is very limited.



































                                    - 41 -



