/* Copyright 1988 Stephan v. Bechtolsheim */

/* This file is part of the TeXPS Software Package.

The TeXPS Software Package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the TeXPS Software Package
General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the TeXPS Software Package, but only under the conditions described in the
TeXPS Software Package General Public License.   A copy of this license is
supposed to have been given to you along with TeXPS Software Package so you
can know your rights and responsibilities.  It should be in a
file named CopyrightLong.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/*
 * This file here contains all the code for sending information
 * to the printer. All procedures start with Pss.
 */

#include <stdio.h>
#if SYS_V == 1
#include <string.h>
#else
#include <strings.h>
#endif
#include <stdio.h>
#include <pwd.h>
#include "version.h"
#include "release.h"
#include "dvitps.h"
#include "units.h"
#include "emit.h"
#include "extfil.h"

extern PXLU AccDeltaH;
extern PXLU AccDeltaV;
extern int PssStringIndex;
extern int DeltaPrinter;
extern int PssColumn;
extern int PsPrintEnabled;
extern int ConformingDocument;
extern char HostName[STRSIZE];
extern char *ctime();
extern char *DvitpsBinaryName;
extern EX_FILES Ex_PsOutput;

void PsInitialStuff();
void pss_flush_a();
void pss_flush_b();
void pss_flush_c_1();
void pss_flush_c_2();
void pss_flush_d();
void PssString();
void PssHexSend();

/* Either PSS_FOR_FREE or PSS_FOR_CONT */
int PssFormat;

/*
 * PsInitialStuff
 * **************
 * This is the code sent at the very beginning of each PostScript
 * code fragment generated by the driver.
 */
void
PsInitialStuff()
{
  char buffer[256];
  char time_as_string[256];
  long dvi_file_time;
  struct passwd *password;

  /* Conforming document business now. */
  if (! ConformingDocument) {
    fprintf (EX_FP(Ex_PsOutput),
	     "%%!\n%% This file is a NONconforming PostScript file.\n");
    if (PsPrintEnabled) {
      sprintf(buffer, "(TeXPS: dvi->PostScript Driver %s, Version %s of %s\\n)print flush\n",
	      DvitpsBinaryName, VERSION, DATE);
      fprintf (EX_FP(Ex_PsOutput), buffer);
      sprintf(buffer, "(TeXPS: release number %s of %s\\n)print flush\n",
	      DvitpsBinaryName, RELEASE_VERSION, RELEASE_DATE);
      fprintf (EX_FP(Ex_PsOutput), buffer);
    }
    fprintf (EX_FP(Ex_PsOutput),
	     "%% Copyright 1989 Stephan v. Bechtolsheim (unless otherwise stated)\n");
    fprintf (EX_FP(Ex_PsOutput),
	     "%% applies to various prologue files. Read documentation for details.\n");
    fprintf (EX_FP(Ex_PsOutput), "save\n");
  } else {
    fprintf (EX_FP(Ex_PsOutput), "%%!%s\n", CONFORMING_DOCUMENT_STRING);
    sprintf(buffer, "(TeXPS: dvi->PostScript Driver %s, Version %s of %s\\n)print flush\n",
	    DvitpsBinaryName, VERSION, DATE);
    fprintf (EX_FP(Ex_PsOutput), buffer);
    password = getpwuid((int) getuid());
    fprintf (EX_FP(Ex_PsOutput), "%%%%Creator: %s:%s (%s)\n",
	     HostName, password->pw_name, password->pw_gecos);
    fprintf (EX_FP(Ex_PsOutput), "%%%%DocumentPaperSizes: Letter\n");
    fprintf (EX_FP(Ex_PsOutput),
	     "%%%%Title: Dvi to PostScript converter, Version %s of %s\n", VERSION, DATE);
    strcpy (time_as_string, ctime (&dvi_file_time));
    fprintf (EX_FP(Ex_PsOutput), "%%%%CreationDate: %s\n", time_as_string);
    fprintf (EX_FP(Ex_PsOutput), "%%%%BoundingBox: 72 72 540 756\n");
    fprintf (EX_FP(Ex_PsOutput), "%%%%Pages: (atend)\n");
    fprintf (EX_FP(Ex_PsOutput), "%%%%EndComments\n");
    fprintf (EX_FP(Ex_PsOutput),
	     "%% Copyright 1989 Stephan v. Bechtolsheim (unless otherwise stated)\n");
    fprintf (EX_FP(Ex_PsOutput),
	     "%% applies to various prologue files. Read documentation for details.\n");
  }
}

/*
 * PssSendInit
 * ***********
 * Set the initial values set at the beginning of each page
 * for generating PostScript output.
 */
void
PssSendInit()
{
  AccDeltaH = 0;
  AccDeltaV = 0;
  PssStringIndex = -1;
  DeltaPrinter = 0;
  PssFormat = PSS_FOR_FREE;
}

/*
 * PssChangeFormat
 * ***************
 * Change the format in which PS code is handled.
 *
 * new_f: new format
 */
void
PssChangeFormat(new_f)
     int new_f;
{
  if (new_f != PSS_FOR_FREE && new_f != PSS_FOR_CONT)
    Fatal ("PssChangeFormat(): illegal");
  switch (PssFormat) {
    case PSS_FOR_FREE:
      break;
    case PSS_FOR_CONT:
      if (new_f == PSS_FOR_CONT)
        return;
      if (PssColumn != 0) {
	fprintf (EX_FP(Ex_PsOutput), "\n");
	PssColumn = 0;
      }
      break;
    }
  PssFormat = new_f;
}
