---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, caractères, arobase, arobas, A commercial, A rond, symbole at, caractère at, symbole de mail
---

# Comment obtenir une arobase ?

L’[arobase](wpfr:arobase), arrobase, arobe, arrobe ou arrobas sont les noms français du symbole `@`. 
On parle aussi de "A commercial" ou, par anglicisme, de symbole "*at*". 
Voir, à ce sujet, la note 2 de l’article 
[Lexique anglo-français du Companion](http://www.numdam.org/item/CG_2007___49_19_0.pdf) 
dans les *Cahiers GUTenberg*, n° 49.

Elle est traitée de manière particulière par LaTeX :

- dans un document, elle est normalement accessible en tapant tout simplement `@`. 
  Si, cas rare, cela ne marche pas, il est possible de définir une commande pour obtenir ce caractère, 
  comme dans l'exemple ci-dessous la commande `\arobe` ;
- dans les noms de commande, elle a un rôle spécifique demandant un peu de prudence. 
  Ce rôle est précisé dans les questions "[](/2_programmation/macros/makeatletter_et_makeatother)".

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\newcommand{\arobe}{\string@}

\begin{document}
Vos adresses sont jean@domaine.fr
et j.jean\arobe domaine.fr.
\end{document}
```
