%%
%% This is file `aeskwadraatbrief.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% aeskwadraat.dtx  (with options: `brief')
%% 
%% Copyright (c) 2024- TeXniCie A-Eskwadraat (voorheen HekTeX) <texnicie@a-eskwadraat.nl>
%% 
%% This program is free software: you can redistribute it and/or modify
%% it under the terms of the GNU General Public License as published by
%% the Free Software Foundation, either version 3 of the License, or
%% (at your option) any later version.
%% 
%% This program is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%% GNU General Public License for more details.
%% 
%% You should have received a copy of the GNU General Public License
%% along with this program.  If not, see <https://www.gnu.org/licenses/>.
%% 
%% The current maintainer of this work is Jesse Sraat.
%% 
%% This work consists of the main file aeskwadraat.dtx
%% and the derived files
%%     aeskwadraat.sty, aes.sty, aeskwadraat.pdf, aeskwadraat.ins, aeskwadraatbrief.cls, aeskwadraatfactuur.sty, aeskwadraatnotulen.cls,
%%     aeskwadraatnotulen.sty, aeskwadraattaal.sty, beamerthemeaeskwadraat.sty, beamerthemeaes2.sty
%% 
%% If you are looking for comments or documentation, you won't find
%% any in the source. These packages make use of literate programming, which means
%% that the documentation is given in the form of a pdf file. You can
%% probably find aeskwadraat.pdf in this folder, by running "texdoc --view aeskwadraat"
%% in the command line, or Googling
%% "[your distribution] how to find package documentation".
%% If you're using MiKTeX, open MiKTeX console, go to
%% "Documentation" and look for "aeskwadraat".
%% If you're still unsure, contact the TeXniCie at <texnicie@a-eskwadraat.nl>
%% 

%% Copyright (C) 2008-2014 TeXniCie A-Eskwadraat
%% <hektex@a-eskwadraat.nl>

\NeedsTeXFormat{LaTeX2e}[2020/10/01]
\ProvidesClass{aeskwadraatbrief}[2025/06/13 v1.0.1 A-Eskwadraat letter class]

\RequirePackage{aeskwadraat,aeskwadraattaal}
\RequirePackage{graphicx}
\RequirePackage{ifthen} % ifthen is nu nodig vanwege \newboolean verderop
\RequirePackage{kix}
\RequirePackage{xspace}
\RequirePackage{iftex}
\newboolean{aes@inbrief}
\setboolean{aes@inbrief}{true}
\newboolean{aes@optdebug}
\newboolean{aes@optkleur}
\newboolean{aes@optfooter}
\newboolean{aes@ontour}
\newboolean{aes@betadag}
\RequirePackage{aeskwadraattaal}
\DeclareTaalOpties      % aeskwadraattaal languages
\DeclareOption{debug}{\setboolean{aes@optdebug}{true}}
\DeclareOption{nodebug}{\setboolean{aes@optdebug}{false}}
\DeclareOption{kleur}{\setboolean{aes@optkleur}{true}}
\DeclareOption{nokleur}{\setboolean{aes@optkleur}{false}}
\DeclareOption{geenkleur}{\setboolean{aes@optkleur}{false}}
\DeclareOption{footer}{\setboolean{aes@optfooter}{true}}
\DeclareOption{nofooter}{\setboolean{aes@optfooter}{false}}
\DeclareOption{ontour}{\setboolean{aes@ontour}{true}}
\DeclareOption{betadag}{\setboolean{aes@betadag}{true}}
\DeclareOption*{%
        \PassOptionsToClass{\CurrentOption}{article}}
\ExecuteOptions{nodebug,nokleur,footer}
\ProcessOptions*  % *, to parse in order (essential for aeskwadraattaal)
\LaadBabel
\LoadClass{article}
\RequirePackage[a4paper,
              left=21mm,
              right=21mm,
              top=117mm,
              bottom=20mm]{geometry}
\setlength\parindent{0pt}
\setlength\parskip{\baselineskip}
\setlength\textwidth{165mm}
\setlength\textheight{160mm}
\newcommand\ps@footer{
        \renewcommand\@oddhead{}
        \renewcommand\@evenhead{}
        \renewcommand\@oddfoot{%
        \hspace{-1cm}%
        \begin{minipage}[c]{0.6\textwidth}
        \begin{flushleft}
        \aes@fontfooter\TAALverenigingfooter%
        \end{flushleft}
        \end{minipage}
        \ifthenelse{\boolean{aes@optkleur}}{}{%
        \hfill%
        \begin{minipage}[b][1mm][t]{4.6cm}%
                \vspace*{-17mm}\par % UU logo is 5 cm on official
                % letters, too
                \includegraphics[scale=.65]{logos/UU-logo2011_ZWART}
        \end{minipage}
        }%
        }
        \let\@evenfoot\@oddfoot
}
\renewcommand\raggedright{\rightskip\z@ plus2em
\spaceskip.3333em
\xspaceskip.5em\relax}
\newcommand\aes@fontheader{\fontsize{8}{11}\selectfont\sffamily}
\newcommand\aes@fonttext{\fontsize{9}{12}\selectfont}
\newcommand\aes@fontnaam{\fontsize{10}{12}\selectfont\sffamily\bfseries}
\newcommand\aes@fontfooter{\fontsize{9.5}{11}\selectfont\slshape}
\newcommand\aes@fontadres{\fontsize{13}{15}\selectfont}
\renewcommand\familydefault{\rmdefault}
\renewcommand\seriesdefault{m}
\renewcommand\shapedefault{n}
\ifpdftex
  % Deprecated LaTeX compilers use these fonts
  \renewcommand\rmdefault{ppl}
  \renewcommand\sfdefault{phv}
  \renewcommand\ttdefault{cmtt}
\else
  % LuaLaTeX and XeLaTeX
  \RequirePackage{fontspec}
  \setmainfont{TeX Gyre Pagella}
  \setsansfont{TeX Gyre Heros}
  \setmonofont{Latin Modern Mono}
\fi
\renewcommand\bfdefault{b}
\renewcommand\mddefault{m}
\renewcommand\itdefault{it}
\renewcommand\sldefault{sl}
\renewcommand\scdefault{sc}
\renewcommand\updefault{n}
\pagestyle{empty}
\NewDocumentCommand{\welkleur}{}{\setboolean{aes@optkleur}{true}}
\NewDocumentCommand{\geenkleur}{}{\setboolean{aes@optkleur}{false}}
\newcommand\aes@afzendernaam\TAALaesnaam
\newcommand\afzendernaam[1]{\renewcommand\aes@afzendernaam{#1}}
\newcommand\aes@cienaam{\ClassWarningNoLine{aeskwadraatbrief}{%
        Geen commissienaam gedefinieerd.\MessageBreak
        Gebruik \protect\cienaam{TeXniCie}\space om het in te stellen}}
\newcommand\cienaam[1]{\renewcommand\aes@cienaam{#1}}
\def\aes@kvknr{40479641}
\def\aes@btwnr{NL816588429B01}
\NewDocumentCommand{\girorekening}{}{%
  \def\aes@bank{ING}%
  \def\aes@giro{656927}%
  \def\aes@BIC{INGBNL2A}%
  \def\aes@IBAN{NL58 INGB 0000 6569 27}%
  \def\aes@rekeninghouder{Studievereniging \aeskwadraat{} inz Fiscus}%
}
\NewDocumentCommand{\evenementenrekening}{}{%
  \def\aes@bank{ING}%
  \def\aes@giro{3743305}%
  \def\aes@BIC{INGBNL2A}%
  \def\aes@IBAN{NL67 INGB 0003 7433 05}%
  \def\aes@rekeninghouder{Studievereniging \aeskwadraat{} inz Evenementen}%
}
\NewDocumentCommand{\ouderdagrekening}{}{%
  \evenementenrekening%
  \ClassWarningNoLine{aeskwadraatbrief}{Warning: The ouderdag account
  has been cancelled!\MessageBreak
  You probably want the event account,\MessageBreak
  so I've set it for you.}%
}
\NewDocumentCommand{\introrekening}{}{%
  \evenementenrekening%
  \ClassWarningNoLine{aeskwadraatbrief}{Warning: The intro account
  has been cancelled!\MessageBreak
  You probably want the event account,\MessageBreak
  so I've set it for you.}%
}
\NewDocumentCommand{\boekenrekening}{}{%
  \def\aes@bank{ABN Amro}%
  \def\aes@giro{50 7122 690}%
  \def\aes@BIC{ABNANL2A}%
  \def\aes@IBAN{NL69 ABNA 0507 1226 90}%
  \def\aes@rekeninghouder{Boekencommissaris}%
}
\girorekening
\newcommand\aes@uwk{}
\NewDocumentCommand{\uwk}{ m }{%
  \renewcommand\aes@uwk{#1}%
}
\newcommand\aes@onsk{}
\NewDocumentCommand{\onsk}{ m }{%
  \renewcommand\aes@onsk{#1}%
}
\newcommand\aes@email{%
        \ClassWarningNoLine{aeskwadraatbrief}{No e-mail address set.\MessageBreak
        Use \protect\email{<cie>@a-eskwadraat.nl}\space to
        \MessageBreak set it}
        bestuur@a-eskwadraat.nl%
}
\NewDocumentCommand{\email}{ m }{%
  \renewcommand\aes@email{#1}%
}
\newcommand\aes@datum{\today}
\NewDocumentCommand{\datum}{ m }{%
  \renewcommand\aes@datum{#1}%
}
\newcommand\aes@subject{\ClassWarningNoLine{aeskwadraatbrief}{
        No \protect\subject\space found.
        \MessageBreak Use \protect\subject{subject}\space to set \MessageBreak
        it. Default (empty) subject set}%
}
\NewDocumentCommand{\subject}{ m }{%
  \renewcommand\aes@subject{#1}
}
\let\onderwerp\subject
\newenvironment{aes@blist}{
        \begin{list}{\(\bullet\)}{%
                \raggedright
                \setlength\leftmargin{1em}
                \setlength\rightmargin{0pt}
                \setlength\labelwidth{0.6em}
                \setlength\labelsep{0.3em}
                \setlength\itemsep{0pt}
                \setlength\topsep{0pt}
                \setlength\parsep{0pt}
                \setlength\partopsep{0pt}
                \setlength\listparindent{0pt}
                \setlength\itemindent{0em}
        }%
}{%
        \end{list}%
}
\newcommand\aes@aantalbijlagen{0}
\newcommand\aes@bijlage{}
\NewDocumentCommand{\geenbijlagen}{}{%
  \renewcommand\aes@bijlage{}%
  \renewcommand\aes@aantalbijlagen{0}%
}
\newsavebox{\aes@devnull}%
\newcounter{aes@telbijlagen}%
\NewDocumentCommand{\bijlagen}{ +m }{%
  % First count the number of attachments and dump the
  % argument to the savebox \aes@devnull.
  \let\echtitem\item%
  \setcounter{aes@telbijlagen}{0}%
  \renewcommand\item{\stepcounter{aes@telbijlagen}}%
  % We count the number of attachments as the number of
  % uses of \item. If no \item is used, but the argument
  % is non-empty, we will treat it as a single item later on.
  \savebox{\aes@devnull}{#1}%
  \let\item\echtitem%
  %
  % Correct aes@telbijlagen and fill \aes@bijlage.
  \ifthenelse{\value{aes@telbijlagen}=0}{%
    % There are no \items
    \renewcommand\aes@bijlage{#1}%
    \ifthenelse{\equal{#1}{}}{%
      % There are no attachments.
    }{%
      % There is one attachment without \item
      \setcounter{aes@telbijlagen}{1}%
    }%
  }{%
    % There are \items
    \ifthenelse{\value{aes@telbijlagen}=1}{%
      % There is only one item: no bullets
      \renewcommand\aes@bijlage{%
        \renewcommand\item{}% Deletes the bullet
        #1
      }%
    }{%
      % There are several \items, so we make a list
      \renewcommand\aes@bijlage{%
        \begin{aes@blist}
        #1
        \end{aes@blist}
      }%
    }%
  }%
  % We save the number of attachments to \aes@aantalbijlagen
  % \edef gives the command the current value, rather than the
  % value of the counter at the time that the command is used
  \edef\aes@aantalbijlagen{\theaes@telbijlagen}%
}
\let\bijlage\bijlagen
\NewDocumentCommand{\bijlages}{ +m }{%
  \ClassWarningNoLine{aeskwadraatbrief}{%
  The command \protect\bijlages\space is no longer supported.\MessageBreak%
  Use \protect\bijlage\space or \protect\bijlagen.%
  }%
  \bijlagen{ #1 }%
}
\newcommand\aes@kixcode{}
\NewDocumentCommand{\kixcode}{ m }{%
  \renewcommand\aes@kixcode{\scantokens{#1}}%
}
\NewDocumentCommand{\opening}{ +m }{%
  \setboolean{aes@openinggezien}{true}%
  \aes@briefhoofd%
  #1\vspace{0.5\baselineskip}\par%
}
\let\aanhef\opening
\NewDocumentCommand{\geenopening}{}{%
  \setboolean{aes@openinggezien}{true}%
  \aes@briefhoofd%
}
\newcommand\sig[1]{%
\begin{minipage}[t][2cm][t]{55mm}%
\vspace*{1.3cm}#1%
\end{minipage}
}
\newcommand\aes@signature{%
\ClassError{aeskwadraatbrief}{No \protect\signature\space
given, but found a \protect\closing}
{Define a \protect\signature\space or remove the \protect\closing.}}
\NewDocumentCommand{\signature}{ +m }{%
  \renewcommand\aes@signature{\sig{#1}}%
}
\NewDocumentCommand{\signatures}{ +m +m }{%
  \renewcommand\aes@signature{\sig{#1}\hspace*{1cm}\sig{#2}}%
}
\NewDocumentCommand{\closing}{ +m }{%
  \par\vspace{0.5\baselineskip}%
  % deze minipage zorgt ervoor dat de \closing en
  % \signature altijd samen op 1 pagina staan
  \begin{minipage}{\textwidth}%
  #1\par\aes@signature%
  \end{minipage}%
}
\newcommand\aes@NL{\ifthenelse{\boolean{isbuitenland}}{,~NL}{}}
\newcommand\aes@returnline{\aesnaam, Princetonplein~5, 3584~CC~~Utrecht\aes@NL}
\newcommand\aes@bezoekadr{Buys Ballotgebouw, \TAALkamer~269\\
                          Princetonplein~5\\
                          3584~CC~~Utrecht\aes@NL}
\newcommand\aes@telefoon{+31\,30\,253\,44\,99}
\newcommand\aes@fax{+31\,30\,253\,57\,87}
\newcommand\aes@www{www.a-eskwadraat.nl}
\ifthenelse{\boolean{aes@ontour}}{%
  \setboolean{aes@optfooter}{false}%
  \email{ontour@A-Eskwadraat.nl}%
  \afzendernaam\TAALontournaam%
  \def\aes@kvknr{30230072}%
  \def\aes@bank{ING}%
  \def\aes@giro{4559482}%
  \def\aes@BIC{INGBNL2A}%
  \def\aes@IBAN{NL39 INGB 0004 5594 82}%
  \def\aes@rekeninghouder{\TAALontournaam}%
  \renewcommand\aes@returnline{%
    \aesnaam On Tour, Princetonplein~5, 3584~CC~~Utrecht\aes@NL}%
}{}
\ifthenelse{\boolean{aes@betadag}}{%
  \welkleur%
  \AtBeginDocument{\def\TAALfinancien#1#2{}}%
  \setboolean{aes@optfooter}{false}%
  \email{betadag@A-Eskwadraat.nl}%
  \afzendernaam{B\`etadag 2013}%
  \cienaam{Utrecht}%
  \renewcommand\aes@www{www.a-eskwadraat.nl/betadag}%
}{}
\newlength\aes@bhhoogte
\newcommand\aes@bhblok[2]{%
        \begin{minipage}[t][\aes@bhhoogte][t]{41mm}%
                {\aes@fontheader#1\vphantom{ghL}}\par%
                % The \vphantom is for consistent spacing
                {\aes@fonttext\raggedright#2\vphantom{ghL}}\par%
        \end{minipage}%
}
\newcommand\aes@leegbhblok{\aes@bhblok{~}{~}}
\NewDocumentCommand{\zetblokje}{ m +m +m }{%
\expandafter\gdef\csname blokje@#1\endcsname{\aes@bhblok{#2}{#3}}%
}
\NewDocumentCommand{\leegblokje}{ m }{%
\expandafter\gdef\csname blokje@#1\endcsname{\aes@leegbhblok}%
}
\newcommand\aes@briefhoofdblokjes{%
  \zetblokje{rb}{\TAALemail}{\aes@email}
  % The attachment block is only necessary
  % if there are attachments.
  \ifthenelse{\aes@aantalbijlagen=1}{%
    % One attachment
    \zetblokje{ro}{\TAALbijlage}{\aes@bijlage}
  }{%
    \ifthenelse{\aes@aantalbijlagen>1}{%
      % Multiple attachments
      \zetblokje{ro}{\TAALbijlagen}{\aes@bijlage}
    }{%
      % No attachments
      \leegblokje{ro}
    }%
  }%

  \ifthenelse{\equal{\aes@uwk}{} \and \equal{\aes@onsk}{}}{%
    \zetblokje{lb}{\TAALdatum}{\aes@datum}
    \zetblokje{mb}{\TAALonderwerp}{\aes@subject}
    \leegblokje{lo}
    \leegblokje{mo}
  }{%
    \zetblokje{lb}{\TAALuwkenmerk}{\aes@uwk}
    \zetblokje{mb}{\TAALonskenmerk}{\aes@onsk}
    \zetblokje{lo}{\TAALdatum}{\aes@datum}
    \zetblokje{mo}{\TAALonderwerp}{\aes@subject}
  }
}
\newlength\hoofd@temp
\newcommand\aes@briefhoofd{
        \vspace*{-119mm}\par%
        \setlength\hoofd@temp{\parskip}
        % Save the parskip, which we will change
        \setlength\parskip{1mm}%
        %
        % Make all blocks empty
        \leegblokje{lb}\leegblokje{mb}\leegblokje{rb}%
        \leegblokje{lo}\leegblokje{mo}\leegblokje{ro}%
        %
        % Run |\aes@briefhoofdblokjes| and
        % typeset all blocks
        \smash{\aes@briefhoofdblokjes}%
        %
        % First do the top blocks
        \setlength\aes@bhhoogte{17mm}%
        \blokje@lb\hspace*{3mm}%
        \blokje@mb\hspace*{3mm}%
        \blokje@rb\hspace*{4mm}%
        % Despite being set to 17 mm, the minipage's
        % height will be much larger than it
        % This goes right regardless
        \begin{minipage}[t][17mm][t]{45mm}%
                \raggedright
                \mbox{\aes@fontheader\bfseries\aes@afzendernaam}\par
                \mbox{\aes@fontheader\bfseries\aes@cienaam}
                  \vspace{.9\baselineskip}\par
                {\aes@fontheader%
                \aes@bezoekadr\vspace{.9\baselineskip}\par
                \TAALtelefoon~\aes@telefoon\vspace{.9\baselineskip}\par
                \TAALfinancien{\aes@kvknr}{\aes@IBAN}\par
                \@ifundefined{\aes@btwnr}
                {\TAALbtw{~\aes@btwnr}\vspace{.9\baselineskip}\par}
                {\vspace{.9\baselineskip}\par}
                \aes@www}
        \end{minipage}\par
        %
        % The bottom blocks
        \setlength\aes@bhhoogte{24mm}%
        \blokje@lo\hspace*{3mm}%
        \blokje@mo\hspace*{3mm}%
        \blokje@ro\par%
        %
        % Add the address
        \hspace*{5mm}% %% Address should be slightly
        % to the right due to the shape of
        % envelopes
        \begin{minipage}[t][47mm][t]{140mm}%
                {\aes@fontheader\aes@returnline}\\[.2ex]
                \aes@fontadres\aes@adres\\[0.5\baselineskip]
                \kix{\aes@kixcode}
                % If \aes@kixcode is empty,
                % this does nothing
        \end{minipage}\par
        %
        % logo
        \ifthenelse{\boolean{aes@optkleur}}{}{%
        \hfill%
        \begin{minipage}[b][0cm][t]{5cm}%
                \vspace*{-35mm}\par%
                % = -(logo height (32mm) + 1.5mm)
                \aeslogogrijs[5cm]
                % logo is 5cm on the real
                % letter paper, too
        \end{minipage}}
        \setlength\parskip{\hoofd@temp}
        \vspace*{4mm}\par%
        % We add a good distance to the opening
        % paragraph
}
\NewDocumentEnvironment{brief}{ +m }{%
        \ifthenelse{\boolean{aes@optfooter}}{\thispagestyle{footer}}{}
        % This adds the bottom text and UU logo
        \newcommand\aes@adres{#1}
        % \opening does the rest, due to scoping
        \newboolean{aes@openinggezien}%
        \setboolean{aes@openinggezien}{false}%
}{%
  \ifthenelse{\boolean{aes@openinggezien}}{}{%
    \ClassError{aeskwadraatbrief}{You forgot \protect\opening{Dear ...,}\space}
    {TeXniCie requires beer.}%
  }%
        \clearpage%
}
\NewDocumentEnvironment{letter}{ +m }{\begin{brief}{#1}}{\end{brief}}
\endinput
%%
%% End of file `aeskwadraatbrief.cls'.
