/*
 * SOURCE:  rdel.c
 * PROJECT: rdel
 *
 * PURPOSE: main module
 *
 */
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

#include "dos.h"

struct Entry {
    struct Entry *next;
    unsigned char file[13];
};

    // function prototypes
int main( int, char ** );
int rdel( int, char ** );
int rmfiles( char * );

int main( int argc, char **argv ) {

    return rdel( argc-1, argv+1 );
}


int rdel( int argc, char **argv ) {

    struct DiskTransferArea _far *dta;
    struct Entry first, *curr;
    int i, ret;

    /* first, delete the files */
    for( i = 0; i < argc; ++i )
        rmfiles( argv[i] );

    /* read directory */
    dta = GetDTAAddress();

    curr = &first;
    curr->next = 0L;

    if( FindFirstFile( "*.*", DTA_DIRECTORY ) )
    {
        do
        {
            if( dta->Attributes & DTA_DIRECTORY )
            {
                if( _fstrcmp( dta->Name, "." )
                &&  _fstrcmp( dta->Name, ".." ) ) {
                    curr->next = _fmalloc( sizeof(struct Entry) );
                    if( curr->next == 0L ) {
                        exit( 99 );
                    }

                    curr = curr->next;
                    curr->next = 0L;
                    _fstrncpy( curr->file, dta->Name, 13 );
                }
            }
        }while( FindNextFile() );

        for( curr = first.next; curr; curr = curr->next ) {
            SetCurrDir( curr->file );
            ret = rdel( argc, argv );
            if( ret )
                return ret;
            SetCurrDir( ".." );
        }
    }

    return 0;
}

int rmfiles( char *mask ) {

    struct DiskTransferArea _far *dta;
    struct Entry first, *curr;
    int ret;

    /* read directory */
    dta = GetDTAAddress();

    curr = &first;
    curr->next = 0L;

    if( FindFirstFile( mask, 0 ) )
    {
        do
        {
            if( ! (dta->Attributes & DTA_DIRECTORY) )
            {
                curr->next = _fmalloc( sizeof(struct Entry) );
                if( curr->next == 0L ) {
                    exit( 99 );
                }

                curr = curr->next;
                curr->next = 0L;
                _fstrncpy( curr->file, dta->Name, 13 );
            }
        }while( FindNextFile() );

        for( curr = first.next; curr; curr = curr->next ) {
            Delete( curr->file );
        }
    }

    return 0;
}

/* end of file rdel.c */
