/*
 * SOURCE:  macros.h
 * PROJECT: EasyTeX
 *
 * PURPOSE: macros and defines
 *
 * UPDATES: 08/15/1991 - major rewrite
 *
 * (c)M.Schollmeyer
 */
#ifndef MACROS_H
#define MACROS_H

/* define NULL pointer value */
#define NULL    ((void *)0)

                        /* some standard macros */
#define _i2asc(i) ((char)('0'+((char)(i) & 0xff)))
#define _2lower(c) ( ((c)>='A' && (c)<='Z') ? (c)+('a'-'A') : (c) )
#define _2upper(c) ( ((c)>='a' && (c)<='z') ? (c)-('a'-'A') : (c) )

#define _MAX(a,b) ( (a)<(b) ? (b) : (a) )
#define _MIN(a,b) ( (a)<(b) ? (a) : (b) )
#define _SGN(a)   ( ((a)>0) ? 1 : ((a)<0) ? -1 : 0 )
#define _ABS(a)   ( ((a)>0) ? (a) : -(a) )

#define ever (;;)

#define SKIPBLK( cp ) while( *cp == ' ' || *cp == '\t' ) ++cp;

#define SETBIT( flags, bit )    ((flags) |= (bit))
#define CLEARBIT( flags, bit )  ((flags) &= ~(bit))

#define TRUE 1
#define FALSE 0
#define CANCEL -1

typedef char BOOL;
typedef unsigned char UBYTE;
typedef UBYTE *APTR;

#define CODEBASED /* _based( _segname( "_CODE" ) ) */

#endif
