/*
 * SOURCE:  bios.h
 * PROJECT: EasyTeX
 *
 * PURPOSE: function prototypes and defines
 *
 * UPDATES: 08/15/1991 - major rewrite
 *
 * (c)M.Schollmeyer
 */
#ifndef BIOS_H
#define BIOS_H

#include "macros.h"

#define MBUTTON_LEFT 1
#define MBUTTON_RIGHT 2
#define MBUTTON_CENTER 4
#define DOUBLE_CLICK( b ) ( (b) << 3 )

                        /* bios keyboard keystrokes */
#define BK_BREAK    0x0000
#define BK_ESC      0x011b
#define BK_BACKSP   0x0e08
#define BK_TAB      0x0f09
#define BK_BACKTAB  0x0f00
#define BK_RETURN   0x1c0d
#define BK_HOME     0x4700
#define BK_UP       0x4800
#define BK_PGUP     0x4900
#define BK_LEFT     0x4b00
#define BK_RIGHT    0x4d00
#define BK_END      0x4f00
#define BK_DOWN     0x5000
#define BK_PGDOWN   0x5100
#define BK_INS      0x5200
#define BK_DEL      0x5300
#define BK_SPACE    0x3920
#define BK_CTRL_H   0x2308
#define BK_F1       0x3b00
#define BK_F4       0x3e00

            /* macros to split GetMouse return value into its x and
             * y coordinate
             */
#define MOUSEX( gm ) ( (unsigned int)( gm >> 8 ) )
#define MOUSEY( gm ) ( (unsigned int)( gm & 0xff ) )

            /* macros to split GetMouseMove return value into its x and
             * y coordinate
             */
#define MOUSEMOVEY( gm ) ( (unsigned int)( gm >> 8 ) )
#define MOUSEMOVEX( gm ) ( (unsigned int)( gm & 0xff ) )

#define HOOK_WAIT 0
#define HOOK_TIME 1
#define HOOK_HELP 2
#define HOOK_MSG  3

struct InputEvent {
unsigned int key;           /* byte value from keyboard buffer */
unsigned int shift;         /* shift status from keyboard */
unsigned char cursorx;      /* cursor position */
unsigned char cursory;
unsigned int mousestatus;   /* number of mouse buttons, 0 if no mouse */
unsigned int mousex;        /* mouse position */
unsigned int mousey;
unsigned int buttons;       /* mouse buttons */
unsigned int doublepress;
unsigned char actual_page;
unsigned int (*wait_input )( void );      /* interrupt routines */
unsigned int (*wait_time )( int );
unsigned int (*helpfunc)( int );
unsigned int (*msgfunc)( int, char * );
};

    /* flags for InputEvent.shift */
#define IES_RIGHTSHIFT (1<<0)
#define IES_LEFTSHIFT  (1<<1)
#define IES_SHIFT      (IES_RIGHTSHIFT|IES_LEFTSHIFT)
#define IES_CTRL       (1<<2)
#define IES_ALT        (1<<3)
#define IES_SCROLL     (1<<4)
#define IES_NUMLOCK    (1<<5)
#define IES_CAPSLOCK   (1<<6)
#define IES_INSERT     (1<<7)


struct Cursor {
unsigned char Start;
unsigned char End;
unsigned char XPos;
unsigned char YPos;
};

#define MAXMACROCHARS 300

        // constants for GetLearnState()
#define LEARNMODE 1
#define MACROMODE 2

            /* function prototypes
             */
struct InputEvent *InputEventAddr( void );
unsigned int ( *SetHook( unsigned int ( * )(), int ))();
unsigned char SetActualPage( unsigned char );
    /* pagenum , returns previously active page */
void ToggleBlink( unsigned char );
void SetCursorSize( unsigned char, unsigned char ); /* start, end */
void ClearCursor( void );
void SetCursorPos( int, int );  /* col, row */
void SetVisualPage( int );          /* page */
void SetKeyRate( int, int );      /* SetKeyRate( delay, rate )
                                     * rate  00h ... 1fh
                                     * delay 00h ... 03h
                                     */
unsigned int ReadKeybrd( void );
unsigned int CheckKeybrd( void );
BOOL ScanKeybrd( unsigned int key );

void SetOverscan( unsigned char );
unsigned char GetOverscan( void );

int Delay( unsigned long );        /* wait for specified microseconds
                                     * WARNING: don't wait while sound is on!
                                     * RETURN CODE: 1: waited successful
                                     *              0: not successful
                                     */

int ResetMouse( void );    /* returns number of buttons - zero if no mouse */
void ShowMouse( void );    /* display mouse pointer */
void HideMouse( void );    /* hide mouse pointer */

unsigned int GetMouse( void ); /* get actual mouse position... */
void SetMouse( int, int );  /* Set Mouse Pointer Position SetMouse( x, y ) */
void SetPointerPage( int ); /* select the mouse pointer display page */
unsigned long GetMouseMove( void );

void SetDoubleClick( unsigned int );

void SetLearnKey( unsigned int );
void SetHelpKey( unsigned int );

char GetLearnState( void );

void SetLearnKey( unsigned int );
char GetLearnState( void );
unsigned int *GetMacroBuf( int );
void SetMacroBuf( int, unsigned int * );

void LaunchMacro( unsigned int *, int );
void PrintTime( void );

struct InputEvent *ReadInput( void ); /* wait for something to happen... */
struct InputEvent *GetInput( void );/* read input structure and don't wait */
void GetCursor( char, struct Cursor * );
unsigned long GetClockCounter( void );

#endif

