/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.texlipse.model.OutlineNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexOutlineInput {
    private List<OutlineNode> rootNodes;
    private int treeDepth;
    private Map<Integer, List<OutlineNode>> typeLists;

    public TexOutlineInput(List<OutlineNode> rootNodes) {
        this.rootNodes = rootNodes;
        this.typeLists = new HashMap<Integer, List<OutlineNode>>();
        this.treeDepth = -1;
    }

    public void addNode(OutlineNode node) {
        List<OutlineNode> typeList = this.typeLists.get(node.getType());
        if (typeList == null) {
            typeList = new ArrayList<OutlineNode>();
            this.typeLists.put(node.getType(), typeList);
        }
        typeList.add(node);
    }

    public List<OutlineNode> getTypeList(int nodeType) {
        if (this.typeLists.containsKey(nodeType)) {
            return this.typeLists.get(nodeType);
        }
        return null;
    }

    public List<OutlineNode> getRootNodes() {
        return this.rootNodes;
    }

    public void setRootNodes(List<OutlineNode> rootNodes) {
        this.rootNodes = rootNodes;
    }

    public int getTreeDepth() {
        if (this.treeDepth == -1) {
            this.calculateTreeDepth();
        }
        return this.treeDepth;
    }

    public void setTreeDepth(int treeDepth) {
        this.treeDepth = treeDepth;
    }

    public void calculateTreeDepth() {
        this.treeDepth = 0;
        for (OutlineNode node : this.rootNodes) {
            int localDepth = this.handleNode(node, 0);
            if (localDepth <= this.treeDepth) continue;
            this.treeDepth = localDepth;
        }
    }

    private int handleNode(OutlineNode node, int parentDepth) {
        ArrayList<OutlineNode> children = node.getChildren();
        int maxDepth = parentDepth + 1;
        if (children != null) {
            for (OutlineNode child : children) {
                int localDepth = this.handleNode(child, parentDepth + 1);
                if (localDepth <= maxDepth) continue;
                maxDepth = localDepth;
            }
        }
        return maxDepth;
    }
}

