/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor.hover;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.TexEditor;
import net.sourceforge.texlipse.model.AbstractEntry;
import net.sourceforge.texlipse.model.ReferenceEntry;
import net.sourceforge.texlipse.model.ReferenceManager;
import net.sourceforge.texlipse.model.TexCommandEntry;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TexInformationControl
implements IInformationControl,
IInformationControlExtension {
    private AbstractEntry entry = null;
    private ReferenceManager refMana;
    private IDocument document;
    private TexEditor editor;
    private Image image;
    private Composite imageComposite;
    private Composite textComposite;
    private Shell shell;
    private int maxWidth;
    private Display display;
    private boolean hasImage = false;
    private StyledText hoverText;

    public TexInformationControl(TexEditor editor, Shell container) {
        this.editor = editor;
        this.document = editor.getTexDocument();
        this.refMana = editor.getDocumentModel().getRefMana();
        this.shell = new Shell(container, 540672);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        this.shell.setLayout((Layout)layout);
        this.display = this.shell.getDisplay();
        this.shell.setBackground(this.display.getSystemColor(29));
    }

    private void initTextBox() {
        this.textComposite = new Composite((Composite)this.shell, 0);
        this.textComposite.setLayout((Layout)new FillLayout());
        GridData gdata = new GridData(4, 128, true, false);
        this.textComposite.setLayoutData((Object)gdata);
        this.hoverText = new StyledText(this.textComposite, 64);
        this.hoverText.setBackground(this.display.getSystemColor(29));
    }

    private void createImageComp() {
        this.imageComposite = new Composite((Composite)this.shell, 0);
        this.imageComposite.setBackground(this.display.getSystemColor(1));
        this.imageComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                try {
                    GC gc = e.gc;
                    gc.drawRectangle(0, 0, e.width - 1, e.height - 1);
                    if (TexInformationControl.this.hasImage) {
                        gc.drawImage(TexInformationControl.this.image, 2, 2);
                    }
                }
                catch (Exception ex) {
                    TexlipsePlugin.log("TexInformationControl: ", ex);
                }
            }
        });
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = false;
        data.verticalAlignment = 128;
        if (this.image != null) {
            data.widthHint = this.image.getBounds().width + 4;
            data.heightHint = this.image.getBounds().height + 4;
        }
        this.imageComposite.setLayoutData((Object)data);
        this.imageComposite.pack();
    }

    private void setCommandText(String text) {
        StyleRange bold = new StyleRange();
        bold.fontStyle = 1;
        int endLine = text.indexOf(10);
        int endBold = endLine >= 0 ? endLine : text.length();
        this.hoverText.append(text.substring(0, endBold));
        bold.start = 0;
        bold.length = endBold;
        this.hoverText.setStyleRange(bold);
        if (endLine >= 0) {
            this.hoverText.append(text.substring(endLine));
        }
    }

    private static String getArgument(String text) {
        int begin = text.indexOf(123);
        int end = text.indexOf(125);
        if (begin > -1 && end > begin) {
            return text.substring(begin + 1, end);
        }
        return "";
    }

    private static String getCommand(String text) {
        int begin = text.indexOf(123);
        if (begin > -1) {
            return text.substring(0, begin);
        }
        return text;
    }

    private void setBibHover(String ref) {
        ReferenceEntry bibentry = this.refMana.getBib(ref);
        if (bibentry != null) {
            this.entry = bibentry;
            this.initTextBox();
            this.hoverText.setText(bibentry.info);
        }
    }

    private boolean setRefHover(String labelName) {
        ReferenceEntry label = this.refMana.getLabel(labelName);
        if (label != null) {
            this.entry = label;
            this.initTextBox();
            this.hoverText.setText(label.info);
            return true;
        }
        return false;
    }

    public void setInformation(String information) {
        this.entry = null;
        this.hasImage = false;
        if (information.startsWith("\\")) {
            String command = information.substring(1);
            if (command.indexOf("ref") > -1 && command.indexOf("{") > -1) {
                if (!this.setRefHover(TexInformationControl.getArgument(command))) {
                    return;
                }
            } else {
                TexCommandEntry comEntries = this.refMana.getEntry(TexInformationControl.getCommand(command));
                if (comEntries != null) {
                    this.entry = comEntries;
                    if (comEntries.imageDesc != null) {
                        this.hasImage = true;
                        this.image = comEntries.getImage();
                        this.createImageComp();
                    }
                    this.initTextBox();
                    if (comEntries.info != null) {
                        this.setCommandText(comEntries.info);
                    }
                } else {
                    return;
                }
            }
            this.shell.pack();
            int w = this.shell.getSize().x;
            int h = this.shell.getSize().y;
            int fontHeight = this.hoverText.getFont().getFontData()[0].getHeight() + 2;
            if (w > this.maxWidth) {
                int plus = h * w / this.maxWidth - h;
                if (plus % fontHeight != 0) {
                    plus = (plus / fontHeight + 1) * fontHeight;
                }
                h += plus;
                w = this.maxWidth;
            }
            this.shell.setSize(w, h);
            this.shell.layout();
        } else {
            this.setBibHover(information.trim());
        }
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
    }

    public Point computeSizeHint() {
        if (this.entry != null) {
            return this.shell.getSize();
        }
        return this.shell.computeSize(-1, -1);
    }

    public void setVisible(boolean visible) {
        this.shell.setVisible(visible);
    }

    public void setSize(int width, int height) {
        this.shell.setSize(width, height);
    }

    public void setLocation(Point location) {
        this.shell.setLocation(location);
    }

    public void dispose() {
        this.shell.dispose();
    }

    public void addDisposeListener(DisposeListener listener) {
        this.shell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.shell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.hoverText.setForeground(foreground);
        this.shell.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.hoverText.setBackground(background);
        this.shell.setBackground(background);
    }

    public boolean isFocusControl() {
        return !this.hasImage;
    }

    public void setFocus() {
        if (!this.hasImage) {
            this.shell.forceFocus();
            this.hoverText.setFocus();
        }
    }

    public void addFocusListener(FocusListener listener) {
        this.shell.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.shell.removeFocusListener(listener);
    }

    public boolean hasContents() {
        return this.entry != null;
    }
}

