#ifndef MP_LEAFTREE_H
#define MP_LEAFTREE_H
/*****************************************************************
**
** MathSpad 0.60
**
** Copyright 1996, Eindhoven University of Technology (EUT)
** 
********************************************************************/

/*
** leaftree.h
**
** The leaftree represents a set of values.  Only the leafs contain valid
** informatain and the tree structure is used to find the values.
** The tree is height balanced and the values are sorted.
**
** A leaftree uses 2 different type, one for the leafs and one for the
** nodes. The type definition for the nodes is given below and the only
** restriction on the type definition for the leafs is that is should
** look like
**
** struct lnode {
**     char kind;
**     MT val;
**     ....
** }
**
** The functions that manipulate leaftrees only use the size of this
** leaf type and the fact that the first couple of bytes contain these
** fields.
**
** The type MT can be any ordinal type (char, short, integer, void *)
*/

typedef unsigned short MT;
typedef struct tnode LeafTree;

struct tnode {
    char kind;
    MT val;
    short bal;
    LeafTree *left;
    LeafTree *right;
};

extern void set_leafsize(int lsize);
extern void set_free_leaf(void (*flf)(void*));
extern void free_leaftree(LeafTree * lt);
extern LeafTree* insert(LeafTree *lt, MT val);
extern LeafTree* delete(LeafTree *lt, MT val);
extern LeafTree* add_leaftree(LeafTree *lt, LeafTree *ltadd);
extern int  member(LeafTree *lt, MT val);
extern void *found_leaf(void);
#endif
