########################################################################
# sgmlspl script for a *supplemented* version of SGMLS.pm that, when
#    reading an nsgmls ESIS with empty tag labels, provides detection
#    of defined-empty elements with the method  $element->defempty .
#
# Document Type: article (GELLMU)
# Output: text/xml (non-public -- suffix .zml)
# Edited by: William F. Hammond
# Begun: 21 November 1998
#
# Prepare GELLMU article for a subsequent non-validating parse
# for processing to XHTML + MathML by providing the following
# filled-in attributes for all elements inside one of the 5 math
# containers (math, tmath, displaymath, equation, eqnarray):
# mlvl, mseq, mchld, and mdepth
########################################################################

use utf8;
$utf8On = 1;

use SGMLS;                      # Use the SGMLS package.
use SGMLS::Output;              # Use stack-based output.

$WhoAmI = "mathprep.pl";

# Global variables
$digmode=0;     # Flag for spawning mathml attributes
$eltser=0;
$eltdepth=0;
$encoding="UTF-8";
$fgmi = "";     # Open string for math identifier list, handle FGMI
$lgmi = 0;      # Flag for whether FGMI is open
$gmath = 0;     # Inside math or not?
$maxeltdepth=0;
@mdepth = ();       # math depth: number of descendent generations
$mdepth[0][0] = 0;
$mlvl = 0;          # math level
@mseq = ();         # sibling sequence at current math level, i.e.,
$mseq[0] = 0;       #   $mseq[$mlvl] = seq no of curr elt at curr level
                    #   attr mseq="3" means elt is seq 3 at its level
@mchld = ();        # name of element at given level and sequence, i.e.,
$mchld[0][0] = "";  #   $mchld[$lvl][$jseq]
@matts = ();        # attribute sequence at given level and sequence, i.e.,
$matts[0][0] = "";  #   $matts[$lvl][$jseq]
@mout = ();         # math content at given math level by sequence, i.e.,
$mout[0][0] = "";   #   $mout[$mlvl][$jseq]
@nchld = ();        # number of children at given level
$nchld[0] = 0;      #   $nchld[$lvl] = no of children at curr level
@passopen=();       # For math: output for $mlvl passed from start_ to end_
$passopen[0] = "";
$stemname = "";
@mtree = ();
$xmlinput = 1;      # Is input an xml document?

###
sgml('start', sub{
    print STDERR $0, " *** ", $WhoAmI, "\n";
    $eltdepth = 0;
    my $os = "";
    $os = $os . "<?xml version=\"1.0\" encoding=\"" . $encoding . "\"?>\n";
    $os = $os . "<!DOCTYPE article\n  SYSTEM "
        . '"http://www.albany.edu/~hammond/gellmu/xml/uxgellmu.dtd">' . "\n";
    $os = $os . "<?gellmu mathprep : XML not for distribution?>\n";
    output($os);
});

###
sgml('end', sub{
    if (!($eltdepth == 0)){
        print STDERR "WARNING: Coding error in sgmlspl file: ", $WhoAmI,
        "\n    eltdepth not balanced; ending with value ", $eltdepth, ".\n";
    };
    output("\n");
    print STDERR "  No. of elts.: ", $eltser,
                 "; max elt. depth ", $maxeltdepth, "\n";
});

###
sgml('start_element', sub{
    $eltser++;
    $eltdepth++;
    if($maxeltdepth < $eltdepth){$maxeltdepth = $eltdepth;};
    $currserial[$eltdepth] = $eltser;
    my ($element, $event) = @_;
    my $name = $element->name;
    my $oname = $name;
    my $os = "";
    my $plvl = 0;
    my $pseq = 0;
    if($name eq "article"){
	$stemname = $element->attribute("stem")->value;
	if($stemname ne ""){
	    my $stempat = "^.*/";
	    $stemname =~ s/$stempat//;
	    $fgmi = ">" . $stemname . ".xfi";
	    $lgmi = open(FGMI, $fgmi);
	    if($lgmi == 0){
		print STDERR "mathprep.pl: Cannot open file \"", $stemname,
		".xfi\" for output\n";
	    };
	}
	else{
	    print STDERR "mathprep.pl WARNING: \"stem\" name not found\n";
	};
    };
    if($name =~ /^(math|tmath|displaymath|equation|eqnarray)$/){
        $gmath = 1;
	$digmode = 1;
    };
    if($gmath > 0){
        $plvl = $mlvl;                 # level of parent for indexing
                                       #    information about this elt
        $mseq[$plvl]++;                # seq of this elt in its parent
        $pseq = $mseq[$plvl];
        $mchld[$plvl][$pseq] = $name;  # enter name as record for parent
        $mlvl++;                       # set level of curr elt
        $mseq[$mlvl] = 0;              # zero seq for children
    };
    my $open= "";
    my $osatt = "";
    my $clcm = "\n>";
    my $clc = $clcm;
    my @attn = ();
    my @atty = ();
    my @attv = ();
    my $jj = 0;
    my $nat = get_attributes($element, \@attn, \@atty, \@attv);
    if($nat > 0){
        $jj = 0;
        while($jj < $nat){
            if(($atty[$jj] =~ /CDATA|IMPLIED|TOKEN/ ) && ($attv[$jj] ne "")){
                if(!(($gmath == 0) &&
                     (($attn[$jj] eq "mml") || ($attn[$jj] eq "mtype")))){
                    $osatt = $osatt . " " . $attn[$jj] 
                                    . '="' . $attv[$jj] . '"';
                };
            };
            $jj++;
        };
    };
    if(($mlvl > 0) && ($digmode == 1)){
        $osatt = $osatt . ' mlvl="' . $mlvl . '"';
        $osatt = $osatt . ' mseq="' . $pseq . '"';
    };
    if($element->defempty){
        if( ($name eq "nul") && ($pan eq "mathsym") ){
            return;
        };
        $clcm = "\n/>";
        $clc = $clcm;
	if($gmath > 0){
	    $mlvl--;
	    if($digmode == 1){
		$mdepth[$mlvl][$pseq] = 0;
		$osatt = $osatt . ' mdepth="0"';
	    };
	    $os = "<" . $oname . $osatt . $clc;
	    $mout[$mlvl][$pseq] = $os;
        }
        else{
	    $os = "<" . $oname . $osatt . $clc;
            output($os);
        };
    }
    elsif($gmath > 0){
        $passopen[$mlvl] = $osatt;
	my $elt = $_[0];
	if($name eq "text"){
	    $digmode = 0;
	};
	if(($name eq "Cd0") || !($elt->within("mbox") eq "")
	   || !($elt->within("text") eq "")){
	    push_output('string');
	};
    }
    else{
	$os = "<" . $oname . $osatt . $clc;
        output($os);
    };
});

###
sgml('end_element', sub{
    $eltdepth--;
    my ($element, $event) = @_;
    if($element->defempty){
        return;
    };
    my $mchldepth = 0;
    my $name = $element->name;
    my $oname = $name;
    my $pan = "";
    my $pos = "";
    my $harvest = "";
    my $os = "";
    my $osatt = "";
    my $open = "";
    my $close = "";  # Output string beginning with closetag
    my $clcm = "\n>";
    my $jseq = 0;
    my @jchld = ();
    my $jj = 0;
    my $plvl = 0;
    my $pseq = 0;
    if($gmath > 0){
	$osatt = $osatt . $passopen[$mlvl];
	my $elt = $_[0];
	if(($name eq "Cd0") || !($elt->within("mbox") eq "")
	   || !($elt->within("text") eq "")){
	    $pos = pop_output;
	    $harvest = $pos;
	    # begin change 20041229
	    if($elt->within("text") ne ""){
		$pan = $element->parent->name;
		if($pan ne "text"){
		    my $txopen = "";
		    my $txclose = "";
		    $txopen = $txopen . "<" . $oname;
		    $txopen = $txopen . $osatt . $clcm;
		    $os = $os . $txopen . $pos;
		    $txclose = "</" . $oname . $clcm;
		    $os = $os . $txclose;
		    output($os);
		};
	    };
	    # end change 20041229
	}
	else{
	    $jseq = $mseq[$mlvl];    # no of children of curr elt
	    $nchld[$mlvl] = $jseq;
	    # make mchld and mdepth attributes
	    $mchldepth = 0;
	    if($jseq > 0){
		# This is the opportunity, if any is here, for re-arrangment
		while($jj < $jseq){
		    $jchld[$jj] = $mchld[$mlvl][$jj+1];
		    $harvest = $harvest . $mout[$mlvl][$jj+1];
		    if(($digmode == 1) && 
		       ($mdepth[$mlvl][$jj+1] + 1 > $mchldepth)){
			$mchldepth = $mdepth[$mlvl][$jj+1] + 1;
		    };
		    $jj++;
		};
	    };
	    if($digmode == 1){
		$osatt = $osatt . ' mdepth="' . $mchldepth . '"';
	    };
	};
	if($jseq >= 0){
	    $osatt = $osatt . ' mchld="' . join(',', @jchld) . '"';
	};
	if($name eq "text"){
	    $digmode = 1;
	};
	$open = $open . "<" . $oname;
        $open = $open . $osatt . $clcm;
        $os = $os . $open . $harvest;
        $close = "</" . $oname . $clcm;
        $os = $os . $close;
        $mlvl--;                  # back to level of parent
        $plvl = $mlvl;
        $pseq = $mseq[$plvl];
        if($plvl > 0){
            $mout[$plvl][$pseq] = $os;
	    if($digmode == 1){
		$mdepth[$plvl][$pseq] = $mchldepth;
	    };
        }
        else{
            output($os);
        };
        if($name =~ /^(math|tmath|displaymath|equation|eqnarray)$/){
            $gmath = 0;
	    $digmode = 0;
            if($mlvl != 0){
                print STDERR $WhoAmI,
                " -- WARNING: Variable mlvl unbalanced in ", $name ,
                " value: ", $mlvl, "\n";
            };
        };
    }
    else{
        $close = "</" . $oname . $clcm;
        $os = $os . $close;
        output($os);
    };
    if($name eq "article"){
	if($lgmi != 0){
	    close(FGMI);
	};
    };
});

###
# sgml('cdata', sub{output($_[0]);});

###
sgml('pi',sub{
    my $inst = $_[0];
    my $os = "";
    if($inst =~ /^xml /){
        $xmlinput = 1;
    }
    else{
        $os = "<?" . $_[0] . "?>\n";
    };
    output($os);
});

###
sgml('re', sub{
    return;
});

###
sub get_attributes {
    my ($elt, $rattn, $ratty, $rattv) = @_;
    # $rattn, $rattv are references to passed arrays
    my $attref = $elt->attributes;
    my %atts = %$attref;
    my @atns = keys(%atts);
    my $nat = scalar @atns;
    my $jj = 0;
    my $jty = "";
    my $jvs = "";
    while($jj < $nat){
        $$rattn[$jj] = $atns[$jj];
        $jty = $atts{$atns[$jj]}->type;
        $$ratty[$jj] = $jty;
        if($jty eq "CDATA"){
            $jvs = $atts{$atns[$jj]}->value;
        }
        elsif($jty eq "TOKEN"){
            $jvs = $atts{$atns[$jj]}->value;
        }
        elsif($jty eq "IMPLIED"){
            $jvs = $atts{$atns[$jj]}->value;
        }
        elsif(($jty eq "NOTATION")||($jty eq "ENTITY")){
            $jvs = "WARNING: attribute type " . $jty
                   . " not supported by this code";
        }
        else{
            $jvs = "WARNING: ATTRIBUTE TYPE ERROR: " . $jty;
        }
        $$rattv[$jj] = $jvs;
        $jj++;
    };
    return $nat;
};

1;
