/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer;

import java.io.File;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.ArtifactVerificationOperation;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.VerificationEntry;
import org.gradle.api.internal.artifacts.verification.model.ChecksumKind;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;

class ChecksumEntry
extends VerificationEntry {
    private final ChecksumKind checksumKind;
    private final int hashCode;
    private String checksum;

    ChecksumEntry(ModuleComponentArtifactIdentifier id, ArtifactVerificationOperation.ArtifactKind artifactKind, File file, ChecksumKind checksumKind) {
        super(id, artifactKind, file);
        this.checksumKind = checksumKind;
        this.hashCode = this.precomputeHashCode();
    }

    private int precomputeHashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.getFile().getName().hashCode();
        result = 31 * result + this.getArtifactKind().hashCode();
        result = 31 * result + this.checksumKind.hashCode();
        return result;
    }

    ChecksumKind getChecksumKind() {
        return this.checksumKind;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    @Override
    int getOrder() {
        return this.checksumKind.ordinal();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChecksumEntry that = (ChecksumEntry)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.getArtifactKind().equals((Object)that.getArtifactKind())) {
            return false;
        }
        if (!this.getFile().equals(that.getFile())) {
            return false;
        }
        return this.checksumKind == that.checksumKind;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }
}

