/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.capabilities.CapabilityInternal;
import org.gradle.api.internal.java.DefaultJavaPlatformExtension;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlatformExtension;
import org.gradle.api.plugins.JvmEcosystemPlugin;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.component.external.model.ShadowedImmutableCapability;

public abstract class JavaPlatformPlugin
implements Plugin<Project> {
    public static final String API_CONFIGURATION_NAME = "api";
    public static final String RUNTIME_CONFIGURATION_NAME = "runtime";
    public static final String API_ELEMENTS_CONFIGURATION_NAME = "apiElements";
    public static final String RUNTIME_ELEMENTS_CONFIGURATION_NAME = "runtimeElements";
    public static final String ENFORCED_API_ELEMENTS_CONFIGURATION_NAME = "enforcedApiElements";
    public static final String ENFORCED_RUNTIME_ELEMENTS_CONFIGURATION_NAME = "enforcedRuntimeElements";
    public static final String CLASSPATH_CONFIGURATION_NAME = "classpath";
    private static final String DISALLOW_DEPENDENCIES = "Adding dependencies to platforms is not allowed by default.\nMost likely you want to add constraints instead.\nIf you did this intentionally, you need to configure the platform extension to allow dependencies:\n    javaPlatform.allowDependencies()\nFound dependencies in the '%s' configuration.";
    private final SoftwareComponentFactory softwareComponentFactory;

    @Inject
    public JavaPlatformPlugin(SoftwareComponentFactory softwareComponentFactory) {
        this.softwareComponentFactory = softwareComponentFactory;
    }

    public void apply(Project project) {
        if (project.getPluginManager().hasPlugin("java")) {
            throw new IllegalStateException("The \"java-platform\" plugin cannot be applied together with the \"java\" (or \"java-library\") plugin. A project is either a platform or a library but cannot be both at the same time.");
        }
        project.getPluginManager().apply(BasePlugin.class);
        project.getPluginManager().apply(JvmEcosystemPlugin.class);
        this.createConfigurations((ProjectInternal)project);
        this.configureExtension(project);
        this.configurePublishing(project);
    }

    private void createSoftwareComponent(Project project, Configuration apiElements, Configuration runtimeElements) {
        AdhocComponentWithVariants component = this.softwareComponentFactory.adhoc("javaPlatform");
        project.getComponents().add((Object)component);
        component.addVariantsFromConfiguration(apiElements, (Action)new JavaConfigurationVariantMapping("compile", false));
        component.addVariantsFromConfiguration(runtimeElements, (Action)new JavaConfigurationVariantMapping(RUNTIME_CONFIGURATION_NAME, false));
    }

    private void createConfigurations(ProjectInternal project) {
        RoleBasedConfigurationContainerInternal configurations = project.getConfigurations();
        ShadowedImmutableCapability enforcedCapability = new ShadowedImmutableCapability((CapabilityInternal)new ProjectDerivedCapability((Project)project), "-derived-enforced-platform");
        Configuration api = configurations.bucket(API_CONFIGURATION_NAME);
        Configuration apiElements = this.createConsumableApi(project, api, API_ELEMENTS_CONFIGURATION_NAME, "platform");
        Configuration enforcedApiElements = this.createConsumableApi(project, api, ENFORCED_API_ELEMENTS_CONFIGURATION_NAME, "enforced-platform");
        enforcedApiElements.getOutgoing().capability((Object)enforcedCapability);
        Configuration runtime = project.getConfigurations().bucket(RUNTIME_CONFIGURATION_NAME);
        runtime.extendsFrom(new Configuration[]{api});
        Configuration runtimeElements = this.createConsumableRuntime(project, runtime, RUNTIME_ELEMENTS_CONFIGURATION_NAME, "platform");
        Configuration enforcedRuntimeElements = this.createConsumableRuntime(project, runtime, ENFORCED_RUNTIME_ELEMENTS_CONFIGURATION_NAME, "enforced-platform");
        enforcedRuntimeElements.getOutgoing().capability((Object)enforcedCapability);
        Configuration classpath = configurations.createWithRole(CLASSPATH_CONFIGURATION_NAME, ConfigurationRolesForMigration.RESOLVABLE_BUCKET_TO_RESOLVABLE);
        classpath.extendsFrom(new Configuration[]{runtimeElements});
        this.declareConfigurationUsage(project.getObjects(), classpath, "java-runtime", "jar");
        this.createSoftwareComponent((Project)project, apiElements, runtimeElements);
    }

    private Configuration createConsumableRuntime(ProjectInternal project, Configuration apiElements, String name, String platformKind) {
        Configuration runtimeElements = project.getConfigurations().createWithRole(name, ConfigurationRolesForMigration.CONSUMABLE_BUCKET_TO_CONSUMABLE);
        runtimeElements.extendsFrom(new Configuration[]{apiElements});
        this.declareConfigurationUsage(project.getObjects(), runtimeElements, "java-runtime");
        this.declareConfigurationCategory(project.getObjects(), runtimeElements, platformKind);
        return runtimeElements;
    }

    private Configuration createConsumableApi(ProjectInternal project, Configuration api, String name, String platformKind) {
        Configuration apiElements = project.getConfigurations().createWithRole(name, ConfigurationRolesForMigration.CONSUMABLE_BUCKET_TO_CONSUMABLE);
        apiElements.extendsFrom(new Configuration[]{api});
        this.declareConfigurationUsage(project.getObjects(), apiElements, "java-api");
        this.declareConfigurationCategory(project.getObjects(), apiElements, platformKind);
        return apiElements;
    }

    private void declareConfigurationCategory(ObjectFactory objectFactory, Configuration configuration, String value) {
        configuration.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objectFactory.named(Category.class, value)));
    }

    private void declareConfigurationUsage(ObjectFactory objectFactory, Configuration configuration, String usage, String libraryContents) {
        this.declareConfigurationUsage(objectFactory, configuration, usage);
        configuration.getAttributes().attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)objectFactory.named(LibraryElements.class, libraryContents)));
    }

    private void declareConfigurationUsage(ObjectFactory objectFactory, Configuration configuration, String usage) {
        configuration.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objectFactory.named(Usage.class, usage)));
    }

    private void configureExtension(Project project) {
        DefaultJavaPlatformExtension platformExtension = (DefaultJavaPlatformExtension)project.getExtensions().create(JavaPlatformExtension.class, "javaPlatform", DefaultJavaPlatformExtension.class, new Object[0]);
        project.afterEvaluate(project1 -> {
            if (!platformExtension.isAllowDependencies()) {
                this.checkNoDependencies((Project)project1);
            }
        });
    }

    private void checkNoDependencies(Project project) {
        this.checkNoDependencies(project.getConfigurations().getByName(RUNTIME_CONFIGURATION_NAME), Sets.newHashSet());
    }

    private void checkNoDependencies(Configuration configuration, Set<Configuration> visited) {
        if (visited.add(configuration)) {
            if (!configuration.getDependencies().isEmpty()) {
                throw new InvalidUserCodeException(String.format(DISALLOW_DEPENDENCIES, configuration.getName()));
            }
            Set extendsFrom = configuration.getExtendsFrom();
            for (Configuration parent : extendsFrom) {
                this.checkNoDependencies(parent, visited);
            }
        }
    }

    private void configurePublishing(Project project) {
        project.getPlugins().withType(PublishingPlugin.class, plugin -> {
            PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
            publishing.getPublications().withType(IvyPublication.class, publication -> {
                VersionMappingStrategyInternal strategy = ((IvyPublicationInternal)publication).getVersionMappingStrategy();
                strategy.defaultResolutionConfiguration("java-api", CLASSPATH_CONFIGURATION_NAME);
                strategy.defaultResolutionConfiguration("java-runtime", CLASSPATH_CONFIGURATION_NAME);
            });
            publishing.getPublications().withType(MavenPublication.class, publication -> {
                VersionMappingStrategyInternal strategy = ((MavenPublicationInternal)publication).getVersionMappingStrategy();
                strategy.defaultResolutionConfiguration("java-api", CLASSPATH_CONFIGURATION_NAME);
                strategy.defaultResolutionConfiguration("java-runtime", CLASSPATH_CONFIGURATION_NAME);
            });
        });
    }
}

