/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cryptopro;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class ECGOST3410ParamSetParameters
extends ASN1Encodable {
    DERInteger p;
    DERInteger q;
    DERInteger a;
    DERInteger b;
    DERInteger x;
    DERInteger y;

    public static ECGOST3410ParamSetParameters getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ECGOST3410ParamSetParameters.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static ECGOST3410ParamSetParameters getInstance(Object object) {
        if (object == null || object instanceof ECGOST3410ParamSetParameters) {
            return (ECGOST3410ParamSetParameters)object;
        }
        if (object instanceof ASN1Sequence) {
            return new ECGOST3410ParamSetParameters((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid GOST3410Parameter: " + object.getClass().getName());
    }

    public ECGOST3410ParamSetParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, int n, BigInteger bigInteger5) {
        this.a = new DERInteger(bigInteger);
        this.b = new DERInteger(bigInteger2);
        this.p = new DERInteger(bigInteger3);
        this.q = new DERInteger(bigInteger4);
        this.x = new DERInteger(n);
        this.y = new DERInteger(bigInteger5);
    }

    public ECGOST3410ParamSetParameters(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.a = (DERInteger)enumeration.nextElement();
        this.b = (DERInteger)enumeration.nextElement();
        this.p = (DERInteger)enumeration.nextElement();
        this.q = (DERInteger)enumeration.nextElement();
        this.x = (DERInteger)enumeration.nextElement();
        this.y = (DERInteger)enumeration.nextElement();
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.q.getPositiveValue();
    }

    public BigInteger getA() {
        return this.a.getPositiveValue();
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.p);
        aSN1EncodableVector.add(this.q);
        aSN1EncodableVector.add(this.x);
        aSN1EncodableVector.add(this.y);
        return new DERSequence(aSN1EncodableVector);
    }
}

