/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;

public class JavaTypeDeserializer
extends StdScalarDeserializer<JavaType> {
    private static final long serialVersionUID = 1L;
    public static final JavaTypeDeserializer instance = new JavaTypeDeserializer();

    public JavaTypeDeserializer() {
        super(JavaType.class);
    }

    @Override
    public JavaType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            String str = jp.getText().trim();
            if (str.length() == 0) {
                return (JavaType)this.getEmptyValue();
            }
            return ctxt.getTypeFactory().constructFromCanonical(str);
        }
        if (curr == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return (JavaType)jp.getEmbeddedObject();
        }
        throw ctxt.mappingException(this._valueClass);
    }
}

