/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.AccountAttribute;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.Options;

public class DescribeAccountAttributes
extends BaseCmd {
    private static final String ATTRIBUTE_NAME = "The account attribute.";

    public DescribeAccountAttributes(String[] args) {
        super("ec2daa", "ec2-describe-account-attributes");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        return o;
    }

    @Override
    protected String getOptionString() {
        return "[ATTRIBUTE_NAME]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Describes your AWS account.");
        System.out.println("     Attribute Names");
        System.out.println("                         supported-platforms    Indicates whether your account can launch instances into EC2-Classic and EC2-VPC, or only into EC2-VPC.");
        System.out.println("                                 default-vpc    The ID of the default VPC for your account, or none.");
        System.out.println("                               max-instances    The maximum number of On-Demand instances that you can run.");
        System.out.println("       vpc-max-security-groups-per-interface    The maximum number of security groups that you can assign to a network interface.");
        System.out.println("                             max-elastic-ips    The maximum number of Elastic IP addresses that you can allocate for use with EC2-Classic.");
        System.out.println("                         vpc-max-elastic-ips    The maximum number of Elastic IP addresses that you can allocate for use with EC2-VPC.");
    }

    @Override
    public void printOptions() {
        super.printOptions();
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] attributeNames = this.getNonOptions();
        RequestResultPair rsp = jec2.describeAccountAttributes(attributeNames);
        for (AccountAttribute attribute : (List)rsp.getResponse()) {
            out.output(System.out, attribute);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeAccountAttributes(args).invoke();
    }
}

