/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.test.dsig.TestUtils;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class SignaturePropertyTest
extends TestCase {
    private XMLSignatureFactory factory;
    private String target = "target";
    private String id = "id";

    public SignaturePropertyTest() {
        super("SignaturePropertyTest");
    }

    public SignaturePropertyTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.factory = XMLSignatureFactory.getInstance("DOM", new XMLDSigRI());
    }

    public void tearDown() {
    }

    public void testConstructor() {
        SignatureProperty signatureProperty;
        try {
            signatureProperty = this.factory.newSignatureProperty(null, this.target, this.id);
            SignaturePropertyTest.fail((String)"Should raise a NPE for null content");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            SignaturePropertyTest.fail((String)("Should raise a NPE for null content instead of " + exception));
        }
        Vector<Object> vector = new Vector<Object>();
        try {
            signatureProperty = this.factory.newSignatureProperty(vector, this.target, this.id);
            SignaturePropertyTest.fail((String)"Should raise an IAE for empty content");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            SignaturePropertyTest.fail((String)("Should raise an IAE for empty content instead of " + exception));
        }
        String string = "wrong type";
        vector.add(string);
        try {
            signatureProperty = this.factory.newSignatureProperty(vector, this.target, this.id);
            SignaturePropertyTest.fail((String)"Should raise a CCE for content containing invalid, i.e. non-XMLStructure, entries");
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            SignaturePropertyTest.fail((String)("Should raise a CCE for content with invalid entries instead of " + exception));
        }
        vector.remove(string);
        vector.add(new TestUtils.MyOwnXMLStructure());
        try {
            signatureProperty = this.factory.newSignatureProperty(vector, null, this.id);
            SignaturePropertyTest.fail((String)"Should raise a NPE for null target");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            SignaturePropertyTest.fail((String)("Should raise a NPE for null target instead of " + exception));
        }
        signatureProperty = this.factory.newSignatureProperty(vector, this.target, this.id);
        SignaturePropertyTest.assertNotNull((Object)signatureProperty);
        List<XMLStructure> list = signatureProperty.getContent();
        SignaturePropertyTest.assertNotNull(list);
        try {
            list.add(new TestUtils.MyOwnXMLStructure());
            SignaturePropertyTest.fail((String)"Should return an unmodifiable List object");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        SignaturePropertyTest.assertTrue((boolean)Arrays.equals(list.toArray(), vector.toArray()));
        SignaturePropertyTest.assertEquals((String)signatureProperty.getTarget(), (String)this.target);
        SignaturePropertyTest.assertEquals((String)signatureProperty.getId(), (String)this.id);
        SignaturePropertyTest.assertNotNull((Object)signatureProperty);
    }

    public void testisFeatureSupported() {
        Vector<TestUtils.MyOwnXMLStructure> vector = new Vector<TestUtils.MyOwnXMLStructure>();
        vector.add(new TestUtils.MyOwnXMLStructure());
        SignatureProperty signatureProperty = this.factory.newSignatureProperty(vector, this.target, this.id);
        try {
            signatureProperty.isFeatureSupported(null);
            SignaturePropertyTest.fail((String)"Should raise a NPE for null feature");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        SignaturePropertyTest.assertTrue((!signatureProperty.isFeatureSupported("not supported") ? 1 : 0) != 0);
    }
}

