/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client;

public class ProxySettings {
    private final String host;
    private final String port;
    private final String user;
    private final String password;
    private final String domain;
    private final String workstation;

    private ProxySettings(String endpoint) {
        String propertyPrefix = "http.";
        if (null != endpoint && endpoint.startsWith("https")) {
            propertyPrefix = "https.";
        }
        this.host = System.getProperty(propertyPrefix + "proxyHost");
        this.port = System.getProperty(propertyPrefix + "proxyPort");
        this.user = System.getProperty("http.proxyUser");
        this.password = System.getProperty("http.proxyPass");
        this.domain = System.getProperty("http.proxyDomain");
        this.workstation = System.getProperty("http.proxyWorkstation");
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public static ProxySettings getProxySettings(String endpoint) {
        return new ProxySettings(endpoint);
    }
}

