/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.blockdevicelib.vmdk;

import com.amazon.aes.webservices.client.blockdevicelib.DiskImage;
import com.amazon.aes.webservices.client.blockdevicelib.FileDiskImage;
import com.amazon.aes.webservices.client.blockdevicelib.ImageVerificationException;
import com.amazon.aes.webservices.client.blockdevicelib.vmdk.VMDKMetadataMarker;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class GrainIterator {
    private long[] grainDirectory;
    private FileDiskImage image;

    protected GrainIterator() {
    }

    public GrainIterator(FileDiskImage image, long gdOffset, int numberOfGDEntries) throws ImageVerificationException {
        this.image = image;
        ByteBuffer buffer = this.image.readLittleEndian(gdOffset, numberOfGDEntries * 4);
        this.grainDirectory = new long[numberOfGDEntries];
        for (int i = 0; i < numberOfGDEntries; ++i) {
            this.grainDirectory[i] = DiskImage.getUnsignedInt(buffer.getInt()) * 512L;
        }
    }

    public int fillInBytes(byte[] bytes, long offset) throws ImageVerificationException {
        long endOffset = offset + (long)bytes.length - 1L;
        int bytesFilled = 0;
        for (long grainDirectoryEntry : this.grainDirectory) {
            if (grainDirectoryEntry == 0L) continue;
            ByteBuffer buffer = this.image.readLittleEndian(grainDirectoryEntry, 2048);
            for (int j = 0; j < 512; ++j) {
                long gte = DiskImage.getUnsignedInt(buffer.getInt()) * 512L;
                if (gte == 0L) continue;
                ByteBuffer grainMarkerData = this.image.readLittleEndian(gte, 16);
                VMDKMetadataMarker grainMarker = new VMDKMetadataMarker(gte, grainMarkerData);
                long grainStartOffset = grainMarker.getLba() * 512L;
                if (DiskImage.rangesOverlap(offset, bytes.length, grainStartOffset, 65536)) {
                    bytesFilled += this.decompressAndFillInBytes(bytes, offset, endOffset, grainMarker, grainStartOffset);
                }
                if (bytesFilled < bytes.length) continue;
                return bytesFilled;
            }
        }
        return bytesFilled;
    }

    protected int decompressAndFillInBytes(byte[] bytes, long startOffset, long endOffset, VMDKMetadataMarker grainMarker, long grainStartOffset) throws ImageVerificationException {
        byte[] decompressedData = new byte[65536];
        int decompressedBytes = this.decompress(grainMarker, decompressedData);
        int copiedLength = DiskImage.copyBytes(decompressedData, grainStartOffset, decompressedBytes, bytes, startOffset);
        return copiedLength;
    }

    protected int decompress(VMDKMetadataMarker grainMarker, byte[] decompressedData) throws ImageVerificationException {
        long compressedDataOffset = grainMarker.getOffsetInVMDK() + 12L;
        byte[] compressedGrain = this.image.read(compressedDataOffset, grainMarker.getSize());
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedGrain);
        try {
            int bytesDecompressed = decompressor.inflate(decompressedData);
            return bytesDecompressed;
        }
        catch (DataFormatException e) {
            throw new ImageVerificationException("Failed to decompress grain at offset " + compressedDataOffset);
        }
    }
}

