/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.annotations;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.xfire.annotations.AnnotationException;
import org.codehaus.xfire.annotations.AnnotationsValidator;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.annotations.WebParamAnnotation;
import org.codehaus.xfire.annotations.WebServiceAnnotation;

public class AnnotationsValidatorImpl
implements AnnotationsValidator {
    private WebAnnotations annotations;

    protected void validateClass(Class clazz) throws AnnotationException {
        WebServiceAnnotation webAnn = this.annotations.getWebServiceAnnotation(clazz);
        if (webAnn.getPortName() != null && webAnn.getPortName().length() > 0 && clazz.isInterface()) {
            this.throwException("Port name can't be defined on interface", "4.1.1", "Class : " + clazz.getName());
        }
        if (webAnn.getEndpointInterface() != null && webAnn.getEndpointInterface().length() > 0 && clazz.isInterface()) {
            this.throwException("EndpointInterface can't be defined on interface", "4.1.1", " Class : " + clazz.getName());
        }
        Method[] methods = clazz.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            Method method = methods[m];
            if (!this.annotations.hasWebMethodAnnotation(method)) continue;
            this.validateMethod(method);
        }
    }

    protected void validateOneWay(Method method) throws AnnotationException {
        if (method.getExceptionTypes().length > 0 || !method.getGenericReturnType().equals(Void.TYPE)) {
            this.throwException("Method annotated with @OneWay annotation cannot  have return value or declarated exceptions", "4.3.1", "Method : " + method.getName());
        }
        for (int p = 0; p < method.getParameterTypes().length; ++p) {
            WebParamAnnotation param = this.annotations.getWebParamAnnotation(method, p);
            if (param == null || param.getMode() != 1 && param.getMode() != 2) continue;
            this.throwException("Method annotated with @OneWay annotation cannot have INOUT/OUT parameters", "4.3.1", "Method : " + method.getName());
        }
    }

    protected void validateMethod(Method method) throws AnnotationException {
        if (!Modifier.isPublic(method.getModifiers())) {
            this.throwException("Method annotated with @WebMethod must be public", "3.3", "Method : " + method.getName());
        }
        if (this.annotations.hasOnewayAnnotation(method)) {
            this.validateOneWay(method);
        }
    }

    public void validate(WebAnnotations annotations, Class clazz) throws AnnotationException {
        this.annotations = annotations;
        this.validateClass(clazz);
    }

    private void throwException(String message, String spec, String details) throws AnnotationException {
        throw new AnnotationException(message + ". JSR181 spec : " + spec + ". " + details);
    }
}

