/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.java.JDK14RegexTranslator;
import net.sf.saxon.java.JDK15RegexTranslator;
import net.sf.saxon.java.JRegexIterator;
import net.sf.saxon.java.JTokenIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegexSyntaxException;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.XPathException;

public class JRegularExpression
implements RegularExpression {
    Pattern pattern;
    String javaRegex;
    int flagBits;

    public JRegularExpression(String javaRegex, int flagBits) {
        this.flagBits = flagBits;
        this.javaRegex = javaRegex;
        String j = System.getProperty("java.version");
        this.pattern = j.startsWith("1.4") ? Pattern.compile(javaRegex, flagBits & 0xFFFFFFFB) : Pattern.compile(javaRegex, flagBits & 0xFFFFFFF9);
    }

    public JRegularExpression(CharSequence regex, int xmlVersion, int syntax, int flagBits) throws XPathException {
        this.flagBits = flagBits;
        try {
            String j = System.getProperty("java.version");
            if (syntax == 2) {
                this.javaRegex = ((Object)regex).toString();
                this.pattern = Pattern.compile(this.javaRegex, flagBits);
            } else if (j.startsWith("1.4")) {
                JDK14RegexTranslator translator = new JDK14RegexTranslator();
                translator.setIgnoreWhitespace((flagBits & 4) != 0);
                this.javaRegex = translator.translate(regex, xmlVersion, syntax == 0);
                this.pattern = Pattern.compile(this.javaRegex, flagBits & 0xFFFFFFFB);
            } else {
                boolean ignoreWhitespace = (flagBits & 4) != 0;
                boolean caseBlind = (flagBits & 2) != 0;
                this.javaRegex = JDK15RegexTranslator.translate(regex, xmlVersion, syntax == 0, ignoreWhitespace, caseBlind);
                this.pattern = Pattern.compile(this.javaRegex, flagBits & 0xFFFFFFF9);
            }
        }
        catch (RegexSyntaxException e) {
            XPathException err = new XPathException(e.getMessage());
            err.setErrorCode("FORX0002");
            throw err;
        }
    }

    public String getJavaRegularExpression() {
        return this.javaRegex;
    }

    public int getFlagBits() {
        return this.flagBits;
    }

    public RegexIterator analyze(CharSequence input) {
        return new JRegexIterator(((Object)input).toString(), this.pattern);
    }

    public boolean containsMatch(CharSequence input) {
        return this.pattern.matcher(input).find();
    }

    public boolean matches(CharSequence input) {
        return this.pattern.matcher(input).matches();
    }

    public CharSequence replace(CharSequence input, CharSequence replacement) throws XPathException {
        Matcher matcher = this.pattern.matcher(input);
        try {
            return matcher.replaceAll(((Object)replacement).toString());
        }
        catch (IndexOutOfBoundsException e) {
            int gps = matcher.groupCount();
            if (gps >= 9) {
                throw e;
            }
            String r = ((Object)replacement).toString();
            String f = "\\$[" + (gps + 1) + "-9]";
            String rep = Pattern.compile(f).matcher(r).replaceAll("");
            return matcher.replaceAll(rep);
        }
    }

    public SequenceIterator tokenize(CharSequence input) {
        if (input.length() == 0) {
            return EmptyIterator.getInstance();
        }
        return new JTokenIterator(input, this.pattern);
    }

    public static int setFlags(CharSequence inFlags) throws XPathException {
        int flags = 1;
        block6: for (int i = 0; i < inFlags.length(); ++i) {
            char c = inFlags.charAt(i);
            switch (c) {
                case 'm': {
                    flags |= 8;
                    continue block6;
                }
                case 'i': {
                    flags |= 2;
                    flags |= 0x40;
                    continue block6;
                }
                case 's': {
                    flags |= 0x20;
                    continue block6;
                }
                case 'x': {
                    flags |= 4;
                    continue block6;
                }
                default: {
                    XPathException err = new XPathException("Invalid character '" + c + "' in regular expression flags");
                    err.setErrorCode("FORX0001");
                    throw err;
                }
            }
        }
        return flags;
    }
}

