/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSwapchainImageOpenGLESKHR;
import org.lwjgl.openxr.XrSwapchainImageOpenGLKHR;
import org.lwjgl.openxr.XrSwapchainImageVulkanKHR;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSwapchainImageBaseHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrSwapchainImageBaseHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSwapchainImageBaseHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSwapchainImageBaseHeader.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSwapchainImageBaseHeader.nnext(this.address());
    }

    public XrSwapchainImageBaseHeader type(@NativeType(value="XrStructureType") int value) {
        XrSwapchainImageBaseHeader.ntype(this.address(), value);
        return this;
    }

    public XrSwapchainImageBaseHeader next(@NativeType(value="void *") long value) {
        XrSwapchainImageBaseHeader.nnext(this.address(), value);
        return this;
    }

    public XrSwapchainImageBaseHeader set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSwapchainImageBaseHeader set(XrSwapchainImageBaseHeader src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSwapchainImageBaseHeader malloc() {
        return (XrSwapchainImageBaseHeader)XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSwapchainImageBaseHeader calloc() {
        return (XrSwapchainImageBaseHeader)XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSwapchainImageBaseHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSwapchainImageBaseHeader)XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSwapchainImageBaseHeader create(long address) {
        return (XrSwapchainImageBaseHeader)XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, (long)address);
    }

    @Nullable
    public static XrSwapchainImageBaseHeader createSafe(long address) {
        return address == 0L ? null : (XrSwapchainImageBaseHeader)XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, (long)address);
    }

    public static XrSwapchainImageBaseHeader create(XrSwapchainImageOpenGLKHR value) {
        return (XrSwapchainImageBaseHeader)XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, (Struct)value);
    }

    public static XrSwapchainImageBaseHeader create(XrSwapchainImageOpenGLESKHR value) {
        return (XrSwapchainImageBaseHeader)XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, (Struct)value);
    }

    public static XrSwapchainImageBaseHeader create(XrSwapchainImageVulkanKHR value) {
        return (XrSwapchainImageBaseHeader)XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, (Struct)value);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSwapchainImageBaseHeader.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSwapchainImageBaseHeader.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSwapchainImageBaseHeader.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSwapchainImageBaseHeader.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSwapchainImageBaseHeader.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSwapchainImageBaseHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSwapchainImageBaseHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static Buffer create(XrSwapchainImageOpenGLKHR.Buffer value) {
        return (Buffer)XrSwapchainImageBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrSwapchainImageOpenGLESKHR.Buffer value) {
        return (Buffer)XrSwapchainImageBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static Buffer create(XrSwapchainImageVulkanKHR.Buffer value) {
        return (Buffer)XrSwapchainImageBaseHeader.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static XrSwapchainImageBaseHeader malloc(MemoryStack stack) {
        return (XrSwapchainImageBaseHeader)XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSwapchainImageBaseHeader calloc(MemoryStack stack) {
        return (XrSwapchainImageBaseHeader)XrSwapchainImageBaseHeader.wrap(XrSwapchainImageBaseHeader.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSwapchainImageBaseHeader.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSwapchainImageBaseHeader.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrSwapchainImageBaseHeader.__struct((Struct.Member[])new Struct.Member[]{XrSwapchainImageBaseHeader.__member((int)4), XrSwapchainImageBaseHeader.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSwapchainImageBaseHeader, Buffer>
    implements NativeResource {
        private static final XrSwapchainImageBaseHeader ELEMENT_FACTORY = XrSwapchainImageBaseHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSwapchainImageBaseHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSwapchainImageBaseHeader.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSwapchainImageBaseHeader.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSwapchainImageBaseHeader.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSwapchainImageBaseHeader.nnext(this.address(), value);
            return this;
        }
    }
}

