/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.CXCursor;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxContainerInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CURSOR;

    public CXIdxContainerInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXIdxContainerInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public CXCursor cursor() {
        return CXIdxContainerInfo.ncursor(this.address());
    }

    public static CXIdxContainerInfo malloc() {
        return (CXIdxContainerInfo)CXIdxContainerInfo.wrap(CXIdxContainerInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXIdxContainerInfo calloc() {
        return (CXIdxContainerInfo)CXIdxContainerInfo.wrap(CXIdxContainerInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXIdxContainerInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXIdxContainerInfo)CXIdxContainerInfo.wrap(CXIdxContainerInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXIdxContainerInfo create(long address) {
        return (CXIdxContainerInfo)CXIdxContainerInfo.wrap(CXIdxContainerInfo.class, (long)address);
    }

    @Nullable
    public static CXIdxContainerInfo createSafe(long address) {
        return address == 0L ? null : (CXIdxContainerInfo)CXIdxContainerInfo.wrap(CXIdxContainerInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXIdxContainerInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXIdxContainerInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXIdxContainerInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXIdxContainerInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXIdxContainerInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXIdxContainerInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXIdxContainerInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static CXIdxContainerInfo mallocStack() {
        return CXIdxContainerInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXIdxContainerInfo callocStack() {
        return CXIdxContainerInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXIdxContainerInfo mallocStack(MemoryStack stack) {
        return CXIdxContainerInfo.malloc(stack);
    }

    @Deprecated
    public static CXIdxContainerInfo callocStack(MemoryStack stack) {
        return CXIdxContainerInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXIdxContainerInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXIdxContainerInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXIdxContainerInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXIdxContainerInfo.calloc(capacity, stack);
    }

    public static CXIdxContainerInfo malloc(MemoryStack stack) {
        return (CXIdxContainerInfo)CXIdxContainerInfo.wrap(CXIdxContainerInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXIdxContainerInfo calloc(MemoryStack stack) {
        return (CXIdxContainerInfo)CXIdxContainerInfo.wrap(CXIdxContainerInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CXIdxContainerInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CXIdxContainerInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static CXCursor ncursor(long struct) {
        return CXCursor.create(struct + (long)CURSOR);
    }

    static {
        Struct.Layout layout = CXIdxContainerInfo.__struct((Struct.Member[])new Struct.Member[]{CXIdxContainerInfo.__member((int)CXCursor.SIZEOF, (int)CXCursor.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CURSOR = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<CXIdxContainerInfo, Buffer>
    implements NativeResource {
        private static final CXIdxContainerInfo ELEMENT_FACTORY = CXIdxContainerInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXIdxContainerInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public CXCursor cursor() {
            return CXIdxContainerInfo.ncursor(this.address());
        }
    }
}

