/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.util.ArrayCache;
import org.jitsi.nlj.util.BufferPool;
import org.jitsi.nlj.util.Rfc3711IndexTracker;
import org.jitsi.rtp.rtp.RtpPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0006\u0010\u0013\u001a\u00020\u0011J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u001a\u0010\u0015\u001a\u000e\u0018\u00010\u0016R\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0004J\"\u0010\u0018\u001a\u000e\u0018\u00010\u0016R\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0006J\u001a\u0010\u001a\u001a\u000e\u0018\u00010\u0016R\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0002J\u0016\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\nJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\"2\u0006\u0010#\u001a\u00020\u0004R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jitsi/nlj/util/RtpPacketCache;", "Lorg/jitsi/nlj/util/ArrayCache;", "Lorg/jitsi/rtp/rtp/RtpPacket;", "size", "", "synchronize", "", "<init>", "(IZ)V", "value", "", "lastAccessMillis", "getLastAccessMillis", "()J", "rfc3711IndexTracker", "Lorg/jitsi/nlj/util/Rfc3711IndexTracker;", "discardItem", "", "item", "setLastAccess", "doSetLastAccess", "get", "Lorg/jitsi/nlj/util/ArrayCache$Container;", "sequenceNumber", "doGet", "shouldCloneItem", "peek", "contains", "insert", "rtpPacket", "updateTimestamp", "seqNum", "timeAdded", "getMany", "", "numBytes", "jitsi-media-transform"})
public final class RtpPacketCache
extends ArrayCache<RtpPacket> {
    private long lastAccessMillis;
    @NotNull
    private final Rfc3711IndexTracker rfc3711IndexTracker;

    public RtpPacketCache(int size, boolean synchronize) {
        super(size, 1.INSTANCE, synchronize, null, 8, null);
        this.rfc3711IndexTracker = new Rfc3711IndexTracker();
    }

    public /* synthetic */ RtpPacketCache(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        this(n, bl);
    }

    public final long getLastAccessMillis() {
        return this.lastAccessMillis;
    }

    @Override
    protected void discardItem(@NotNull RtpPacket item) {
        Intrinsics.checkNotNullParameter(item, "item");
        Function1<byte[], Unit> function1 = BufferPool.Companion.getReturnBuffer();
        Intrinsics.checkNotNullExpressionValue(item.buffer, "buffer");
        function1.invoke(item.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLastAccess() {
        if (this.getSynchronize()) {
            Object object = this.getSyncRoot();
            synchronized (object) {
                boolean bl = false;
                this.doSetLastAccess();
                Unit unit = Unit.INSTANCE;
            }
        } else {
            this.doSetLastAccess();
        }
    }

    private final void doSetLastAccess() {
        long t2 = this.getClock().millis();
        if (this.lastAccessMillis < t2) {
            this.lastAccessMillis = t2;
        }
    }

    @Nullable
    public final ArrayCache.Container get(int sequenceNumber) {
        return this.doGet(sequenceNumber, true);
    }

    @Nullable
    public final ArrayCache.Container doGet(int sequenceNumber, boolean shouldCloneItem) {
        int index = this.rfc3711IndexTracker.interpret(sequenceNumber);
        return index < 0 ? null : super.getContainer(index, shouldCloneItem);
    }

    @Nullable
    public final ArrayCache.Container peek(int sequenceNumber) {
        return this.doGet(sequenceNumber, false);
    }

    public final boolean contains(int sequenceNumber) {
        int index = this.rfc3711IndexTracker.interpret(sequenceNumber);
        return super.containsIndex(index);
    }

    public final boolean insert(@NotNull RtpPacket rtpPacket) {
        Intrinsics.checkNotNullParameter(rtpPacket, "rtpPacket");
        int index = this.rfc3711IndexTracker.update(rtpPacket.getSequenceNumber());
        return super.insertItem(rtpPacket, index);
    }

    public final void updateTimestamp(int seqNum, long timeAdded) {
        int index = this.rfc3711IndexTracker.interpret(seqNum);
        super.updateTimeAdded(index, timeAdded);
    }

    @NotNull
    public final Set<RtpPacket> getMany(int numBytes) {
        Ref.IntRef bytesRemaining = new Ref.IntRef();
        bytesRemaining.element = numBytes;
        Set packets = new LinkedHashSet();
        this.forEachDescending(arg_0 -> RtpPacketCache.getMany$lambda$1(bytesRemaining, packets, arg_0));
        return packets;
    }

    private static final boolean getMany$lambda$1(Ref.IntRef $bytesRemaining, Set $packets, RtpPacket it) {
        boolean bl;
        Intrinsics.checkNotNullParameter($bytesRemaining, "$bytesRemaining");
        Intrinsics.checkNotNullParameter($packets, "$packets");
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.length <= $bytesRemaining.element) {
            $packets.add(it.clone());
            $bytesRemaining.element -= it.length;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }
}

