/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.TextAreaCreationTool;
import org.jhotdraw.draw.TextCreationTool;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.action.BringToFrontAction;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.SendToBackAction;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.samples.svg.PathTool;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.SVGCreateFromFileTool;
import org.jhotdraw.samples.svg.action.CombineAction;
import org.jhotdraw.samples.svg.action.SplitAction;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGEllipseFigure;
import org.jhotdraw.samples.svg.figures.SVGGroupFigure;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;
import org.jhotdraw.samples.svg.figures.SVGRectFigure;
import org.jhotdraw.samples.svg.figures.SVGTextAreaFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.util.ResourceBundleUtil;

public class ToolsToolBar
extends AbstractToolBar {
    public ToolsToolBar() {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(resourceBundleUtil.getString("tools.toolbar"));
    }

    @Override
    protected JComponent createDisclosedComponent(int n) {
        JPanel jPanel = null;
        switch (n) {
            case 1: {
                jPanel = new JPanel();
                jPanel.setOpaque(false);
                jPanel.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout gridBagLayout = new GridBagLayout();
                jPanel.setLayout(gridBagLayout);
                JToggleButton jToggleButton = ButtonFactory.addSelectionToolTo(this, this.editor, ButtonFactory.createDrawingActions(this.editor, this.disposables), this.createSelectionActions(this.editor));
                jToggleButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jToggleButton));
                jToggleButton.addMouseListener(new SelectionToolButtonHandler(this.editor));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                jPanel.add((Component)jToggleButton, gridBagConstraints);
                resourceBundleUtil.configureToolBarButton(jToggleButton, "selectionTool");
                HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
                CreationTool creationTool = new CreationTool(new SVGRectFigure(), hashMap);
                jToggleButton = ButtonFactory.addToolTo(this, this.editor, creationTool, "createRectangle", resourceBundleUtil);
                creationTool.setToolDoneAfterCreation(false);
                jToggleButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jToggleButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel.add((Component)jToggleButton, gridBagConstraints);
                creationTool = new CreationTool(new SVGEllipseFigure(), hashMap);
                jToggleButton = ButtonFactory.addToolTo(this, this.editor, creationTool, "createEllipse", resourceBundleUtil);
                creationTool.setToolDoneAfterCreation(false);
                jToggleButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jToggleButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(3, 3, 0, 0);
                jPanel.add((Component)jToggleButton, gridBagConstraints);
                PathTool pathTool = new PathTool(new SVGPathFigure(), new SVGBezierFigure(true), hashMap);
                jToggleButton = ButtonFactory.addToolTo(this, this.editor, pathTool, "createPolygon", resourceBundleUtil);
                pathTool.setToolDoneAfterCreation(false);
                jToggleButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jToggleButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(3, 3, 0, 0);
                jPanel.add((Component)jToggleButton, gridBagConstraints);
                hashMap = new HashMap();
                hashMap.put(AttributeKeys.FILL_COLOR, null);
                hashMap.put(SVGAttributeKeys.PATH_CLOSED, false);
                creationTool = new CreationTool(new SVGPathFigure(), hashMap);
                jToggleButton = ButtonFactory.addToolTo(this, this.editor, creationTool, "createLine", resourceBundleUtil);
                creationTool.setToolDoneAfterCreation(false);
                jToggleButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jToggleButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(0, 3, 0, 0);
                jPanel.add((Component)jToggleButton, gridBagConstraints);
                pathTool = new PathTool(new SVGPathFigure(), new SVGBezierFigure(false), hashMap);
                jToggleButton = ButtonFactory.addToolTo(this, this.editor, pathTool, "createScribble", resourceBundleUtil);
                pathTool.setToolDoneAfterCreation(false);
                jToggleButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jToggleButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new Insets(0, 3, 0, 0);
                jPanel.add((Component)jToggleButton, gridBagConstraints);
                hashMap = new HashMap();
                hashMap.put(AttributeKeys.FILL_COLOR, Color.black);
                hashMap.put(AttributeKeys.STROKE_COLOR, null);
                TextCreationTool textCreationTool = new TextCreationTool(new SVGTextFigure(), hashMap);
                jToggleButton = ButtonFactory.addToolTo(this, this.editor, textCreationTool, "createText", resourceBundleUtil);
                textCreationTool.setToolDoneAfterCreation(true);
                jToggleButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jToggleButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 0, 0, 0);
                jPanel.add((Component)jToggleButton, gridBagConstraints);
                TextAreaCreationTool textAreaCreationTool = new TextAreaCreationTool(new SVGTextAreaFigure(), hashMap);
                textAreaCreationTool.setRubberbandColor(Color.BLACK);
                textAreaCreationTool.setToolDoneAfterCreation(true);
                jToggleButton = ButtonFactory.addToolTo(this, this.editor, textAreaCreationTool, "createTextArea", resourceBundleUtil);
                jToggleButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jToggleButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 3, 0, 0);
                jPanel.add((Component)jToggleButton, gridBagConstraints);
                hashMap = new HashMap();
                hashMap.put(AttributeKeys.FILL_COLOR, null);
                hashMap.put(AttributeKeys.STROKE_COLOR, null);
                SVGCreateFromFileTool sVGCreateFromFileTool = new SVGCreateFromFileTool(new SVGImageFigure(), new SVGGroupFigure(), hashMap);
                jToggleButton = ButtonFactory.addToolTo(this, this.editor, sVGCreateFromFileTool, "createImage", resourceBundleUtil);
                sVGCreateFromFileTool.setToolDoneAfterCreation(true);
                sVGCreateFromFileTool.setUseFileDialog(true);
                jToggleButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jToggleButton));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.insets = new Insets(3, 3, 0, 0);
                jPanel.add((Component)jToggleButton, gridBagConstraints);
            }
        }
        return jPanel;
    }

    public Collection<Action> createSelectionActions(DrawingEditor drawingEditor) {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        linkedList.add(new DuplicateAction());
        linkedList.add(null);
        AbstractSelectedAction abstractSelectedAction = new GroupAction(drawingEditor, new SVGGroupFigure());
        linkedList.add(abstractSelectedAction);
        this.disposables.add(abstractSelectedAction);
        abstractSelectedAction = new UngroupAction(drawingEditor, new SVGGroupFigure());
        linkedList.add(abstractSelectedAction);
        this.disposables.add(abstractSelectedAction);
        abstractSelectedAction = new CombineAction(drawingEditor);
        linkedList.add(abstractSelectedAction);
        this.disposables.add(abstractSelectedAction);
        abstractSelectedAction = new SplitAction(drawingEditor);
        linkedList.add(abstractSelectedAction);
        this.disposables.add(abstractSelectedAction);
        linkedList.add(null);
        abstractSelectedAction = new BringToFrontAction(drawingEditor);
        linkedList.add(abstractSelectedAction);
        this.disposables.add(abstractSelectedAction);
        abstractSelectedAction = new SendToBackAction(drawingEditor);
        linkedList.add(abstractSelectedAction);
        this.disposables.add(abstractSelectedAction);
        return linkedList;
    }

    @Override
    protected String getID() {
        return "tools";
    }

    @Override
    protected int getDefaultDisclosureState() {
        return 1;
    }

    private void initComponents() {
        this.setOpaque(false);
    }

    private static class SelectionToolButtonHandler
    extends MouseAdapter {
        private DrawingEditor editor;
        private boolean wasSelectedOnPressed = false;

        public SelectionToolButtonHandler(DrawingEditor drawingEditor) {
            this.editor = drawingEditor;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            DrawingView drawingView;
            if (this.wasSelectedOnPressed && (drawingView = this.editor.getActiveView()) != null) {
                drawingView.setHandleDetailLevel(drawingView.getHandleDetailLevel() + 1);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.wasSelectedOnPressed = ((AbstractButton)mouseEvent.getSource()).isSelected();
        }
    }
}

