/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class OddFunction
implements Function {
    private static final long serialVersionUID = -7438242687193650125L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type1 = parameters.getType(0);
        Object value1 = parameters.getValue(0);
        Number result = context.getTypeRegistry().convertToNumber(type1, value1);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, OddFunction.compute(result));
    }

    private static BigDecimal compute(Number result) {
        double v = result.doubleValue();
        int intValue = v < 0.0 ? (int)Math.floor(v) : (int)Math.ceil(v);
        BigDecimal ret = intValue == 0 ? (v < 0.0 ? new BigDecimal(-1) : new BigDecimal(1)) : (intValue % 2 != 0 ? new BigDecimal(intValue) : (v < 0.0 ? new BigDecimal(intValue - 1) : new BigDecimal(intValue + 1)));
        return ret;
    }

    @Override
    public String getCanonicalName() {
        return "ODD";
    }
}

