/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.collection;

import com.google.firebase.database.collection.LLRBEmptyNode;
import com.google.firebase.database.collection.LLRBNode;
import com.google.firebase.database.collection.LLRBValueNode;

public class LLRBRedValueNode<K, V>
extends LLRBValueNode<K, V> {
    LLRBRedValueNode(K key, V value) {
        super(key, value, LLRBEmptyNode.getInstance(), LLRBEmptyNode.getInstance());
    }

    LLRBRedValueNode(K key, V value, LLRBNode<K, V> left, LLRBNode<K, V> right) {
        super(key, value, left, right);
    }

    @Override
    protected LLRBNode.Color getColor() {
        return LLRBNode.Color.RED;
    }

    @Override
    public boolean isRed() {
        return true;
    }

    @Override
    protected LLRBValueNode<K, V> copy(K key, V value, LLRBNode<K, V> left, LLRBNode<K, V> right) {
        K newKey = key == null ? this.getKey() : key;
        V newValue = value == null ? this.getValue() : value;
        LLRBNode<K, V> newLeft = left == null ? this.getLeft() : left;
        LLRBNode<K, V> newRight = right == null ? this.getRight() : right;
        return new LLRBRedValueNode<K, V>(newKey, newValue, newLeft, newRight);
    }
}

