/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import java.util.Arrays;
import java.util.LinkedHashMap;
import org.ops4j.pax.web.extender.whiteboard.internal.WhiteboardExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractContextTracker;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;

public class ServletContextHelperTracker
extends AbstractContextTracker<ServletContextHelper> {
    private ServletContextHelperTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        super(whiteboardExtenderContext, bundleContext);
    }

    public static ServiceTracker<ServletContextHelper, OsgiContextModel> createTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        return new ServletContextHelperTracker(whiteboardExtenderContext, bundleContext).create(ServletContextHelper.class);
    }

    @Override
    protected void configureContextModel(ServiceReference<ServletContextHelper> serviceReference, OsgiContextModel model) {
        model.setShared(Boolean.valueOf(true));
        String name = (String)Utils.getPaxWebProperty(serviceReference, (String)"httpContext.id", (String)"osgi.http.whiteboard.context.name", Utils::asString);
        if (name == null || "".equals(name.trim())) {
            name = "default";
        }
        model.setName(name);
        String contextPath = (String)Utils.getPaxWebProperty(serviceReference, (String)"httpContext.path", (String)"osgi.http.whiteboard.context.path", Utils::asString);
        if (contextPath == null || "".equals(contextPath.trim())) {
            contextPath = "/";
        }
        model.setContextPath(contextPath);
        LinkedHashMap<String, String> initParams = new LinkedHashMap<String, String>();
        for (String key : serviceReference.getPropertyKeys()) {
            String value;
            if (!key.startsWith("context.init.") || (value = Utils.getStringProperty(serviceReference, (String)key)) == null) continue;
            initParams.put(key.substring("context.init.".length()), value);
        }
        model.getContextParams().clear();
        model.getContextParams().putAll(initParams);
        model.getContextRegistrationProperties().putAll(Utils.toMap(serviceReference));
        model.getContextRegistrationProperties().put("osgi.http.whiteboard.context.name", name);
        model.getContextRegistrationProperties().put("osgi.http.whiteboard.context.path", contextPath);
        String[] virtualHosts = (String[])Utils.getPaxWebProperty(serviceReference, (String)"httpContext.virtualhosts", (String)"org.ops4j.pax.web.http.whiteboard.virtualhosts", (n, v) -> Utils.asStringArray((String)n, (Object)v, (boolean)true));
        String[] connectors = (String[])Utils.getPaxWebProperty(serviceReference, (String)"httpContext.connectors", (String)"org.ops4j.pax.web.http.whiteboard.connectors", (n, v) -> Utils.asStringArray((String)n, (Object)v, (boolean)true));
        model.getVirtualHosts().clear();
        model.getConnectors().clear();
        if (virtualHosts != null) {
            model.getVirtualHosts().addAll(Arrays.asList(virtualHosts));
        }
        if (connectors != null) {
            model.getConnectors().addAll(Arrays.asList(connectors));
        }
        model.setContextReference(serviceReference);
    }
}

