/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.util.HashMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.ma.json.ParseJsonFn;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class JSONResource
implements Resource {
    private final String href;
    private String jsonStr;
    private Item item;
    private final XPathContext context;
    private AbstractResourceCollection.InputDetails details;
    public static final ResourceFactory FACTORY = (context, details) -> new JSONResource(context, details);

    public JSONResource(XPathContext context, AbstractResourceCollection.InputDetails details) {
        this.href = details.resourceUri;
        this.context = context;
        if (details.encoding == null) {
            details.encoding = "UTF-8";
        }
        this.details = details;
    }

    @Override
    public String getResourceURI() {
        return this.href;
    }

    @Override
    public Item getItem() throws XPathException {
        if (this.item != null) {
            return this.item;
        }
        if (this.jsonStr == null) {
            this.jsonStr = this.details.obtainCharacterContent();
            if (this.jsonStr == null) {
                return null;
            }
        }
        HashMap<String, Sequence> options = new HashMap<String, Sequence>();
        options.put("liberal", BooleanValue.FALSE);
        options.put("duplicates", StringValue.bmp("use-first"));
        options.put("escape", BooleanValue.FALSE);
        this.item = ParseJsonFn.parse(this.jsonStr, options, this.context);
        return this.item;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }
}

