/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.events;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.events.SessionClusterEvent;

public class SessionEventsSenderTransaction
extends AbstractKeycloakTransaction {
    private final KeycloakSession session;
    private final List<DCEventContext> sessionEvents = new LinkedList<DCEventContext>();

    public SessionEventsSenderTransaction(KeycloakSession session) {
        this.session = session;
    }

    public void addEvent(SessionClusterEvent event, ClusterProvider.DCNotify dcNotify) {
        this.sessionEvents.add(new DCEventContext(dcNotify, event));
    }

    protected void commitImpl() {
        ClusterProvider cluster = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        for (DCEventContext entry : this.sessionEvents) {
            cluster.notify(entry.event.getEventKey(), (ClusterEvent)entry.event, false, entry.dcNotify);
        }
    }

    protected void rollbackImpl() {
    }

    private static class DCEventContext {
        private final ClusterProvider.DCNotify dcNotify;
        private final SessionClusterEvent event;

        DCEventContext(ClusterProvider.DCNotify dcNotify, SessionClusterEvent event) {
            this.dcNotify = dcNotify;
            this.event = event;
        }
    }
}

