/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.paths.FilteredPathTree;
import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathVisitor;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.DefaultRouteBuildItem;
import io.quarkus.vertx.http.deployment.spi.AdditionalStaticResourceBuildItem;
import io.quarkus.vertx.http.deployment.spi.StaticResourcesBuildItem;
import io.quarkus.vertx.http.runtime.StaticResourcesRecorder;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class StaticResourcesProcessor {
    @BuildStep
    void collectStaticResources(Capabilities capabilities, List<AdditionalStaticResourceBuildItem> additionalStaticResources, BuildProducer<StaticResourcesBuildItem> staticResources) {
        if (capabilities.isPresent("io.quarkus.servlet")) {
            return;
        }
        Set<StaticResourcesBuildItem.Entry> paths = this.getClasspathResources();
        for (AdditionalStaticResourceBuildItem bi : additionalStaticResources) {
            paths.add(new StaticResourcesBuildItem.Entry(bi.getPath(), bi.isDirectory()));
        }
        if (!paths.isEmpty()) {
            staticResources.produce((BuildItem)new StaticResourcesBuildItem(paths));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void runtimeInit(Optional<StaticResourcesBuildItem> staticResources, StaticResourcesRecorder recorder, CoreVertxBuildItem vertx, BeanContainerBuildItem beanContainer, BuildProducer<DefaultRouteBuildItem> defaultRoutes) {
        if (staticResources.isPresent()) {
            defaultRoutes.produce((BuildItem)new DefaultRouteBuildItem(recorder.start(staticResources.get().getPaths())));
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void nativeImageResource(Optional<StaticResourcesBuildItem> staticResources, BuildProducer<NativeImageResourceBuildItem> producer) {
        if (staticResources.isPresent()) {
            Set entries = staticResources.get().getEntries();
            ArrayList<CallSite> metaInfResources = new ArrayList<CallSite>(entries.size());
            for (StaticResourcesBuildItem.Entry entry : entries) {
                if (entry.isDirectory()) continue;
                String metaInfResourcesPath = "META-INF/resources" + entry.getPath();
                metaInfResources.add((CallSite)((Object)metaInfResourcesPath));
            }
            producer.produce((BuildItem)new NativeImageResourceBuildItem(metaInfResources));
            HashSet collectedDirs = new HashSet();
            StaticResourcesProcessor.visitRuntimeMetaInfResources(visit -> {
                String relativePath;
                if (Files.isDirectory(visit.getPath(), new LinkOption[0]) && collectedDirs.add(relativePath = visit.getRelativePath("/"))) {
                    producer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{relativePath}));
                }
            });
        }
    }

    private Set<StaticResourcesBuildItem.Entry> getClasspathResources() {
        HashSet<StaticResourcesBuildItem.Entry> knownPaths = new HashSet<StaticResourcesBuildItem.Entry>();
        StaticResourcesProcessor.visitRuntimeMetaInfResources(visit -> {
            if (!Files.isDirectory(visit.getPath(), new LinkOption[0])) {
                knownPaths.add(new StaticResourcesBuildItem.Entry(visit.getRelativePath("/").substring("META-INF/resources".length()), false));
            }
        });
        return knownPaths;
    }

    private static void visitRuntimeMetaInfResources(PathVisitor visitor) {
        List elements = QuarkusClassLoader.getElements((String)"META-INF/resources", (boolean)false);
        if (!elements.isEmpty()) {
            PathFilter filter = PathFilter.forIncludes(List.of("META-INF/resources/**", "META-INF/resources"));
            for (ClassPathElement element : elements) {
                if (!element.isRuntime()) continue;
                element.apply(tree -> {
                    new FilteredPathTree((PathTree)tree, filter).walk(visitor);
                    return null;
                });
            }
        }
    }
}

