/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javolution.context.ObjectFactory;
import javolution.lang.Reusable;
import javolution.xml.XMLBinding;
import javolution.xml.XMLFormat;
import javolution.xml.XMLReferenceResolver;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLObjectWriter
implements Reusable {
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        protected Object create() {
            return new XMLObjectWriter();
        }

        protected void cleanup(Object object) {
            ((XMLObjectWriter)object).reset();
        }
    };
    private final XMLFormat.OutputElement _xml = new XMLFormat.OutputElement();
    private Writer _writer;
    private OutputStream _outputStream;
    private boolean _isFactoryProduced;

    public static XMLObjectWriter newInstance(OutputStream outputStream) throws XMLStreamException {
        XMLObjectWriter xMLObjectWriter = (XMLObjectWriter)FACTORY.object();
        xMLObjectWriter._isFactoryProduced = true;
        xMLObjectWriter.setOutput(outputStream);
        return xMLObjectWriter;
    }

    public static XMLObjectWriter newInstance(OutputStream outputStream, String string) throws XMLStreamException {
        XMLObjectWriter xMLObjectWriter = (XMLObjectWriter)FACTORY.object();
        xMLObjectWriter._isFactoryProduced = true;
        xMLObjectWriter.setOutput(outputStream, string);
        return xMLObjectWriter;
    }

    public static XMLObjectWriter newInstance(Writer writer) throws XMLStreamException {
        XMLObjectWriter xMLObjectWriter = (XMLObjectWriter)FACTORY.object();
        xMLObjectWriter._isFactoryProduced = true;
        xMLObjectWriter.setOutput(writer);
        return xMLObjectWriter;
    }

    public XMLStreamWriter getStreamWriter() {
        return this._xml._writer;
    }

    public XMLObjectWriter setOutput(OutputStream outputStream) throws XMLStreamException {
        if (this._outputStream != null || this._writer != null) {
            throw new IllegalStateException("Writer not closed or reset");
        }
        this._xml._writer.setOutput(outputStream);
        this._outputStream = outputStream;
        this._xml._writer.writeStartDocument();
        return this;
    }

    public XMLObjectWriter setOutput(OutputStream outputStream, String string) throws XMLStreamException {
        if (this._outputStream != null || this._writer != null) {
            throw new IllegalStateException("Writer not closed or reset");
        }
        this._xml._writer.setOutput(outputStream, string);
        this._outputStream = outputStream;
        this._xml._writer.writeStartDocument();
        return this;
    }

    public XMLObjectWriter setOutput(Writer writer) throws XMLStreamException {
        if (this._outputStream != null || this._writer != null) {
            throw new IllegalStateException("Writer not closed or reset");
        }
        this._xml._writer.setOutput(writer);
        this._writer = writer;
        this._xml._writer.writeStartDocument();
        return this;
    }

    public XMLObjectWriter setBinding(XMLBinding xMLBinding) {
        this._xml.setBinding(xMLBinding);
        return this;
    }

    public XMLObjectWriter setIndentation(String string) {
        this._xml._writer.setIndentation(string);
        return this;
    }

    public XMLObjectWriter setReferenceResolver(XMLReferenceResolver xMLReferenceResolver) {
        this._xml.setReferenceResolver(xMLReferenceResolver);
        return this;
    }

    public void write(Object object) throws XMLStreamException {
        this._xml.add(object);
    }

    public void write(Object object, String string) throws XMLStreamException {
        this._xml.add(object, string);
    }

    public void write(Object object, String string, String string2) throws XMLStreamException {
        this._xml.add(object, string, string2);
    }

    public <T> void write(T t, String string, Class<T> clazz) throws XMLStreamException {
        this._xml.add(t, string, clazz);
    }

    public <T> void write(T t, String string, String string2, Class<T> clazz) throws XMLStreamException {
        this._xml.add(t, string, string2, clazz);
    }

    public void flush() throws XMLStreamException {
        this._xml._writer.flush();
    }

    public void close() throws XMLStreamException {
        try {
            if (this._outputStream != null) {
                this._xml._writer.writeEndDocument();
                this._xml._writer.close();
                this._outputStream.close();
                this.reset();
            } else if (this._writer != null) {
                this._xml._writer.writeEndDocument();
                this._xml._writer.close();
                this._writer.close();
                this.reset();
            }
            if (this._isFactoryProduced) {
                FACTORY.recycle(this);
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void reset() {
        this._xml.reset();
        this._outputStream = null;
        this._writer = null;
    }
}

