%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/lilypond-2.24.3/input/regression/make-relative-music.ly"
\sourcefileline 0
\version "2.19.22"

\header {
  texidoc = "@code{make-relative} can make relativization on music
function calls behave as one would expect from looking at the
function's arguments rather than at the actually resulting
expressions.  This regtest defines an example function
@code{\\withOctave} which works equally well inside and outside of
@code{\\relative}."
}

withOctave =
#(define-music-function (music)
  (ly:music?)
  (make-relative
   (music) music
   #{ \context Bottom << $music \transpose c c' $music >> #}))

mus = {
  \partial 4. c'8 e g |
  c2 e,4 g |
  c,8 c' b a <g d'> <f c'> <e b'> <d a'> |
  <c g'>1 | \bar "|."
}

<<
  \relative \new Staff { <>^"original" \mus }
  \relative \new Staff { <>^\markup \typewriter "\\relative \\withOctave"
			 \withOctave \mus }
  \new Staff { <>^\markup \typewriter "\\withOctave \\relative"
	       \withOctave \relative \mus }
>>



% ****************************************************************
% end ly snippet
% ****************************************************************
