/*
 * Oh Hell!
 *
 * Copyright (C) Evan Harris, 1991, 1993, 1994
 *
 * Permission is granted to freely redistribute and modify this code,
 * providing the author(s) get credit for having written it.
 */

#define TRUE			1
#define FALSE			0

#define QUIT			-1
#define NEWGAME			-2
#define SAVE			-4
#define OPEN			-5

#define NEXTGAME		-7
#define CONTINUE		-8

#define SPADES			0
#define CLUBS			1
#define HEARTS			2
#define DIAMONDS		3

#define NUMSUITS		4
#define NUMPLAYERS		4
#define NUMCARDS		52
#define NUMHANDS		(NUMCARDS / NUMPLAYERS)

#define CARD(suit, type)	((suit) * 13 + (type))
#define SUIT(card)		(((card) % 52) / 13)
#define TYPE(card)		((card) % 13)
#define ISCARD(card)		((card) >= 0 && (card) < 104)
#define ISBLACK(card)		(SUIT(card) == SPADES || SUIT(card) == CLUBS)
#define ISRED(card)		(SUIT(card) == HEARTS || SUIT(card) == DIAMONDS)
#define NOCARD			255
#define NOSUIT			4

#define TYPECMP(a, b)		((((a) + 12) % 13) > (((b) + 12) % 13) ? 1 : -1)

#define ACE			0
#define TWO			1
#define THREE			2
#define FOUR			3
#define FIVE			4
#define SIX			5
#define SEVEN			6
#define EIGHT			7
#define NINE			8
#define TEN			9
#define JACK			10
#define QUEEN			11
#define KING			12

extern unsigned char	hand[NUMPLAYERS][NUMHANDS];


/* ohhell.c */
void InitGame(void);
short PlayGame(unsigned char, unsigned char);
unsigned char Deal(unsigned char);
short GetBid(unsigned char, unsigned char, unsigned char);
short GetPlay(unsigned char, unsigned char, unsigned char);
int Cmp(unsigned char *, unsigned char *);

/* ohlinux.c / ohamiga.c */
void InitDisplay(int, char **);
void EndDisplay(void);
void InitRandom(void);
long Random(long);
void ShowPlay(unsigned char, unsigned char);
void RemovePlays(void);
void ShowHand(unsigned char *, unsigned char);
void ShowWins(unsigned char *);
void ShowBid(unsigned char, unsigned char);
void RemoveBids(void);
void ShowScores(unsigned char *);
void ShowTrumps(unsigned char);
void RemoveTrumps(void);
short GetPlayerBid(unsigned char);
short GetCmd(void);
short WaitForKey(void);
#if 0
void FlushIn(void);
#endif
