.bp
.SH
.ce
PLOTSET RESOURCES
.SH
Overview
.LP
Plotset Resources are used to control the shape, size and appearance of a plot.
.LP
.so plot_pr.tms
.bp
.SH
Resource Specification
.RS
.SH
.ul
Plot Titles
.IP "\fBxlabel\fP" 12
Specifies the x-axis label.  Defaults to "X-Axis".
.IP "\fBylabel\fP" 12
Specifies the y-axis label.  Defaults to "Y-Axis".
.IP "\fBzlabel\fP" 12
Specifies the z-axis label. Used only in 3D plots. Defaults to "Z-Axis".
.IP "\fBtoplabel\fP" 12
Specifies the plot title, which appears above the plot itself.
Defaults to "PLOT".
.IP "\fBsubtitle\fP" 12
Specifies an additional title, which appears in a smaller font below 
the plot title.  By default this title is left blank.
.IP "\fBcomment\fP" 12
Specifies an additional title. This title appears in the upper-right corner
of the plot.  By default this title is left blank.
.IP "\fBsidelabel\fP
Specifies whether the curve labels and contour color labels are to be
plotted on the side of the plot.  Defaults to \fBTrue\fP.
.SH
.ul
Plot Aspect-ratio/Appearance
.IP "\fBgrid\fP" 12
Specifies whether a dotted grid is drawn within the 2D plot.  Grid intervals
depends on the axis-scale values. Defaults to \fBFalse\fP.
.IP "\fBequalscale\fP" 12
Specifies whether the 2D plot is drawn with equally-scaled x and y axes.
If \fBTrue\fP, the plot-distance per unit in x and y are set equal; thus if
the x-limits are equal to the y-limits the plot will be square-shaped.
Note that if x and y differ significantly in magnitude, setting
\fIequalscale=True\fP will result in a long narrow rectangular plot.
If \fIequalscale=False\fP, and \fIfitpage=True\fP, 
the x and y scale factors will
be chosen such that the plot fills the page.  
If \fIequalscale=False\fP, and \fIfitpage=False\fP, 
the plot is drawn with aspect ratio \fIxyratio\fP.
Default \fPequalscale\fP value is \fBTrue\fP.
.br
Note: Use the View Resource \fPaxisscale\fP to control the aspect ratio of
a 3D plot.
.IP "\fBfitpage\fP" 12
Used with \fIequalscale\fP to set the 2D plot aspect ratio.
Defaults to \fBTrue\fP.
.IP "\fBxyratio\fP" 12
Specifies the 2D plot y:x aspect ratio, i.e. the ratio of the
plot-height (y) to the plot-width (x). Used only if both \fIequalscale=False\fP
and \fIfitpage=False\fP. Default value is 0.75.
.SH
.ul
Axis-Scales
.IP "\fBxautorange\fP" 12
Specifies whether automatic ranging is used to plot axis-scales on the
x-axis.  Automatic ranging
causes the program to select the best axis-scales possible for the
x-axis. Both major and minor ticks are drawn; tick intervals depend on the
range of axis-values.  
When \fBFalse\fP, the axis is drawn 
with \fIxticks\fP equally-spaced major tickmarks.
Defaults to \fBTrue\fP.  
.IP "\fBxticks\fP" 12
Sets the number of major ticks on the x-axis.
Specifying this option also turns off automatic ranging of the x-axis.
Minor ticks are not drawn.  Default value is 4.
.IP "\fByautorange\fP" 12
Specifies whether automatic ranging is used to plot axis-scales on the
y-axis.  
See the description of \fBxautorange\fP.
Defaults to \fBTrue\fP.  
.IP "\fByticks\fP" 12
Sets the number of major ticks on the y-axis.
See the description of \fBxticks\fP.
Default value is 4.
.IP "\fBzautorange\fP" 12
Specifies whether automatic ranging is used to plot axis-scales on the
z-axis.  
See the description of \fBxautorange\fP.
Defaults to \fBTrue\fP.  
.IP "\fBzticks\fP" 12
Sets the number of major ticks on the z-axis.
See the description of \fBxticks\fP.
Default value is 4.
.IP "\fBautorange\fP" 12
Equivalent to setting \fIxautorange\fP, \fIyautorange\fP, and
\fIzautorange\fP simultaneously.
.IP "\fBxlog\fP" 12
Specifies if the x-axis is to be drawn on a logarithmic or linear scale.
When \fBTrue\fP, major tick marks are drawn at every logarithmic decade
(multiple of 10.0), while minor tickmarks are drawn at every integer value
within the decade.  Defaults to \fBFalse\fB.
.IP "\fBylog\fP" 12
Specifies if the y-axis is to be drawn on a logarithmic or linear scale.
Defaults to \fBFalse\fB.
.IP "\fBzlog\fP" 12
Specifies if the z-axis is to be drawn on a logarithmic or linear scale.
Defaults to \fBFalse\fB.
.IP "\fBxscale\fP" 12
Specifies the scale factor for the x-axis scale labels. This is useful when the
x-ordinate values are very large or very small; the scale values are then
divided by \fIxscale\fP before being placed on the plot.  For example, if
the plot has major ticks at 1.2e10 and 1.3e10, and \fIxscale\fP=1e10, then
the tick labels will show "1.2" and "1.3", and a "(\(mu 1e10)" label will be
appended to the x-axis label.  Defaults to 1.0.
.IP "\fByscale\fP" 12
Specifies the scale factor for the y-axis scale labels. 
See the description of \fBxscale\fP.
Defaults to 1.0.
.IP "\fBzscale\fP" 12
Specifies the scale factor for the z-axis scale labels.
See the description of \fBxscale\fP.
Defaults to 1.0.
.SH
.ul
Plot Boundaries
.IP "\fBxmin\fP" 12
Sets the minimum x-axis value of the plot boundary.
.IP "\fBxmax\fP" 12
Sets the maximum x-axis value of the plot boundary.
.IP "\fBymin\fP" 12
Sets the minimum y-axis value of the plot boundary.
.IP "\fBymax\fP" 12
Sets the maximum y-axis value of the plot boundary.
.IP "\fBzmin\fP" 12
Sets the minimum z-axis value of the plot boundary.
.IP "\fBzmax\fP" 12
Sets the maximum z-axis value of the plot boundary.
.SH
.ul
Miscellaneous Options
.IP "\fBxflip\fP" 12
Specifies whether the direction of increasing x is to be reversed.
If \fBFalse\fP, the minimum x-value is placed to the left of the maximum
x-value on the plot; x increases from left to right.
If \fBTrue\fP, the minimum x-value is placed to the right of the maximum
x, and x increases from right to left.  
This gives the appearance of flipping the plot about the x-axis.
Defaults to \fBFalse\fP.
.IP "\fByflip\fP" 12
Specifies whether the direction of increasing y is to be reversed.
If \fBFalse\fP, the minimum y-value is placed underneath the maximum
y-value on the plot; y increases from bottom to top.
If \fBTrue\fP, the minimum y-value is placed above the maximum
y, and y increases from top to bottom.  
This gives the appearance of flipping the plot about the y-axis.
Defaults to \fBFalse\fP.
.IP "\fBxabs\fP" 12
Specifies if the data is to be plotted against the absolute value of the
x-ordinate.
Defaults to \fBFalse\fP.
.IP "\fByabs\fP" 12
Specifies if the data is to be plotted against the absolute value of the
y-ordinate.
Defaults to \fBFalse\fP.
.IP "\fBzabs\fP" 12
Specifies if the data is to be plotted against the absolute value of the
z-ordinate.
Defaults to \fBFalse\fP.
.IP "\fBoverlay\fP" 12
Specifies if datasets overlaid in the same plot are to be modified.
If \fBTrue\fP, the line-types and line-colors of contours and curves are
jogged so as to provide contrast between the different datasets.
Defaults to \fBTrue\fP.
.RE
.bp
.SH 
.ce
3D VIEW RESOURCES
.SH
Overview
.LP
View Resources affect the shape and viewing angle of the 3D plot.
These resources are used to select the appropriate view of the 3D plot.
.LP
.so view_pr.tms
.SH
Resource Specification
.RS
.SH
.ul
View Point
.IP "\fBeyepos.x\fP" 12
.IP "\fBeyepos.y\fP" 12
.IP "\fBeyepos.z\fP" 12
Specify the eye-position relative to the view center.  
The 3D eye-position (or viewing vector) defaults to (1.0, 1.5, 0.5).
.IP "\fBviewcenter.x\fP" 12
.IP "\fBviewcenter.y\fP" 12
.IP "\fBviewcenter.z\fP" 12
Specify the view-center about which the 3D data is to be viewed.
By default, the view-center is placed at the center of the plot-boundaries,
e.g. \fIviewcenter.x\fP = 0.5(\fIxmin\fP+\fIxmax\fP), where \fIxmin\fP
and \fIxmax\fP are the boundaries of the plot in x (specified in Plotset
Resources).
.IP "\fBwindow.xmin\fP" 12
.IP "\fBwindow.xmax\fP" 12
.IP "\fBwindow.ymin\fP" 12
.IP "\fBwindow.ymax\fP" 12
Specify the relative size of the 2D window in the 3D plot. The 2D window
dimensions are used to zoom or pan on selected areas of the 3D plot.
By default, \fIwindow.xmin\fP=-0.7, \fIwindow.xmax\fP=0.7,
\fIwindow.ymin\fP=-0.7 and \fIwindow.ymax\fP=0.7.
.SH
.ul
Axis Options
.IP "\fBaxislabel\fP" 12
Specifies whether to plot the axis labels in the 3D plot.
Default value is \fBTrue\fP.
.IP "\fBaxismove\fP" 12
Specifies whether the plot axis labels and tickmarks rotate as the 
view is rotated. In a 3D plot, only 1 of 4 possible axes in x, y, or z 
has labels and tickmarks attached to it. 
If \fIaxismove\fP is \fBFalse\fP, the axes are plotted such 
that the labeled z-axis is always on the
left-most side of the plot, while the x and y labeled axes are always on the 
bottom sides of the view cube closest to the eye.
If \fBTrue\fP, the labeled plot axes are fixed to specific coordinates 
and rotate as the view rotates. The default is \fBFalse\fP.
.IP "\fBaxisscale\fP" 12
Specifies whether the axes are scaled unequally. If \fBTrue\fP, the unequal
scaling results in a cube-like plot, where the x, y and z axes have the same
length regardless of the actual boundary range.
If \fBFalse\fP, the axes are scaled proportionally to the actual boundary
range. The default is \fBTrue\fP.
.SH
.ul
Miscellaneous Options
.IP "\fBleftworld\fP" 12
Specifies whether to use a left-handed coordinate system or a right-handed
coordinate system.  If \fBTrue\fP, a left-handed coordinate system is used.
The default is \fBTrue\fP.
.IP "\fBhiddenline\fP"
Specifies whether polygons are drawn with hidden lines/surfaces.
The hiddenline routine uses a simple painter's algorithm; polygons further
from the eye are drawn first and obscured or painted over by polygons closer
to the eye.
Default is \fBFalse\fP.
.IP "\fBpaintcube\fP" 12
Specifies whether the inner surfaces making up the view cube are painted.
Default is \fBFalse\fP.
.RE
.bp
.SH 
.ce
DATASET RESOURCES
.SH
Overview
.LP
Dataset Resources are used to modify the properties of
contour, vector, mesh and curve datasets.
.LP
.so data_pr.tms
.SH
Resource Specification
.RS
.SH
.ul
Contour Options
.IP "\fBcontstyle\fP" 12
Specifies the contour plot style. \fIcontstyle=1\fP results in contour
lines, \fIcontstyle=2\fP causes the regions between adjacent contours to be
filled with gradated
colors, while \fIcontstyle=3\fP causes the 3D surface mesh to be drawn in
place of contours.  \fIcontstyle=1\fP and \fIcontstyle=2\fP, when used in
combination with \fImeshplot=True\fP causes contours and the underlying mesh
to be drawn simultaneously. By default, \fIcontstyle=1\fP.
.IP "\fBcontfill\fP" 12
Specifies whether to draw contours in gradated colors. \fIcontfill=True\fP is
equivalent to setting \fIcontstyle=2\fP, while \fIcontfill=False\fP corresponds
to \fIcontstyle=1\fP.
.IP "\fBcstep\fP" 12
Causes contours to be selected with a constant step-size of \fIcstep\fP.
This results in equally-spaced contour increments inside the given
[\fIcmin\fP, \fIcmax\fP] limits.  However, the minimum and maximum contour
values do NOT necessarily correspond to the minimum and maximum limits
of the quantity; the values of the contours are rounded so as to obtain
numerically-pleasing values.  For example, with \fIcmin\fP=0.36 
and \fIcmax\fP=1.03, contour values of z=0.4, 0.5, ... 1.0 are obtained.  
By default, contours are plotted
using a \fIcstep\fP value corresponding to roughly 10 equally spaced
contours.
.IP "\fBnsteps\fP" 12
Causes contours to be selected with a constant step-size of 
\fI(cmax-cmin)/nsteps\fP.
The contours are selected inclusive of \fIcmin\fP and \fIcmax\fP,
resulting in levels at z=cmin, z=cmin+i(cmax-cmin)/nsteps, ... z=cmax.
For example, with \fIcmin\fP=0.36, \fIcmax\fP=1.03 and \fInsteps=5\fP,
contour values of z=0.36, 0.494, 0.628, 0.762, 0.896, and 1.03 are obtained.
If \fInsteps=0\fP, a single contour is drawn at \fI0.5(cmin+cmax)\fP.
The default value is 10.
.br
Note: If \fInsteps\fP is NOT explicitly specified, the contours are
calculated using the \fBcstep\fP option, where
\fIcstep = rounded_value_of((cmax-cmin)/10)\fP.
.IP "\fBlogsteps\fP" 12
Specifies the number of contours to be plotted in a logarithmic decade.
Setting \fIlogsteps\fP causes contours to be selected with logarithmic
spacing, which is preferred
for plotting data which ranges widely in magnitude.
If \fIlogsteps=1\fP, the ratio between adjacent contours is
10.0 and contours are rounded to the nearest power of 10.  For
example, if the quantity ranges in z-value from 0.5e10 to 3.2e15, contours
will be plotted at 1e10, 1e11, 1e12, 1e13, 1e14 and 1e15.
\fIlogsteps\fP values greater than 1 cause more than one contour to be
plotted per decade, e.g. \fIlogsteps\fP=2 plots contours at 1e10, 5e10,
1e11, etc.  The default \fIlogsteps\fP value is 1.
.IP "\fBcontour\fP" 12
Specifies a string of contour values. The string has the syntax : 
\fIcontour="([new] value1 value2 ...)"\fP where \fIvalue1\fP etc 
are user-defined contour levels; the optional \fI"new"\fP character
string causes all previously specified contour values to be over-written.
Multiple \fIcontour\fP statements can be used together, provided that each
statement is on a separate line; \fIcontour\fP statements following the
first \fIcontour\fP statement append their contour values to the current
list.
By default, \fIcontour\fP is a blank string, and the contour levels
are selected automatically using any of \fBcstep\fP, \fBnsteps\fP, and
\fBlogsteps\fP.
.IP "\fBcmin\fP" 12
.IP "\fBcmax\fP" 12
Specify the range in which contours are to be plotted.
These default respectively to the minimum and maximum z-values of the
data in the selected dataset.
.IP "\fBlinetypes\fP" 12
Specifies the number of line-types for the contour plot. Valid values range
from 1 to 3.  The default is to use 2 line-types, in which case 
major contours are drawn in solid lines while minor contours are drawn dashed.
.IP "\fBcontlabel\fP" 12
Specifies whether contour labels are to be placed on contour lines.
\fIcontlabel\fP is ignored when drawing colored contours
(\fPcontstyle=2\fP).
.IP "\fBcontclip\fP" 12
Specifies if the filled contours are to be plotted for values greater than
\fBcmin\fP and \fBcmax\fP.  \fIcontclip\fP defaults to \fIFalse\fP; if 
\fIcontstyle=2\fP, then the contours are filled above and below the
specified color ranges.  For example, if contours are specified at 
values of 0.1, 0,2 and 0.3, data-ranges less than 0.1 and greater than 0.3
will be filled as well.  But if \fIcontclip=True\fP, then only the contours
between 0.1 and 0.3 will be filled with colors.
.IP "\fBinterpolate\fP" 12
Specifies the contour interpolation style for rectangular-grid-based data.
By default, \fIinterpolate=0\fP, and each rectangle in the grid is plotted
as is. If \fIinterpolate=1\fP or \fIinterpolate=2\fP, each rectangle is
split up into 2 or 4 triangles respectively.  The distinction between
rectangles and triangles is made because the 4 points of a single rectangle 
in 3D space are often not coplanar. 
Finally, \fIinterpolate=3\fP is a special scheme where the data is broken up
into planar rectangles with constant z-values; each rectangle is centered
about the data-points on the original rectangular grid.
.IP "\fBlogx\fP" 12
.IP "\fBlogy\fP" 12
.IP "\fBlogz\fP" 12
Specifies whether contours are to be calculated using logarithmic or linear
interpolation.  Typically, contour data with a wide range of values
is plotted using logarithmically varying steps and logarithmic interpolation
in z (\fIlogz=True\fP).  By default, \fIlogx=False\fP, \fIlogy=False\fP and
\fIlogz=False\fP.
.SH
.ul
Mesh Options
.IP "\fBmeshplot\fP" 12
Specifies whether the underlying mesh is to be plotted.  Particularly
useful for contour plots and mesh-based datasets.  Default is \fBFalse\fP.
.IP "\fBboundary\fP" 12
Specifies whether the outlines of the device materials are to be plotted.
Useful only for mesh-based datasets.  Default is \fBTrue\fP.
.IP "\fBfillbound\fP" 12
Specifies whether the various device regions are to be filled with colors
corresponding to different materials. Regions with identical materials are
plotted in identical colors. Useful only for mesh-based datasets.  Default
is \fBFalse\fP.
.SH
.ul
Vector Options
.IP "\fBvlog\fP" 12
Specifies whether vectors are to be plotted on a logarithmic or linear
scale.  If \fBTrue\fP, the length of the vectors is proportional to the
logarithm of the vector magnitude.  Default is \fBFalse\fP.
.IP "\fBvlogscale\fP" 12
Specifies the scale factor for vectors plotted on a logarithmic scale.
The default scaling is based on the boundary limits of the data and the
logarithm of the maximum magnitude of the vectors.
.IP "\fBvscale\fP" 12
Specifies the scale factor for vectors plotted on a linear scale.
The default scaling is based on the boundary limits of the data and the
maximum magnitude of the vectors.
.IP "\fBvhead\fP" 12
Specifies whether the vectors are to be plotted with arrow-heads.
Only vectors of sufficient length (as determined by dimensions on the plot)
are plotted with arrow-heads.  Default is \fBTrue\fP.
.IP "\fBvtail\fP" 12
Specifies whether the vectors are to be plotted with cross-tails.
Default is \fBFalse\fP.
.SH
.ul
Debugging Options
.IP "\fBprintID\fP" 12
Specifies whether the various element integer identifiers are to be printed
on the plot.  Equivalent to setting \fBpointID\fP, \fBnodeID\fP etc
individually.
.IP "\fBpointID\fP" 12
Specifies whether point integer identifiers are to be printed on the plot.  
Points are contained in CURVE, CONTOUR, GRID and MESH-based datasets. 
Default is \fBFalse\fP.
.IP "\fBnodeID\fP" 12
Specifies whether node integer identifiers are to be printed on the plot.  
Nodes are connected to points, and contained in CONTOUR, GRID and MESH-based 
datasets. 
Default is \fBFalse\fP.
.IP "\fBtriaID\fP" 12
Specifies whether triangle integer identifiers are to be printed on the plot.  
Triangles are connected to nodes which in turn are connected to points;
triangles are contained in CONTOUR, GRID and MESH-based datasets. 
Default is \fBFalse\fP.
.IP "\fBrectID\fP" 12
Specifies whether rectangle integer identifiers are to be printed on the plot.  
Rectangles are connected to nodes which in turn are connected to points;
rectangles are contained in CONTOUR and GRID datasets. 
Default is \fBFalse\fP.
.IP "\fBregionID\fP" 12
Specifies whether region integer identifiers are to be printed on the plot.  
Regions are connected to nodes which in turn are connected to points;
regions are contained only in MESH-based datasets.
Default is \fBFalse\fP.
.SH
.ul
Curve Options
.IP "\fBsplinetype\fP" 12
Specifies if spline interpolation is to be used to connect the points on a
curve.  
Applies to CONTOUR and CURVE datasets only.
6 splinetypes are provided.  The Cubic B-Spline (\fIsplinetype\fP=1),
Doubled Cubic B-Spline (\fIsplinetype\fP=2), 
Quadratic B-Spline (\fIsplinetype\fP=3)
produce curves that approximate the control points; the curves 
pass close to but do not go through the actual data points.
Catmull-Rom Splines (\fIsplinetype\fP=4) pass through the control points 
but can produce wild variations in between points. Quadratic Bezier Spline
(\fIsplinetype\fP=5)
and Cubic Bezier Spline 
(\fIsplinetype\fP=6)
curves hit the midpoints of the control points.
The default, \fIsplinetype\fP=0 is to connect the data-points 
using straight lines. 
.IP "\fBapplyfill\fP" 12
Specifies whether curves with specified fills are actually filled.
If \fBFalse\fP, only the curve outlines are plotted.  Actually a useful
debugging aid for inspecting overlapping curves. Applies only to CURVE
datasets.
Default is \fBTrue\fP.
.SH
.ul
Miscellaneous Options
.IP "\fBannotate\fP"
Specifies whether annotations attached to the specified dataset are to be
plotted.  If \fBFalse\fP, the annotations are not plotted.
Allows multiple datasets to be overlaid without too much confusion due to
overlapping annotations.
Default is \fBTrue\fP.
.RE
.bp
.SH
.ce
CURVE RESOURCES
.SH
Overview
.LP
Curve Resources are used to modify the properties of curves
in contour and curve datasets.
.LP
.so curv_pr.tms
.bp
.SH
Resource Specification
.RS
.SH
.ul
Lines
.IP "\fBlinelabel\fP" 12
Specifies a label (legend) to be placed to the left of the plot.
For contour-curves, the label is placed at various locations 
on the curve itself.
Default is a blank string.
.IP "\fBlinewidth\fP" 12
Specifies the width of the line to be used in drawing the curve.
Default is 1.
.IP "\fBlinetype\fP" 12
Specifies the type of line-pattern to be used in drawing the curve.
Line-patterns include solid lines, dashed lines and dotted lines.
See Curve Property Table for details.  Default is 1 (solid line).
.IP "\fBlinecolor\fP" 12
Specifies the color to be used in drawing the curve.
Colors are approximated by gray-scales for black-and-white Postscript
plots.
Default is 1 (yellow). 
.SH
.ul
Markers
.IP "\fBmarkersize\fP" 12
Specifies the size of markers on the curve.  The default value is 1, which
is the smallest size.
.IP "\fBmarkertype\fP" 12
Specifies the markertype to be used in drawing the points on the curve.
The default value is 0, in which case markers are not plotted.
.IP "\fBmarkercolor\fP"
Specifies the color to be used in drawing the markers.
Colors are approximated by gray-scales for black-and-white Postscript
plots.
Default is 1 (yellow).
.SH
.ul
Fills
.IP "\fBfilltype\fP" 12
Specifies the filltype to be used in drawing the curve. 
The default is 0, in which case only the outline of the curve is drawn.
.br
Note: The \fIfilltype\fP is ignored if the Dataset Resource \fBapplyfill\fP
is \fBFalse\fP.
.IP "\fBfillcolor\fP" 12
Specifies the color to be used in the fill-pattern.
Colors are approximated by gray-scales for black-and-white Postscript
plots.
Default is 1 (yellow).
.RE
.bp
.SH
.ce
GLOBAL CURVE RESOURCES
.SH
Overview
.LP
Global Curve Resources are used to modify the properties of \fIall\fP the
curves in contour and curve datasets. These resources are used primarily to
set the default properties for curves; Curve Resources are then used to set
properties of individual curves. Note that the argument names of Global Curve
Resources differ from Curve Resource names only by a "d" in at the beginning
of the name.
.LP
.so gbcv_pr.tms
.bp
.SH
Resource Specification
.RS
.SH
.ul
Lines
.IP "\fBdlinewidth\fP" 12
Specifies the width of the line to be used in drawing the curve.
Default is 1.
.IP "\fBdlinetype\fP" 12
Specifies the type of line-pattern to be used in drawing the curve.
Line-patterns include solid lines, dashed lines and dotted lines.
See Curve Property Table for details.  Default is 1 (solid line).
.IP "\fBdlinecolor\fP" 12
Specifies the color to be used in drawing the curve.
Colors are approximated by gray-scales for black-and-white Postscript
plots.
Default is 1 (yellow). 
.SH
.ul
Markers
.IP "\fBdmarkersize\fP" 12
Specifies the size of markers on the curve.  The default value is 1, which
is the smallest size.  
.IP "\fBdmarkertype\fP" 12
Specifies the markertype to be used in drawing the points on the curve.
The default value is 0, in which case markers are not plotted.
.IP "\fBdmarkercolor\fP"
Specifies the color to be used in drawing the markers.
Colors are approximated by gray-scales for black-and-white Postscript
plots.
Default is 1 (yellow).
.SH
.ul
Fills
.IP "\fBdfilltype\fP" 12
Specifies the filltype to be used in drawing the curve. 
The default is 0, in which case only the outline of the curve is drawn.
.br
Note: The \fIdfilltype\fP is ignored if the Dataset Resource \fBapplyfill\fP
is \fBFalse\fP.
.IP "\fBdfillcolor\fP" 12
Specifies the color to be used in the fill-pattern.
Colors are approximated by gray-scales for black-and-white Postscript
plots.
Default is 1 (yellow).
.RE
