
/*
 *
$Log: state.c,v $
 * Revision 1.7  1993/06/16  20:12:54  wade
 * CONFERENCE was misspelled
 *
 * Revision 1.6  1993/06/12  17:48:06  browne
 * *** empty log message ***
 *
 * Revision 1.4  1993/04/19  21:35:58  wade
 * added database state
 *
 * Revision 1.3  1992/12/15  21:06:05  wade
 * using text instead of bitmaps for contextual help
 *
 * Revision 1.2  1992/12/05  16:59:18  larose
 * added logging
 *
 *
 */

#include "xnl.h"

void Handle_state(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Mode_last = Mode;

    /* first set things to the NORMAL scene before setting desired mode */
    switch (Mode) {
     case MODE_NORMAL:
        break;
     case MODE_RECEIVE:
        if (Popdown_receive(w))
            Mode = MODE_NORMAL;
        break;
     case MODE_UPDATE:
        if (Popdown_update(w))
            Mode = MODE_NORMAL;
        break;
     case MODE_CLASSIFICATION:
        if (Popdown_classification(w))
            Mode = MODE_NORMAL;
        break;
     case MODE_DATABASE:
#ifdef CONFERENCE
        if (Popdown_database(w))
            Mode = MODE_NORMAL;
#endif
        break;
     case MODE_KEYWORD:
        if (Popdown_keyword(w))
            Mode = MODE_NORMAL;
        break;
/*
     case MODE_REXEC:
        if (Popdown_rexec(w))
            Mode = MODE_NORMAL;
        break;
*/
     case MODE_WHO:
        if (Popdown_who(w))
            Mode = MODE_NORMAL;
        break;
     case MODE_HELP:
        if (Popdown_help(w))
            Mode = MODE_NORMAL;
        break;
     case MODE_INDEX:
        if (Popdown_index(w))
            Mode = MODE_NORMAL;
        break;
     case MODE_MOTD:
        if (Popdown_motd(w))
            Mode = MODE_NORMAL;
        break;
#ifdef STUB
     case MODE_STUB:
        if (Popdown_stub(w))
            Mode = MODE_NORMAL;
        break;
#endif
#ifdef PERFORMANCE
     case MODE_PERFORMANCE:
        if (Popdown_performance(w))
            Mode = MODE_NORMAL;
        break;
#endif
     case MODE_LIBRARY:
        if (Popdown_library(w))
            Mode = MODE_NORMAL;
        break;
     case MODE_LIBSELECT:
        if (Popdown_libSelect(-1))
            Mode = MODE_NORMAL;
        break;
     case MODE_CLASSSELECT:
        if (Popdown_classSelect(w))
            Mode = MODE_NORMAL;
        break;
     case MODE_QUIT:
        Mode = MODE_NORMAL;
        break;
     default:
        fprintf(stderr, "Handle_state(): bogus mode %d\n", Mode);
        break;
    }


    /* now try setting to desired */
    if ((Mode == MODE_LIBSELECT) || (Mode == MODE_NORMAL))    /* otherwise we're not allowed right now */
        switch (Mode_desired) {
         case MODE_NORMAL:
            set_status(STATUS_DEFAULT, WHITE);
            break;
         case MODE_RECEIVE:
            if (Popup_receive(w))
                Mode = MODE_RECEIVE;
            break;
         case MODE_UPDATE:
            if (Popup_update(w))
                Mode = MODE_UPDATE;
            break;
         case MODE_CLASSIFICATION:
            if (Popup_classification(w))
                Mode = MODE_CLASSIFICATION;
            break;
         case MODE_DATABASE:
#ifdef CONFERENCE
            if (Popup_database(w))
                Mode = MODE_DATABASE;
#endif
            break;
         case MODE_KEYWORD:
            if (Popup_keyword(w))
                Mode = MODE_KEYWORD;
            break;
/*
         case MODE_REXEC:
            if (Popup_rexec(w))
                Mode = MODE_REXEC;
            break;
*/
         case MODE_WHO:
            if (Popup_who(w))
                Mode = MODE_WHO;
            break;
         case MODE_HELP:
            if (Popup_help(w))
                Mode = MODE_HELP;
            break;
         case MODE_INDEX:
            if (Popup_index(w))
                Mode = MODE_INDEX;
            break;
         case MODE_MOTD:
            if (Popup_motd(w))
                Mode = MODE_MOTD;
            break;
#ifdef STUB
         case MODE_STUB:
            if (Popup_stub(w))
                Mode = MODE_STUB;
            break;
#endif
#ifdef PERFORMANCE
         case MODE_PERFORMANCE:
            if (Popup_performance(w))
                Mode = MODE_PERFORMANCE;
            break;
#endif
         case MODE_LIBRARY:
            if (Popup_library(w))
                Mode = MODE_LIBRARY;
            break;
         case MODE_LIBSELECT:
            if (Mode_last != MODE_LIBSELECT)
                Last_list_index = Curr_list_index;
            if (Popup_libSelect(Last_list_index))
                Mode = MODE_LIBSELECT;
            break;
         case MODE_QUIT:
            XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
            exit(0);
            break;
         default:
            fprintf(stderr, "Handle_state(): bogus desired mode %d\n", Mode_desired);
            break;
        }

		if ((helpPic) && con_help[Mode]) {
			Arg args[3];
			XtSetArg(args[0], XtNstring, con_help[Mode]);
			XtSetValues (helpPic, args, 1);
		}
}
