------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                    S Y S T E M . V A L U E _ E N U M                     --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with System.Normalize_String;
with Unchecked_Conversion;

function System.Value_Enum
  (A        : Address;
   Last_Pos : Natural;
   Str      : String)
   return     Natural
is
   type String_Access is access String;
   type Enum_Table is array (Natural) of String_Access;
   type Enum_Table_Ptr is access Enum_Table;
   function A_To_T is new Unchecked_Conversion (Address, Enum_Table_Ptr);

   F : Natural;
   L : Natural;
   S : String (Str'range) := Str;
   T : constant Enum_Table_Ptr := A_To_T (A);

begin
   System.Normalize_String (S, F, L);

   for J in 0 .. Last_Pos loop
      if T (J).all = S (F .. L) then
         return J;
      end if;
   end loop;

   raise Constraint_Error;
end System.Value_Enum;
