------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                      S Y S T E M . S C A N _ L L I                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.1 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This function scans a long long integer value from a string

function System.Scan_LLI
  (Str  : String;
   Ptr  : access Natural;
   Max  : Natural)
   return Long_Long_Integer;
--  This function scans the string starting at Str (Ptr.all) for a valid
--  integer according to the syntax described in (RM 3.5(43)). The substring
--  scanned extends no further than Str (Max). There are three cases for the
--  return:
--
--  If a valid integer is found after scanning past any initial spaces, then
--  Ptr.all is updated past the last character of the integer (but trailing
--  spaces are not scanned out).
--
--  If no valid integer is found, then Ptr.all points either to an initial
--  non-digit character, or to Max + 1 if the field is all spaces and the
--  exception Constraint_Error is raised.
--
--  If a syntactically valid integer is scanned, but the value is out of
--  range, or, in the based case, the base value is out of range or there
--  is an out of range digit, then Ptr.all points past the integer, and
--  Constraint_Error is raised.
--
--  Note: these rules correspond to the requirements for leaving the pointer
--  positioned in Text_Io.Get
