------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                         I N T E R F A C E S . C                          --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.5 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Unchecked_Conversion;

package Interfaces.C is
pragma Pure (Interfaces.C);

   --  Declaration's based on C's <limits.h>

   CHAR_BIT  : constant := 8;
   SCHAR_MIN : constant := -128;
   SCHAR_MAX : constant := 127;
   UCHAR_MAX : constant := 255;

   --  Signed and Unsigned Integers. Note that in GNAT, we have ensured that
   --  the standard predefined Ada types correspond to the standard C types

   type Int   is new Integer;
   type Short is new Short_Integer;
   type Long  is new Long_Integer;

   type Signed_Char is range SCHAR_MIN .. SCHAR_MAX;
   for Signed_Char'Size use CHAR_BIT;

   type Unsigned       is mod 2 ** Integer'Size;
   type Unsigned_Short is mod 2 ** Short_Integer'Size;
   type Unsigned_Long  is mod 2 ** Long_Integer'Size;

   type Unsigned_Char is mod (UCHAR_MAX + 1);
   for Unsigned_Char'Size use CHAR_BIT;

   subtype Plain_Char is Unsigned_Char; -- ??? should be parametrized

   type Ptrdiff_T is new Integer;       -- ??? should be parametrized

   type Size_T is mod 2 ** 32;          -- ??? should be parametrized

   --  Floating-Point

   type Float       is new Standard.Float;
   subtype C_Float  is Float;

   type Double      is new Standard.Long_Float;

   type Long_Double is new Standard.Long_Long_Float;

   --  Characters and Strings

   --  type Char is new Character;
   subtype Char is Character;
   --  We don't yet allow derivation from type Character ???

   Nul : constant Char := Char'First;

   function To_C   (Item : Character) return Char;
   function To_Ada (Item : Char)      return Character;

   type Char_Array is array (Natural range <>) of Char;
   pragma Pack (Char_Array);

   --  for Char_Array'Component_Size use CHAR_BIT;
   --  Component_Size not yet supported ???

   function To_C
     (Item       : in String;
      Append_Nul : in Boolean := True)
      return       Char_Array;

   function To_Ada
     (Item     : in Char_Array;
      Trim_Nul : in Boolean := True)
      return     String;

   procedure To_C
     (Item       : in String;
      Target     : out Char_Array;
      Last       : out Integer;
      Append_Nul : in Boolean := True);

   procedure To_Ada
     (Item     : in Char_Array;
      Target   : out String;
      Last     : out Natural;
      Trim_Nul : in Boolean := True);

   --  Wide Character and Wide String

   --  type WChar_T is new Wide_Character;
   subtype WChar_T is Wide_Character;
   --  Derivation from type Wide_Character not yet supported ???

   Wide_Nul : constant WChar_T := WChar_T'First;

   function To_C   (Item : in Wide_Character) return WChar_T;
   function To_Ada (Item : in WChar_T)        return Wide_Character;

   type Wide_Char_Array is array (Natural range <>) of WChar_T;
   pragma Pack (Wide_Char_Array);

   function To_C
     (Item       : in Wide_String;
      Append_Nul : in Boolean := True)
      return       Wide_Char_Array;

   function To_Ada
     (Item     : in Wide_Char_Array;
      Trim_Nul : in Boolean := True)
      return     Wide_String;

   procedure To_C
     (Item       : in Wide_String;
      Target     : out Wide_Char_Array;
      Last       : out Integer;
      Append_Nul : in Boolean := True);

   procedure To_Ada
     (Item     : in Wide_Char_Array;
      Target   : out Wide_String;
      Last     : out Natural;
      Trim_Nul : in Boolean := True);

   Unterminated : exception;

private

   function Character_To_Char is new
     Unchecked_Conversion (Character, Char);

   function Char_To_Character is new
     Unchecked_Conversion (Char, Character);

   function WChar_T_To_Wide_Character is new
     Unchecked_Conversion (WChar_T, Wide_Character);

   function Wide_Character_To_WChar_T is new
     Unchecked_Conversion (Wide_Character, WChar_T);

   function To_C (Item : Character) return Char
     renames Character_To_Char;

   function To_Ada (Item : Char) return Character
     renames Char_To_Character;

   function To_C (Item : in Wide_Character) return WChar_T
     renames Wide_Character_To_WChar_T;

   function To_Ada (Item : in WChar_T) return Wide_Character
     renames WChar_T_To_Wide_Character;

end Interfaces.C;
