-----------------------------------------------------------------------------
--                                                                         --
--                GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                         --
--             S Y S T E M . S T O R A G E _ A L L O C A T I O N           --
--                                                                         --
--                                 S p e c                                 --
--                                                                         --
--                            $Revision: 1.3 $                              --
--                    (corresponds to FSU revision 1.4)                     --
--                                                                          --
--           Copyright (c) 1992,1993,1994 FSU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with System.Storage_Elements;

package System.Storage_Allocation is

   procedure Allocate_Block
     (Storage_Address : out System.Address;
      Storage_Size    : Storage_Elements.Storage_Count;
      Alignment       : in Storage_Elements.Storage_Count);

   procedure Deallocate_Block (Storage_Address : System.Address);

   function Maximum_Storage return Storage_Elements.Storage_Count;

end System.Storage_Allocation;
