------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                  A D A . N U M E R I C S _ R A N D O M                   --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

package Ada.Numerics.Random_Numbers is

   type Generator is limited private;

   Number_Of_Seed_Components : constant := 1;

   type Seed is array (1 .. Number_Of_Seed_Components) of Integer;

   Seed_Error : exception;

   subtype Uniformly_Distributed is Float range 0.0 .. 1.0;

   function Random (Gen : Generator) return Uniformly_Distributed;

   procedure Get_Seed (Gen   : in  Generator;
                       Value : out Seed);

   procedure Set_Seed (Gen   : in  Generator;
                       Value : in  Seed);

   procedure Reset (Gen       : in Generator;
                    Initiator : in Integer);

   procedure Reset (Gen       : in Generator);

private
   type Generator is record
      Current_Seed : Seed;     --  temporary ???
   end record;
end Ada.Numerics.Random_Numbers;
