------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                     A D A . C A L E N D A R . A U X                      --
--                                                                          --
--                                 B o d y                                  --
--                              (BSD Version)                               --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This version of the package uses the BSD function gettimeofday which
--  returns the time in microsecond units. Of course we can't guarantee that
--  it is microsecond accurate, but it is likely to be more accurate than the
--  use of the standard Unix function clock which returns a count of seconds.

package body Ada.Calendar.Aux is

   ----------------
   -- Clock_Read --
   ----------------

   function Clock_Read return Time is

      type timeval is record
         tv_sec  : Integer;           -- seconds since Jan 1, 1970
         tv_usec : Integer;           -- and microseconds
      end record;

      type timezone is record
         tz_minuteswest : Integer;    -- of Greenwich (GMT)
         tz_dsttime     : Integer;    -- type of dst correction to apply
      end record;

      type tp is access timeval;
      type tzp is access timezone;

      tp_Val  : aliased timeval;
      tzp_Val : aliased timezone;

      function gettimeofday (tp_Val : tp; tzp_Val : tzp) return Integer;
      pragma Import (C, gettimeofday);

      Discard : Integer;

   begin
      Discard := gettimeofday (tp_Val'access, tzp_Val'access);
      return (Val => Duration (tp_Val.tv_sec) +
                     Duration (tp_Val.tv_usec) / 1.0e-6);

   end Clock_Read;

end Ada.Calendar.Aux;
