with Instr; use Instr;
with Gen_List;
with Io; use Io;
procedure Demo1 is 

   type Acc is access Instrument'Class;
    
   package Dash_Board is new Gen_List (Acc);
   use Dash_Board;
   
   procedure Print_Dash_Board (L : List) is
      L1 : List := L;
   begin

      while L1 /= Nil loop
         Display_Value (Element (L1).all);
         L1 := Tail (L1);
      end loop;
      
      New_Line;
      
   end Print_Dash_Board;


   Speed : aliased Speedometer;
   Fuel : aliased Gauge;
   Oil, Water : aliased Graphic_Gauge;
   Time : aliased Clock;
   Chrono : aliased Chronometer;

   DB : List := Nil;
   
begin
   Speed.Name  := "Speed               ";
   Fuel.Name   := "Fuel                ";   
   Water.Name  := "Water               ";
   Oil.Name    := "Oil                 ";
   Time.Name   := "Time                ";
   Chrono.Name := "Chronometer         ";

--   Set_Name (Speed, "Speed");
--   Set_Name (Fuel, "Fuel");   
--   Set_Name (Water, "Water");
--   Set_Name (Oil, "Oil");
--   Set_Name (Time, "Time");
--   Set_Name (Chrono, "Chronometer");

   Speed.Value := 45; --  mph
   Fuel.Value := 60; --  %   
   Water.Value := 80; -- %
   Oil.Value := 30; --  %   
   Init (Time, 12, 15, 00);
   Init (Chrono, 22, 12, 56);
   
   DB := Append   (Acc (Speed'Access), 
           Append (Acc (Fuel'Access), 
           Append (Acc (Water'Access),
           Append (Acc (Oil'Access),
           Append (Acc (Time'Access), Acc (Chrono'Access))))));

   Print_Dash_board (DB);

end Demo1;
