/* $Id: tf.connect.h,v 30000.20 1993/05/04 22:39:44 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef TF_CONNECT_H
#define TF_CONNECT_H

/**************************************************
 * Fugue connection header                        *
 * Needed by socket.c and (optional) tf.connect.c *
 **************************************************/

#ifdef CONNECT_SVR4
# define CONNECT
#endif

#ifdef CONNECT_BSD
# define CONNECT
# ifndef __osf__
   /* OSF disables send()/recv() when 4.4BSD fd passing is enabled.  Why?!? */
#  ifdef SCM_RIGHTS
#   define CONNECT_BSD44
#  endif
# endif
#endif

#ifdef CONNECT_BSD44
# define CONTROLLEN (sizeof(struct cmsghdr) + sizeof(int))
#endif

#define TFC_OK                0
#define TFC_CANT_FIND         1
#define TFC_SERVICE           2
#define TFC_ESOCKET           3
#define TFC_ECONNECT          4
#define TFC_ESTAT             5
#define TFC_EPIPE             6
#define TFC_ESOCKETPAIR       7
#define TFC_EPOPEN            8
#define TFC_ERECV             9
#define TFC_ERECVMSG         10

#endif /* TF_CONNECT_H */
