/* $Id: world.h,v 30000.20 1993/05/04 22:39:57 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef WORLD_H
#define WORLD_H

#define WORLD_TEMP     001
#define WORLD_CONN     002
#define WORLD_ACTIVE   004

typedef struct World {         /* World structure */
    int flags;
    struct World *next;
    char *name, *character, *pass, *address, *port, *mfile;
    struct Sock *socket;       /* open socket, if any */
    struct History *history;   /* history and logging info */
    struct Queue *queue;       /* buffer for unprocessed lines */
} World;


extern int    FDECL(addworld,(char *args));
extern World *FDECL(new_world,(char *name, char *character, char *pass,
                    char *address, char *port, char *mfile));
extern int    FDECL(remove_world,(char *args));
extern int    FDECL(purge_world,(char *args));
extern int    FDECL(write_worlds,(char *args));
extern void   FDECL(list_worlds,(int full, char *pattern, TFILE *file));
extern void   FDECL(free_world,(World *w));
extern void   FDECL(nuke_world,(World *w));
extern World *NDECL(get_default_world);
extern World *NDECL(get_world_header);
extern World *FDECL(find_world,(char *name));
extern void   FDECL(flush_world,(World *w));

#endif /* WORLD_H */
