;;; Lisp-like macros
; These macros return values via /echo.  Use $() command subs to catch output.

/def car = /echo -- %1
/def cdr = /echo -- %-1
/def cadr = /echo -- %2
/def cddr = /echo -- %-2
/def caddr = /echo -- %3
/def cdddr = /echo -- %-3

/def length = /echo %#

/def reverse = \
    /if /test %# > 0%; \
    /then \
        /echo -- $(/reverse %-1) %1%;\
    /endif

/def mapcar = \
    /if /test %# > 1%; \
    /then \
        /eval %1 %2%;\
        /mapcar %1 %-2%;\
    /endif

/def maplist = \
    /if /test %# > 1%; \
    /then \
        /eval %1 %-1%;\
        /maplist %1 %-2%;\
    /endif
