/* utils.c */

#include "copyright.h"

#include <stdio.h>

#include "config.h"
#include "interface.h"
#include "db.h"

#ifdef HPUX
#include <stdlib.h>
#endif

void parse_attrib(player, str, thing, attrib)
     dbref player;
     char *str;
     dbref *thing;
     ATTR **attrib;
{
  /* takes a string which is of the format <obj>/<attr> or <attr>,
   * and returns the dbref of the object, and a pointer to the attribute.
   * If no object is specified, then the dbref returned is the player's.
   * str is destructively modified.
   */

  char *name;

  /* find the object */

  if ((name = (char *) index(str, '/')) != NULL) {
    *name++ = '\0';
    init_match(player, str, NOTYPE);
    match_everything();
    *thing = noisy_match_result();
  } else {
    name = str;
    *thing = player;
  }

  /* find the attribute */
  *attrib = (ATTR *) atr_get(*thing, upcasestr(name));
}


dbref find_entrance(door)
    dbref door;
{
  dbref room;
  dbref thing;
  for (room = 0; room < db_top; room++)
    if (Typeof(room) == TYPE_ROOM) {
      thing = db[room].exits;
      while (thing != NOTHING) {
	if (thing == door)
	  return room;
	thing = db[thing].next;
      }
    }
  return NOTHING;
}

/* remove the first occurence of what in list headed by first */
dbref remove_first(first, what)
    dbref first;
    dbref what;
{
  dbref prev;
  /* special case if it's the first one */
  if (first == what) {
    return db[first].next;
  } else {
    /* have to find it */
    DOLIST(prev, first) {
      if (db[prev].next == what) {
	db[prev].next = db[what].next;
	return first;
      }
    }
    return first;
  }
}

int member(thing, list)
    dbref thing;
    dbref list;
{
  DOLIST(list, list) {
    if (list == thing)
      return 1;
  }

  return 0;
}

int recursive_member(disallow, from, count) 
    dbref disallow;
    dbref from;
    int count;
{
  dbref contents = db[from].contents;

  if (count > 50) return 0;
  DOLIST(contents, contents) {
    count++;
    return ((from == disallow) ||
	    (contents == disallow) ||
	    recursive_member(disallow, contents, count));
  }
  return 0;
}

dbref reverse(list)
    dbref list;
{
  dbref newlist;
  dbref rest;
  newlist = NOTHING;
  while (list != NOTHING) {
    rest = db[list].next;
    PUSH(list, newlist);
    list = rest;
  }
  return newlist;
}

/* takes a dbref and returns a pointer to the head of a dblist */
struct dblist *
listcreate(ref)
dbref ref;
{
  struct dblist *ptr;
  
  ptr = (struct dblist *)malloc((unsigned)sizeof(struct dblist));
  if (!ptr)
	  panic("Out of memory.");
  ptr->obj = ref;
  ptr->next = NULL;
  return(ptr);
}

/*
 * takes a pointer to a dblist and a dbref and adds the dbref to the
 * end of the list.
 */
void
listadd(head, ref)
struct dblist *head;
dbref ref;
{
  struct dblist *ptr = head;
	

  while (ptr->next)
	  ptr = ptr->next;
  
  ptr->next = listcreate(ref);
}

/* takes a pointer to a dblist and recursively frees it */
void
listfree(head)
struct dblist *head;
{
  struct dblist *ptra = head, *ptrb;

  while (ptra->next) {
    ptrb = ptra->next;
    free(ptra);
    ptra = ptrb;
  }
}

int my_random(x)
     int x;
{
  int result;
#ifdef HPUX
  result = (int) ((float)x * ((float)rand() / RAND_MAX));
#else
   result = (int) ( ((float)x * (float)rand())/2147477000.0);
#endif
  return result;
}

int getrandom(x)
     int x;
{
   int temprandoms[20];
   int i;
   if (x < 1)
      x = 1;
   for (i = 0; i < 20; i++) 
      temprandoms[i] = my_random(x);
   i = my_random(20);

   return temprandoms[i];
}

unsigned hash_fn(s, hashtab_mask)
     char *s;
     int hashtab_mask;
{
  /* hash function, using masks (based on TinyMUSH 2.0) */

  unsigned hashval;
  char *p;

  for (hashval = 0, p = s; *p; p++)
    hashval = (hashval << 5) + hashval + *p;
  return (hashval & hashtab_mask);
}

int is_number(str)
     char *str;
{
    /* is a string a number? */

    while (*str && isspace(*str))	/* trim leading spaces */
	str++;

    if (*str == '-') {
	str++;
	if (!*str)
	    return 0;			/* just a minus sign. no good. */
    }

    while (*str && isdigit(*str))	/* the number */
	str++;

#ifdef FLOATING_POINTS
    if (*str == '.')		/* decimal point */
	str++;
    while (*str && isdigit(*str))	/* the fractional part */
	str++;
#endif

  while (*str && isspace(*str))	/* trim trailing spaces */
    str++;

  return (*str ? 0 : 1);
}
